/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_SKYSUB_H
#define QMOST_SKYSUB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * @file qmost_skysub.h
 */

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              New types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 * @ingroup qmost_skysub
 * @struct qmost_skysub_diags
 * Structure to return sky subtraction diagnostic information used to
 * build the optional sky and eigendecomposition diagnostics files.
 */
/*----------------------------------------------------------------------------*/

typedef struct {
    /** @brief Eigenvectors */
    cpl_image *eigenvectors;
    /** @brief Table giving eigenvalues */
    cpl_table *eigeninfo;
    /** @brief Original observed sky spectra in sky fibres */
    cpl_image *orig_img;
    /** @brief Original observed sky variance spectra in sky fibres */
    cpl_image *orig_var;
    /** @brief Information table with statistics per sky fibre */
    cpl_table *skyinfo;
    /** @brief Combined mean sky spectrum */
    cpl_image *comb_img;
    /** @brief Combined mean sky variance spectrum */
    cpl_image *comb_var;
    /** @brief Residuals of masked sky subtraction */
    cpl_image *subt_img;
    /** @brief Variance of sky lines each fibre */
    cpl_image *subt_var;
} qmost_skysub_diags;

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_skysub_vshiftpca (
    cpl_image *spec_img,
    cpl_image *spec_var,
    cpl_propertylist *spec_hdr,
    cpl_table *fibinfo_tbl,
    int neigen,
    float smoothing,
    int doscale,
    float wmin,
    float wmax,
    int resid_filt,
    qmost_skysub_diags *diags);

CPL_END_DECLS

#endif  /* QMOST_SKYSUB_H */
