from edps import classification_rule

from . import qmost_keywords as kwd
from . import qmost_rules as rules

# Definition of QMOST calibrations and science data.

qmost = { kwd.instrume: "QMOST" }
calib_keywords = {**qmost, kwd.dpr_catg: "CALIB"}
science_keywords = {**qmost, kwd.dpr_catg: "SCIENCE"}

# Raw types.

raw_bias_class = classification_rule(
  "BIAS",
  {**calib_keywords, kwd.dpr_type: "BIAS"})

raw_dark_class = classification_rule(
  "DARK",
  {**calib_keywords, kwd.dpr_type: "DARK"})

raw_detector_flat_class = classification_rule(
  "DETECTOR_FLAT",
  {**calib_keywords, kwd.dpr_type: "FLAT,LED"})

raw_detector_flat_lin_class = classification_rule(
  "DETECTOR_FLAT_LIN",
  {**calib_keywords, kwd.dpr_type: "FLAT,LIN"})

raw_fibre_flat_day_class = classification_rule(
  "FIBRE_FLAT_DAY",
  {**calib_keywords, kwd.dpr_type: "FLAT,DAY"})

raw_fibre_wave_simuarc_class = classification_rule(
  "FIBRE_WAVE_SIMUARC",
  {**calib_keywords, kwd.dpr_type: "WAVE,DAY,SIMUARC"})

raw_fibre_wave_simufpe_class = classification_rule(
  "FIBRE_WAVE_SIMUFPE",
  {**calib_keywords, kwd.dpr_type: "WAVE,DAY,SIMUFPE"})

raw_fibre_wave_day_class = classification_rule(
  "FIBRE_WAVE_DAY",
  {**calib_keywords, kwd.dpr_type: "WAVE,DAY"})

raw_fibre_flat_sky_class = classification_rule(
  "FIBRE_FLAT_SKY",
  {**calib_keywords, kwd.dpr_type: "FLAT,SKY"})

raw_fibre_flat_night_class = classification_rule(
  "FIBRE_FLAT_NIGHT",
  {**calib_keywords, kwd.dpr_type: "FLAT,NIGHT"})

raw_fibre_wave_night_class = classification_rule(
  "FIBRE_WAVE_NIGHT",
  {**calib_keywords, kwd.dpr_type: "WAVE,NIGHT"})

raw_science_class = classification_rule(
  "OBJECT",
  {**science_keywords, kwd.dpr_type: "OBJECT"})

# Static calibrations.

master_bpm_class = classification_rule(
  "MASTER_BPM",
  {**qmost, kwd.pro_catg: "MASTER_BPM"})

slit_mask_class = classification_rule(
  "SLIT_MASK",
  {**qmost, kwd.pro_catg: "SLIT_MASK"})

wave_map_class = classification_rule(
  "WAVE_MAP",
  {**qmost, kwd.pro_catg: "WAVE_MAP"})

arc_linelist_class = classification_rule(
  "ARC_LINELIST",
  {**qmost, kwd.pro_catg: "ARC_LINELIST"})

sensitivity_class = classification_rule(
  "SENSITIVITY",
  {**qmost, kwd.pro_catg: "SENSITIVITY"})

# Reference frames.

reference_bias_class = classification_rule(
  "REFERENCE_BIAS",
  {**qmost, kwd.pro_catg: "REFERENCE_BIAS"})

reference_dark_class = classification_rule(
  "REFERENCE_DARK",
  {**qmost, kwd.pro_catg: "REFERENCE_DARK"})

reference_detector_flat_class = classification_rule(
  "REFERENCE_DETECTOR_FLAT",
  {**qmost, kwd.pro_catg: "REFERENCE_DETECTOR_FLAT"})

reference_fibre_trace_class = classification_rule(
  "REFERENCE_FIBRE_TRACE",
  {**qmost, kwd.pro_catg: "REFERENCE_FIBRE_TRACE"})

reference_wave_class = classification_rule(
  "REFERENCE_WAVE",
  {**qmost, kwd.pro_catg: "REFERENCE_WAVE"})

# Master calibrations.
master_bias_class = classification_rule(
  "MASTER_BIAS",
  {**qmost, kwd.pro_catg: "MASTER_BIAS"})

master_dark_class = classification_rule(
  "MASTER_DARK",
  {**qmost, kwd.pro_catg: "MASTER_DARK"})

master_detector_flat_class = classification_rule(
  "MASTER_DETECTOR_FLAT",
  {**qmost, kwd.pro_catg: "MASTER_DETECTOR_FLAT"})

unfiltered_detector_flat_class = classification_rule(
  "UNFILTERED_DETECTOR_FLAT",
  {**qmost, kwd.pro_catg: "UNFILTERED_DETECTOR_FLAT"})

readgain_class = classification_rule(
  "READGAIN",
  {**qmost, kwd.pro_catg: "READGAIN"})

linearity_class = classification_rule(
  "LINEARITY",
  {**qmost, kwd.pro_catg: "LINEARITY"})

fibre_trace_class = classification_rule(
  "FIBRE_TRACE",
  {**qmost, kwd.pro_catg: "FIBRE_TRACE"})

fibre_mask_class = classification_rule(
  "FIBRE_MASK",
  {**qmost, kwd.pro_catg: "FIBRE_MASK"})

master_psf_class = classification_rule(
  "MASTER_PSF",
  {**qmost, kwd.pro_catg: "MASTER_PSF"})

simuarc_wave_class = classification_rule(
  "SIMUARC_WAVE",
  {**qmost, kwd.pro_catg: "SIMUARC_WAVE"})

fpe_linelist_class = classification_rule(
  "FPE_LINELIST",
  {**qmost, kwd.pro_catg: "FPE_LINELIST"})

master_wave_class = classification_rule(
  "MASTER_WAVE",
  {**qmost, kwd.pro_catg: "MASTER_WAVE"})

master_fibre_flat_class = classification_rule(
  "MASTER_FIBRE_FLAT",
  {**qmost, kwd.pro_catg: "MASTER_FIBRE_FLAT"})

ob_wave_class = classification_rule(
  "OB_WAVE",
  {**qmost, kwd.pro_catg: "OB_WAVE"})

ob_fibre_flat_class = classification_rule(
  "OB_FIBRE_FLAT",
  {**qmost, kwd.pro_catg: "OB_FIBRE_FLAT"})

sky_fibre_flat_class = classification_rule(
  "SKY_FIBRE_FLAT",
  {**qmost, kwd.pro_catg: "SKY_FIBRE_FLAT"})
