/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_STATS_H
#define QMOST_STATS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_med (
    float *data,
    unsigned char *bpm,
    int npts,
    float *value);

cpl_error_code qmost_dmed (
    double *data,
    unsigned char *bpm,
    int npts,
    double *value);

cpl_error_code qmost_medmad (
    float *data,
    unsigned char *bpm,
    int npts,
    float *medval,
    float *madval);

cpl_error_code qmost_dmedmad (
    double *data,
    unsigned char *bpm,
    int npts,
    double *medval,
    double *madval);

cpl_error_code qmost_medmadcut (
    float *data,
    unsigned char *bpm,
    int npts, 
    float lcut,
    float hcut,
    float *medval, 
    float *madval);

cpl_error_code qmost_meansig (
    float *data,
    unsigned char *bpm,
    int npts,
    float *mean,
    float *sig);

cpl_error_code qmost_meansigcut (
    float *data,
    unsigned char *bpm,
    int npts,
    float lcut,
    float hcut,
    float *mean,
    float *sig);

void qmost_sumbpm (
    unsigned char *bpm,
    int npts,
    int *sumb);

int qmost_firstgood (
    unsigned char *bpm,
    int npts);

int qmost_lastgood (
    unsigned char *bpm,
    int npts);

void qmost_skylevel (
    int *ihist,
    int ihmin,
    int ihmax,
    int mpix,
    float clip_low,
    float clip_high,
    int clip_niter,
    float *skylev,
    float *sigma,
    float *toplev);

cpl_error_code qmost_skylevel_image (
    cpl_image *image,
    int minlev,
    int maxlev,
    float clip_low,
    float clip_high,
    int clip_niter,
    float *skylev,
    float *sigma);

CPL_END_DECLS

#endif  /* QMOST_STATS_H */
