/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_EXTRACT_TRAM_H
#define QMOST_EXTRACT_TRAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_extract_tram (
    cpl_image *in_image,
    cpl_image *in_var,
    cpl_propertylist *in_hdr,
    cpl_table *trace_tbl,
    cpl_propertylist *trace_hdr,
    int iwidth,
    cpl_image **out_spec_img,
    cpl_image **out_spec_var,
    cpl_propertylist *out_spec_hdr);

cpl_error_code qmost_extract_qc (
    cpl_image *spec,
    cpl_image *v_spec,
    cpl_propertylist *qclist,
    cpl_table *fibinfo_tbl,
    int arm);

CPL_END_DECLS

#endif  /* QMOST_EXTRACT_TRAM_H */
