/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_SORT_H
#define QMOST_SORT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

void qmost_sort_f (
    float *a,
    int n);

void qmost_sort_ff (
    float *a,
    float *b,
    int n);

void qmost_sort_fff (
    float *a,
    float *b,
    float *c,
    int n);

void qmost_sort_ffff (
    float *a,
    float *b,
    float *c,
    float *d,
    int n);

void qmost_sort_fi (
    float *ia,
    int *ib,
    int n);

void qmost_sort_fui (
    float *a1,
    unsigned char *a2,
    int *a3,
    int n);

void qmost_sort_dd (
    double *ia,
    double *ib,
    int n);

void qmost_sort_di (
    double *ia,
    int *ib,
    int n);

void qmost_sort_rev_di (
    double *ia,
    int *ic,
    int n);

CPL_END_DECLS

#endif  /* QMOST_SORT_H */
