# QMOST_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([QMOST_SET_VERSION_INFO],
[
    qmost_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    qmost_major_version=`echo "$qmost_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    qmost_minor_version=`echo "$qmost_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    qmost_micro_version=`echo "$qmost_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$qmost_major_version"; then qmost_major_version=0
    fi

    if test -z "$qmost_minor_version"; then qmost_minor_version=0
    fi

    if test -z "$qmost_micro_version"; then qmost_micro_version=0
    fi

    QMOST_VERSION="$qmost_version"
    QMOST_MAJOR_VERSION=$qmost_major_version
    QMOST_MINOR_VERSION=$qmost_minor_version
    QMOST_MICRO_VERSION=$qmost_micro_version

    if test -z "$4"; then QMOST_INTERFACE_AGE=0
    else QMOST_INTERFACE_AGE="$4"
    fi

    QMOST_BINARY_AGE=`expr 100 '*' $QMOST_MINOR_VERSION + $QMOST_MICRO_VERSION`
    QMOST_BINARY_VERSION=`expr 10000 '*' $QMOST_MAJOR_VERSION + \
                          $QMOST_BINARY_AGE`

    AC_SUBST(QMOST_VERSION)
    AC_SUBST(QMOST_MAJOR_VERSION)
    AC_SUBST(QMOST_MINOR_VERSION)
    AC_SUBST(QMOST_MICRO_VERSION)
    AC_SUBST(QMOST_INTERFACE_AGE)
    AC_SUBST(QMOST_BINARY_VERSION)
    AC_SUBST(QMOST_BINARY_AGE)

    AC_DEFINE_UNQUOTED(QMOST_MAJOR_VERSION, $QMOST_MAJOR_VERSION,
                       [QMOST major version number])
    AC_DEFINE_UNQUOTED(QMOST_MINOR_VERSION, $QMOST_MINOR_VERSION,
                       [QMOST minor version number])
    AC_DEFINE_UNQUOTED(QMOST_MICRO_VERSION, $QMOST_MICRO_VERSION,
                       [QMOST micro version number])
    AC_DEFINE_UNQUOTED(QMOST_INTERFACE_AGE, $QMOST_INTERFACE_AGE,
                       [QMOST interface age])
    AC_DEFINE_UNQUOTED(QMOST_BINARY_VERSION, $QMOST_BINARY_VERSION,
                       [QMOST binary version number])
    AC_DEFINE_UNQUOTED(QMOST_BINARY_AGE, $QMOST_BINARY_AGE,
                       [QMOST binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# QMOST_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([QMOST_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/qmost'
    fi

    if test -z "$reportsdir"; then
        reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(workflowdir)
    AC_SUBST(reportsdir)

])


# QMOST_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([QMOST_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    QMOST_INCLUDES='-I$(top_srcdir)/qmost'
    QMOST_LDFLAGS='-L$(top_builddir)/qmost'

    # Library aliases

    LIBQMOST='$(top_builddir)/qmost/libqmost.la'

    # Substitute the defined symbols

    AC_SUBST(QMOST_INCLUDES)
    AC_SUBST(QMOST_LDFLAGS)

    AC_SUBST(LIBQMOST)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(QMOST_INCLUDES) $(HDRL_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES) $(XXCLIPM_INCLUDES)'
    all_ldflags='$(QMOST_LDFLAGS) $(HDRL_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS) $(XXCLIPM_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
