/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_DOARCS_H
#define QMOST_DOARCS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_doarcs_ref(
    cpl_image *in_spec,
    cpl_propertylist *in_hdr,
    cpl_image *ref_wave_surface,
    cpl_table *ref_wave_tbl,
    cpl_propertylist *ref_wave_hdr,
    cpl_table *linelist_tbl,
    cpl_table *trace_tbl,
    cpl_propertylist *trace_hdr,
    float detthr,
    float rejthr,
    int nord,
    float matchwindow,
    float matchgrid,
    cpl_table **out_wave_tbl);

cpl_error_code qmost_doarcs_ob(
    cpl_image *in_spec,
    cpl_propertylist *in_hdr,
    cpl_table *ref_wave_tbl,
    cpl_propertylist *ref_wave_hdr,
    cpl_table *linelist_tbl,
    cpl_table *trace_tbl,
    cpl_propertylist *trace_hdr,
    float detthr,
    float rejthr,
    int nord,
    float matchwindow,
    float matchgrid,
    cpl_table **out_wave_tbl);

cpl_error_code qmost_fpmeasure(
    cpl_image *in_spec,
    cpl_propertylist *in_hdr,
    cpl_table *ref_wave_tbl,
    cpl_propertylist *ref_wave_hdr,
    float detthr,
    float matchwindow,
    cpl_table **out_linelist_tbl,
    cpl_propertylist *qclist);

cpl_error_code qmost_fpcorr(
    cpl_propertylist *in_pri_hdr,
    cpl_propertylist *linelist_pri_hdr,
    float prescoef,
    float *prescorr);

CPL_END_DECLS

#endif  /* QMOST_DOARCS_H */
