from edps import match, match_rules
from edps.generator.time_range import RelativeTimeRange

from . import qmost_keywords as kwd

# Standard association rule used for detector calibrations requiring
# matching instrument, spectrograph and detector setup.

match_instrume_setup = (
  match_rules()
  .with_match_keywords(kwd.instrume_setup))

# Alternate association rule used for selection of detector
# calibrations in spectroscopic processing, requiring matching
# instrument and spectrograph but using the binning 1 detector
# calibrations if matched binning setting is not available.
# - first input, e.g. a=trigger (e.g. science)
# - second input, e.g. b=file to associate (e.g. calibration)

def match_function_bin_one(a, b):
  result = b[kwd.det_binx] == 1 and b[kwd.det_biny] == 1

  for key in kwd.instrume_spectro:
    if a[key] != b[key]:
      result = False

  return result

match_bin_one = (
  match_rules()
  .with_match_function(match_function_bin_one))

# Restricted time-range association helpers
PAST_SEVEN_DAYS = RelativeTimeRange(-7, 0)
PAST_ONE_DAY = RelativeTimeRange(-1, 0)
PAST_THIRTY_DAYS = RelativeTimeRange(-30, 0)

match_instrume_setup_last_week = (
  match_rules()
  .with_match_keywords(kwd.instrume_setup, time_range=PAST_SEVEN_DAYS))

match_bin_one_last_week = (
  match_rules()
  .with_match_function(match_function_bin_one, time_range=PAST_SEVEN_DAYS))

match_master_trace_last_week = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro, time_range=PAST_SEVEN_DAYS))

match_master_psf_last_day = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro, time_range=PAST_ONE_DAY))

match_master_wave_last_day = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro, time_range=PAST_ONE_DAY))

match_master_fibre_flat_last_week = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro, time_range=PAST_SEVEN_DAYS))

match_simufpe_last_month = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro, time_range=PAST_THIRTY_DAYS))

# Association rule for OB-level calibration frames requiring matching
# instrument, spectrograph, and same OB.

match_ob = (
  match_rules()
  .with_match_keywords(kwd.instrume_spectro_ob))
