from edps import SCIENCE, QC1_CALIB, QC0, CALCHECKER
from edps import task, alternative_associated_inputs
from .qmost_datasources import *
from .qmost_rules import *

# Detector calibrations.

bias_task = (
  task("bias")
  .with_recipe("qmost_bias_combine")
  .with_main_input(raw_bias_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_associated_input(reference_bias_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

dark_task = (
  task("dark")
  .with_recipe("qmost_dark_combine")
  .with_main_input(raw_dark_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_associated_input(bias_task, [ master_bias_class ], min_ret=0)
  .with_associated_input(reference_dark_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

detector_flat_task = (
  task("detector_flat")
  .with_recipe("qmost_detector_flat_analyse")
  .with_main_input(raw_detector_flat_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_associated_input(bias_task, [ master_bias_class ], min_ret=0)
  .with_associated_input(dark_task, [ master_dark_class ], min_ret=0)
  .with_associated_input(reference_detector_flat_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

detector_noise_task = (
  task("detector_noise")
  .with_recipe("qmost_detector_noise")
  .with_main_input(raw_detector_flat_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

linearity_task = (
  task("linearity")
  .with_recipe("qmost_linearity_analyse")
  .with_main_input(raw_detector_flat_lin_ds)
  .with_meta_targets([QC1_CALIB])
  .build())

# Alternative associated input directives used to feed detector
# calibrations into spectroscopic processing allowing for mismatched
# binning.  These try matching binning first, and then the binning 1
# frames by repeating the associated input with a different set of
# match rules.  These detector calibrations are always optional.
#
# The EDPS documentation says this should be done by specifying
# min_ret=0 in the last rule only, but that didn't seem to work for
# me, I found I had to specify it in all of the rules otherwise the
# input became mandatory.  Not sure what's going on here, but it seems
# to work.

master_bias_choices = (
  alternative_associated_inputs()
  .with_associated_input(bias_task, [ master_bias_class ], min_ret=0, match_rules=match_instrume_setup)
  .with_associated_input(bias_task, [ master_bias_class ], min_ret=0, match_rules=match_bin_one))

master_dark_choices = (
  alternative_associated_inputs()
  .with_associated_input(dark_task, [ master_dark_class ], min_ret=0, match_rules=match_instrume_setup)
  .with_associated_input(dark_task, [ master_dark_class ], min_ret=0, match_rules=match_bin_one))

master_detector_flat_choices = (
  alternative_associated_inputs()
  .with_associated_input(detector_flat_task, [ master_detector_flat_class ], min_ret=0,
                         match_rules=match_instrume_setup_last_week)
  .with_associated_input(detector_flat_task, [ master_detector_flat_class ], min_ret=0,
                         match_rules=match_bin_one_last_week))

# Daytime spectroscopic calibrations.

master_trace_task = (
  task("master_trace")
  .with_recipe("qmost_trace")
  .with_main_input(raw_fibre_flat_day_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(slit_mask_ds)
  .with_associated_input(reference_fibre_trace_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

master_psf_task = (
  task("master_psf")
  .with_recipe("qmost_psf_analyse")
  .with_main_input(raw_fibre_flat_day_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

simuarc_task = (
  task("simuarc")
  .with_recipe("qmost_arc_analyse")
  .with_main_input(raw_fibre_wave_simuarc_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_associated_input(wave_map_ds)
  .with_associated_input(arc_linelist_ds)
  .with_associated_input(reference_wave_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

simufpe_task = (
  task("simufpe")
  .with_recipe("qmost_fpe_analyse")
  .with_main_input(raw_fibre_wave_simufpe_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_associated_input(simuarc_task, [ simuarc_wave_class ])
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

master_wave_task = (
  task("master_wave")
  .with_recipe("qmost_arc_analyse")
  .with_main_input(raw_fibre_wave_day_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_associated_input(wave_map_ds)
  .with_associated_input(simufpe_task, [ fpe_linelist_class ], match_rules=match_simufpe_last_month)
  .with_associated_input(reference_wave_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

master_fibre_flat_task = (
  task("master_fibre_flat")
  .with_recipe("qmost_fibre_flat_analyse")
  .with_main_input(raw_fibre_flat_day_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_associated_input(master_psf_task, [ master_psf_class ], match_rules=match_master_psf_last_day)
  .with_associated_input(master_wave_task, [ master_wave_class ], match_rules=match_master_wave_last_day)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

# Twilight flat trace.  I'm reluctant to trace these given that this
# trace will inevitably fail when they're underexposed, but I think
# it's unavoidable for HRS where the extraction aperture could
# otherwise miss if we use a daytime trace due to thermal variations.
# This would cause a false estimate of the counts and thus the
# correction for fibre throughputs.

sky_trace_task = (
  task("sky_trace")
  .with_recipe("qmost_trace")
  .with_main_input(raw_fibre_flat_sky_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(slit_mask_ds)
  .with_associated_input(reference_fibre_trace_ds, min_ret=0)
  .with_meta_targets([QC1_CALIB])
  .build())

# Alternative associated input directive used to supply trace for
# twilight flat processing.  The trace of the twilight flats
# themselves is used where available, otherwise the master trace.  It
# would be desirable to check if the trace succeeded as well but I'm
# not sure if this is possible, we would have to look at extension
# headers unless I were to modify the trace recipe to emit something
# to the primary header saying if all the arms traced successfully.

sky_trace_choices = (
  alternative_associated_inputs()
  .with_associated_input(sky_trace_task, [ fibre_trace_class, fibre_mask_class ], match_rules=match_ob)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class],
                         match_rules=match_master_trace_last_week))

# Twilight fibre flat processing.

sky_fibre_flat_task = (
  task("sky_fibre_flat")
  .with_recipe("qmost_fibre_flat_analyse")
  .with_main_input(raw_fibre_flat_sky_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_alternative_associated_inputs(sky_trace_choices)
  .with_associated_input(master_psf_task, [ master_psf_class ], match_rules=match_master_psf_last_day)
  .with_associated_input(master_wave_task, [ master_wave_class ], match_rules=match_master_wave_last_day)
  .with_associated_input(master_fibre_flat_task, [ master_fibre_flat_class ],
                         match_rules=match_master_fibre_flat_last_week)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

# OB-level trace.

ob_trace_task = (
  task("ob_trace")
  .with_recipe("qmost_trace")
  .with_main_input(raw_fibre_flat_night_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(slit_mask_ds)
  .with_associated_input(reference_fibre_trace_ds, min_ret=0)
  .with_meta_targets([QC0, QC1_CALIB, CALCHECKER])
  .build())

# Alternative associated input directive used to supply trace for
# OB-level operations.  The OB-level trace from the same OB is used
# where available, otherwise the master trace.

ob_trace_choices = (
  alternative_associated_inputs()
  .with_associated_input(ob_trace_task, [ fibre_trace_class, fibre_mask_class ], match_rules=match_ob)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class],
                         match_rules=match_master_trace_last_week))

# OB-level attached fibre flat and wavelength solution.

ob_fibre_flat_task = (
  task("ob_fibre_flat")
  .with_recipe("qmost_fibre_flat_analyse")
  .with_main_input(raw_fibre_flat_night_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_alternative_associated_inputs(ob_trace_choices)
  .with_associated_input(master_psf_task, [ master_psf_class ], match_rules=match_master_psf_last_day)
  .with_associated_input(master_wave_task, [ master_wave_class ], match_rules=match_master_wave_last_day)
  .with_associated_input(master_fibre_flat_task, [ master_fibre_flat_class ],
                         match_rules=match_master_fibre_flat_last_week)
  .with_meta_targets([QC1_CALIB, CALCHECKER])
  .build())

ob_wave_task = (
  task("ob_wave")
  .with_recipe("qmost_arc_analyse")
  .with_main_input(raw_fibre_wave_night_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_alternative_associated_inputs(ob_trace_choices)
  .with_associated_input(simufpe_task, [ fpe_linelist_class ], match_rules=match_simufpe_last_month)
  .with_associated_input(master_wave_task, [ master_wave_class ], match_rules=match_master_wave_last_day)
  .with_meta_targets([QC0, QC1_CALIB, CALCHECKER])
  .build())

# Science.
# Updated to use daytime calibrations instead of nighttime OB-level calibrations
# (day flats are more stable than night ones see ticket QMOST-1872).

science_task = (
  task("science")
  .with_recipe("qmost_science_process")
  .with_main_input(raw_science_ds)
  .with_associated_input(master_bpm_ds, min_ret=0)
  .with_alternative_associated_inputs(master_bias_choices)
  .with_alternative_associated_inputs(master_dark_choices)
  .with_alternative_associated_inputs(master_detector_flat_choices)
  .with_associated_input(master_trace_task, [ fibre_trace_class, fibre_mask_class ],
                         match_rules=match_master_trace_last_week)
  .with_associated_input(master_psf_task, [ master_psf_class ], match_rules=match_master_psf_last_day)
  .with_associated_input(master_wave_task, [ master_wave_class ], match_rules=match_master_wave_last_day)
  .with_associated_input(master_fibre_flat_task, [ master_fibre_flat_class ], min_ret=0,
                         match_rules=match_master_fibre_flat_last_week)
  .with_associated_input(sky_fibre_flat_task, [ sky_fibre_flat_class ], min_ret=0)
  .with_associated_input(sensitivity_ds, min_ret=0)
  .with_meta_targets([QC0, SCIENCE, CALCHECKER])
  .build())
