from edps import data_source
from edps.generator.time_range import *
from .qmost_classification import *

# Raw detector calibration frames.  These are matched on spectrograph
# and detector readout (binning) settings.

raw_bias_ds = (
  data_source("BIAS")
  .with_classification_rule(raw_bias_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_setup,
                       time_range=ONE_WEEK,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_setup,
                       time_range=UNLIMITED,
                       level=3)
  .with_min_group_size(3)
  .build())

raw_dark_ds = (
  data_source("DARK")
  .with_classification_rule(raw_dark_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_setup,
                       time_range=ONE_MONTH,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_setup,
                       time_range=UNLIMITED,
                       level=3)
  .with_min_group_size(3)
  .build())

raw_detector_flat_ds = (
  data_source("DETECTOR_FLAT")
  .with_classification_rule(raw_detector_flat_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_setup,
                       time_range=ONE_MONTH,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_setup,
                       time_range=UNLIMITED,
                       level=3)
  .with_min_group_size(2)
  .build())

raw_detector_flat_lin_ds = (
  data_source("DETECTOR_FLAT_LIN")
  .with_classification_rule(raw_detector_flat_lin_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_setup,
                       time_range=ONE_MONTH,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_setup,
                       time_range=UNLIMITED,
                       level=3)
  .with_min_group_size(5)
  .build())

# Raw daytime spectroscopic calibration frames.  Setup includes full
# detector (det.binx, det.biny, det.read.curid) like BIAS; match rules
# use instrume_spectro so calibrations match on spectrograph only and
# binned science data can still find matching calibration frames.

raw_fibre_flat_day_ds = (
  data_source("FIBRE_FLAT_DAY")
  .with_classification_rule(raw_fibre_flat_day_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=ONE_WEEK,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

raw_fibre_wave_simuarc_ds = (
  data_source("FIBRE_WAVE_SIMUARC")
  .with_classification_rule(raw_fibre_wave_simuarc_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=ONE_MONTH,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

raw_fibre_wave_simufpe_ds = (
  data_source("FIBRE_WAVE_SIMUFPE")
  .with_classification_rule(raw_fibre_wave_simufpe_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=ONE_MONTH,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

raw_fibre_wave_day_ds = (
  data_source("FIBRE_WAVE_DAY")
  .with_classification_rule(raw_fibre_wave_day_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=ONE_DAY,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

# Twilight flats.  The calibration plan specifies that these should be
# taken every night, but we allow a more generous range here since
# this won't always be possible e.g. if weather is bad at twilight.
# In practice, the validity range should be the same as the master
# fibre flat since that is what we're correcting.

raw_fibre_flat_sky_ds = (
  data_source("FIBRE_FLAT_SKY")
  .with_classification_rule(raw_fibre_flat_sky_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=ONE_WEEK,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

# Raw night-time calibration frames.  The validity ranges for these
# are really "same OB", and this is set when they are used.

raw_fibre_flat_night_ds = (
  data_source("FIBRE_FLAT_NIGHT")
  .with_classification_rule(raw_fibre_flat_night_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=SAME_NIGHT,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

raw_fibre_wave_night_ds = (
  data_source("FIBRE_WAVE_NIGHT")
  .with_classification_rule(raw_fibre_wave_night_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=SAME_NIGHT,
                       level=0)   # calibration plan
  .with_match_keywords(kwd.instrume_spectro,
                       time_range=UNLIMITED,
                       level=3)
  .build())

# Raw science.

raw_science_ds = (
  data_source("OBJECT")
  .with_classification_rule(raw_science_class)
  .with_grouping_keywords([ kwd.tpl_start ] + kwd.instrume_setup)
  .with_setup_keywords(kwd.setup)
  .with_match_keywords(kwd.instrume_spectro)
  .build())

# Static calibrations.

master_bpm_ds = (
  data_source("MASTER_BPM")
  .with_classification_rule(master_bpm_class)
  .with_match_keywords(kwd.spectro)
  .build())

slit_mask_ds = (
  data_source("SLIT_MASK")
  .with_classification_rule(slit_mask_class)
  .with_match_keywords(kwd.spectro)
  .build())

wave_map_ds = (
  data_source("WAVE_MAP")
  .with_classification_rule(wave_map_class)
  .with_match_keywords(kwd.spectro)
  .build())

arc_linelist_ds = (
  data_source("ARC_LINELIST")
  .with_classification_rule(arc_linelist_class)
  .with_match_keywords(kwd.spectro)
  .build())

sensitivity_ds = (
  data_source("SENSITIVITY")
  .with_classification_rule(sensitivity_class)
  .with_match_keywords(kwd.spectro)
  .build())

# Reference frames.

reference_bias_ds = (
  data_source("REFERENCE_BIAS")
  .with_classification_rule(reference_bias_class)
  .with_match_keywords(kwd.instrume_setup)
  .build())

reference_dark_ds = (
  data_source("REFERENCE_DARK")
  .with_classification_rule(reference_dark_class)
  .with_match_keywords(kwd.instrume_setup)
  .build())

reference_detector_flat_ds = (
  data_source("REFERENCE_DETECTOR_FLAT")
  .with_classification_rule(reference_detector_flat_class)
  .with_match_keywords(kwd.instrume_setup)
  .build())

reference_fibre_trace_ds = (
  data_source("REFERENCE_FIBRE_TRACE")
  .with_classification_rule(reference_fibre_trace_class)
  .with_match_keywords(kwd.spectro)
  .build())

reference_wave_ds = (
  data_source("REFERENCE_WAVE")
  .with_classification_rule(reference_wave_class)
  .with_match_keywords(kwd.spectro)
  .build())
