
SUFFIXES += .ice .ice.cc .ice.h _ice.py
CLEANFILES += *.ice.cc *.ice.h
CLEANFILES += $(patsubst %.ice,%.h, $(filter %.ice, $(SOURCES))) 
CLEANFILES += $(patsubst %.ice,%.cc, $(filter %.ice, $(SOURCES)))

SLICE_INC = -I$(srcdir) $(ICE_SLICEFILES) -I$(prefix)/slice 
SLICE_COPT = --include-dir $(@D) --output-dir $(@D)
#SLICE_PYOPT = --output-dir $(DESTDIR)${pythondir}/
SLICE_PYOPT = --output-dir $(@D)

#BUILT_SOURCES = '$(patsubst %.ice,%.h, $(filter %.ice, $(SOURCES)))'

.ice.cc:
	if ! $(ICE_SLICE2CPP) $(SLICE_INC) $(SLICE_COPT) --source-ext=cc --header-ext=h $<; then \
           exit -1; \
  fi;

%.ice.cc %.ice.h: %.ice
	echo  compile $*
	if ! $(ICE_SLICE2CPP) $(SLICE_INC) $(SLICE_COPT) --source-ext=cc  --header-ext=h $<; then \
           exit -1; \
        fi;

%.ice.cc %.ice.h: $(SLICE_PATH)/%.ice
	echo  compile $*
	if ! $(ICE_SLICE2CPP) $(SLICE_INC) $(SLICE_COPT) --source-ext=cc  --header-ext=h $(SLICE_PATH)/$<; then \
           exit -1; \
        fi;

%_ice.py: %.ice
	echo do the monti ....
	test -d $(DESTDIR)${prefix}/${pythondir}/ || $(mkdir_p) $(DESTDIR)${pythondir}/
	if ! $(ICE_SLICE2PY) $(SLICE_INC) $(SLICE_PYOPT) $<; then \
           exit -1; \
        fi;

clean-local-ice: 


all-local-ice: 

install-data-hook-ice:
	@list='$(filter %.ice, $(SOURCES))'; \
   if test "x$(NOINSTALL)" == "x"; then \
     for i in $$list; do \
       $(install_sh_DATA) $(srcdir)/$$i $(DESTDIR)${prefix}/slice/$$i; \
       echo "$(install_sh_DATA) $(srcdir)/$$i $(DESTDIR)${prefix}/slice/$$i"; \
     done; \
   fi;
	@list='$(patsubst %.ice,%.h, $(filter %.ice, $(SOURCES)))'; \
   if test "x$(NOINSTALL)" == "x"; then \
     for i in $$list; do \
       $(install_sh_DATA) $$i $(DESTDIR)${includedir}/$$i; \
       echo "$(install_sh_DATA) $$i $(DESTDIR)${includedir}/$$i"; \
     done; \
   fi;

uninstall-hook-ice:
	@list='$(filter %.ice, $(SOURCES))'; \
     if test "x$(NOINSTALL)" == "x"; then \
       for i in $$list; do \
          rm -f $(DESTDIR)${prefix}/slice/$$i; \
          echo "rm -f $(DESTDIR)${prefix}/slice/$$i"; \
       done; \
     fi; 
	@list='$(patsubst %.ice,%.h, $(filter %.ice, $(SOURCES)))'; \
     if test "x$(NOINSTALL)" == "x"; then \
        for i in $$list; do \
          rm -f $(DESTDIR)${includedir}/$$i; \
          echo "rm -f $(DESTDIR)${includedir}/$$i"; \
        done; \
     echo $(patsubst %.py,%, $(nodist_python_PYTHON)) ${pythondir}; \
    fi;


#	@list='$(filter %.py, $(nodist_python_PYTHON) $(python_PYTHON))'; \
#        for i in $$list; do \
#          echo "rm -f $(DESTDIR)${pythondir}/$$i"; \
#        done;


