
SUFFIXES += .ui .ui.cc .moc.cc _moc.cc 
CLEANFILES += *.moc.cc *.ui.cc *_moc.cc 
CLEANFILES += $(patsubst %.ui,%.h, $(filter %.ui, $(SOURCES))) 
CLEANFILES += $(patsubst %.ui,%.cc, $(filter %.ui, $(SOURCES)))

.ui.cc:
	echo .ui.cc:
	if test "x$(USEQT3)"  != x; then \
          $(QT_UIC) -o $*.h $<; \
          $(QT_UIC) -o $*.cc -impl $*.h $<; \
          $(QT_MOC) $*.h >> $*.cc; \
        else \
          $(QT4_UIC) -o $*.h $<; \
          echo > $*.cc; \
        fi;

%.ui.cc: %.ui
	echo %.ui.cc: %.ui
	if test "x$(USEQT3)" != x; then \
          $(QT_UIC) -o $*.h $<; \
          $(QT_UIC) -o $*.ui.cc -impl $*.h $<; \
          $(QT_MOC) $*.h >> $*.ui.cc; \
        else \
          $(QT4_UIC) -o $*.ui.h $<; \
          echo > $*.ui.cc; \
        fi;


SUFFIXES += .qrc
CLEANFILES += $(patsubst %.qrc,%.cc, $(filter %.qrc, $(SOURCES)))
.qrc.cc:
	$(QT4_RCC) -name $* $< -o $*.cc; 



objects = $(HEADERS)

# This is for make > 2.8

.SECONDEXPANSION:
%.moc.cc: $$(nobase_%_HEADERS) $$(%_HEADERS) $$(nobase_%_SOURCES) $$(%_SOURCES)
	:> $@
	for i in $(nobase_$*_HEADERS) $($*_HEADERS) $(nobase_$*_SOURCES) $($*_SOURCES); do \
           if fgrep -q Q_OBJECT $(srcdir)/$$i; then \
             echo moccing $(srcdir)/$$i; \
             if test "x$(USEQT3)"  != x; then \
                $(QT_MOC) $(srcdir)/$$i >> $@; \
             else \
                $(QT4_MOC) $(QT4_CXXFLAGS) $(srcdir)/$$i >> $@; \
            fi; \
          fi; \
        done;

# This is for make <= 2.8
%_moc.cc: %.h
	if test "x$(USEQT3)" != x; then \
      $(QT_MOC) -o $@ $<; \
   else \
      $(QT4_MOC) $(QT4_CXXFLAGS) -o $@ $<; \
   fi;


all-local-qt:


clean-local-qt:
	@list='$(patsubst %.ui,%.h, $(filter %.ui, $(SOURCES))) $(patsubst %.ui,%.cc, $(filter %.ui, $(SOURCES)))'; \
        for i in $$list; do \
           rm -f $$i; \
           echo "rm -f $$i"; \
        done;

uninstall-hook-qt:
