from adari_core.data_libs.master_std_star_img import MasterStdStarImg
from adari_core.plots.text import TextPlot

from .sphere_utils import SphereSetupInfo, SphereReportMixin


class SphereStdStarReport(SphereReportMixin, MasterStdStarImg):

    def __init__(self):
        super().__init__("sphere_std_star")

    def parse_sof(self):

        isi_product = None
        isi_raw = None

        for filename, catg in self.inputs:
            if catg == "IRD_SCIENCE_IMAGING":
                isi_product = filename
            if catg == "IRD_SCIENCE_IMAGING_RAW":
                isi_raw = filename

        file_lists = []
        if isi_product is not None and isi_raw is not None:
            file_lists.append(
                {
                    "calib_std": isi_product,
                    "raw_im": isi_raw,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3
        ext = "IMAGE"
        raw_ext = "PRIMARY"

        new_panels = super().generate_panels(
            im_ext=ext,
            raw_ext=raw_ext,
            hist_red=False,
            hist_n_clipping={"nsigma": 1},
        )

        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            calib_std = self.hdus[0]["calib_std"]
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = SphereSetupInfo.ird_science_imaging(calib_std)
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

        panels = {**panels, **new_panels}

        return panels


rep = SphereStdStarReport()
