import os
from adari_core.data_libs.master_dark_bias import MasterRawCutsReport
from adari_core.plots.text import TextPlot
from .sphere_utils import SphereSetupInfo, SphereReportMixin

class SphereWaveCalReport(SphereReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("sphere_wavelength")

    def parse_sof(self):

        wave_cal = []

        for filename, catg in self.inputs:
            if catg == "IFS_WAVECALIB":
                wave_cal.append(filename)

        if len(wave_cal) == 0:
            for filename, catg in self.inputs:
                if catg == "IFS_SPECPOS":
                    wave_cal.append(filename)

        # Build and return the file name list
        file_lists = []
        for item in wave_cal:
            file_lists.append(
                {
                    "master_im": item,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}

        ext = "PRIMARY"
        vspace = 0.3

        setup = self.hdus[0]["master_im"][ext].header.get(
            "HIERARCH ESO INS2 OPTI2 NAME"
        )
        if setup == "PRI_YJ":
            val = (0.8, 1.4)
        else:  # PRI_YJH
            val = (0.8, 1.7)

        new_panels = super().generate_panels(
            master_im_ext=ext,
            master_im_clipping="val",
            master_im_n_clipping=val,
            interpolation="nearest",
        )

        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            panel_descr["report_description"] = (
                f"SPHERE ifu wavelength calibration panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = self.hdus[i]["master_im"]

            # Text Plot
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)

            col1 = (
                str(master_im["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + ext,
                "PRO CATG: "
                + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            self.metadata = SphereSetupInfo.ifs_wave_cal(master_im)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

        panels = {**panels, **new_panels}

        return panels


rep = SphereWaveCalReport()
