/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ifs_instrument_flat.h"
#include "sph_common_keywords.h"
#include "sph_ifs_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IFS_INSTRUMENT_FLAT_GENERAL              = SPH_IFS_INSTRUMENT_FLAT_ERR_START + 0;
sph_error_code SPH_IFS_INSTRUMENT_FLAT_NO_VALID_DIT_LIST    = SPH_IFS_INSTRUMENT_FLAT_ERR_START + 1;

sph_error_code SPH_IFS_INSTRUMENT_FLAT_PARAMETER_MISSING    = SPH_IFS_INSTRUMENT_FLAT_ERR_START + 3;
sph_error_code SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING       = SPH_IFS_INSTRUMENT_FLAT_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ifs_instrument_flat_create_plugin ( cpl_plugin * );
static int sph_ifs_instrument_flat_exec_plugin ( cpl_plugin * );
static int sph_ifs_instrument_flat_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ifs_instrument_flat_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IFS_FLAT_FIELD_RAW              1, -1   The input raw instrument flat frames. These should be flat frames\n"
    "                                        obtained with the lenslet array in place, and in zero (reference) position.\n"
    "IFS_WAVECALIB                   0,  1   The wavelength calibration frame.\n"
    "IFS_SPECPOS                     0,  1   The spectra positions calibration frame, only used/needed if no wave calibration frame\n"
    "                                        provided. \n"
    "IFS_CAL_BACKGROUND              0,  1   An optional master background frame for dark subtraction.\n"
    "IFS_MASTER_DARK                 0,  1   An optional master dark frame for dark subtraction.\n"
    "IFS_MASTER_DFF_LONG1            1,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "                                        A required input for IFU flat mode.\n"
    "IFS_MASTER_DFF_LONG2            1,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "                                        A required input for IFU flat mode.\n"
    "IFS_MASTER_DFF_LONG3            1,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "                                        A required input for IFU flat mode.\n"
    "IFS_MASTER_DFF_LONG4            0,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "IFS_MASTER_DFF_LONGBB           0,  1   A long exposure master flat frame taken with broad band light.\n"
    "                                        A required input for IFU flat mode. NOT CURRENTLY USED IN PROCESSING!\n"
    "IFS_PREAMP_FLAT                 0,  1   A preamp correction flat. If provided the instrument flat is divided by\n"
    "                                        this.     \n"
    "IFS_MASTER_DFF_SHORT            0,  1   A short exposure detector master flat frame taken with broad band light. This flat\n"
    "                                        should under normal circumstances be corrected already by a large scale flat.\n"
    "                                        See the description of the master detector flat recipe for details.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates the instrument flat for IFS.\n"
    "The recipe works in two modes: in the first mode,\n"
    "the raw frames from the calibration procedure are\n"
    "used to create a flat field on the detector which\n"
    "includes the effect of the detector response (the detector flat field is NOT\n"
    "divided out). The product created in this mode may be used as a flat field\n"
    "in the spectra_positions or wave_calib recipe.\n"
    "In the second mode, the pixel description table produced by the\n"
    "spectra_positions recipe and updated by wavelength calibration recipe is used\n"
    "as input together with the\n"
    "calibration raw frames to create a flat field of the IFU which has the\n"
    "effect of the detector response removed (i.e. it is divided by the detector flat).\n"
    "The mode to use is decided depending on the parameters set for this recipe and\n"
    "the input files available.\n"
    "In the total flat field mode the recipe reads\n"
    "in the spectra positions file to set the illuminated regions. The recipe then constructs a flat\n"
    "field in the same way as done for sph_ifs_master_detector_flat (optionally first\n"
    "subtracting either a master background or a master dark).\n"
    "The resulting frames is then saved as the total instrument flat. Note that this frame\n"
    "has the same dimensions as the detector and is always dithering dependent.\n"
    "In the IFU flat field mode, the wavelength calibration file is used instead of the spectra positions\n"
    "table. First the same steps are carried out as for the total flat mode. However, the wavlength\n"
    "calibration file is then used to first construct a wavelength dependent flat field (also sometimes\n"
    "called a super flat field), making use\n"
    "of the series of master detector flats provided. This frame is then used to flat\n"
    "field the combined raw frames by dividing it out, to give a flat field containing only the\n"
    "IFU (lenslet) contribution. At this stage the frame is still for the detector itself.\n"
    "A lenslet description table is then constructed using the lenslet model as obtained from the\n"
    "header of the input wavelength calibration frame. This lenslet description table now\n"
    "contains the extracted spectra data for all lenslets. These are then collapsed along the\n"
    "wavelength direction (taking the median values) to obtain a flat field value for all\n"
    "lenslets. The primary data product is written out as a viewable interpolated image\n"
    "(which is not generally used further in the cascade) and a table containing the flat\n"
    "field values for all lenslets. This table is used in other recipes when the IFU flat field\n"
    "is to be applied.\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IFS_INSTRUMENT_FLAT_FIELD          FITS[Im(4)]    The total instrument flat field. This is saved as a FITS file with 4 extensions,\n"
    "                                        the flat values, the badpixels (hotpixels and non-linear pixels), the rms error\n"
    "                                        on the flat and a weightmap.\n"
    "IFS_IFU_FLAT_FIELD                 FITS[Im(4),Tab]The IFU flat field. This is saved as a FITS file with 4 image extensions, the flat values,\n"
    "                                        the badpixels (hotpixels and non-linear pixels), the rms error on the flat, a weightmap\n"
    "                                        and 1 table extension\n"
    "                                        containing the lenslet flat values.\n"
    "IFS_STATIC_BADPIXELMAP             FITS[Im(1)]    Optional output of all the non-linear pixels determined. All pixels as determined\n"
    "                                        in this recipe using the ird.instrument_flat.badpix_*tolerance parameters.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ifs_instrument_flat Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ifs_instrument_flat.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IFS_INSTRUMENT_FLAT_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ifs_instrument_flat",
                        "Determine the full instrument flat field OR the IFU flat",
                        sph_ifs_instrument_flat_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ifs_instrument_flat_create_plugin,
                        sph_ifs_instrument_flat_exec_plugin,
                        sph_ifs_instrument_flat_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_instrument_flat_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ifs_instrument_flat_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IFS_INSTRUMENT_FLAT_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ifs_instrument_flat_create_test(cpl_plugin * plugin)
{
    return (int)sph_ifs_instrument_flat_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_instrument_flat_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ifs_instrument_flat*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ifs_instrument_flat_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ifs_instrument_flat_run( sph_recipe );

        sph_ifs_instrument_flat_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_instrument_flat_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ifs_instrument_flat struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ifs_instrument_flat_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ifs.instrument_flat.iff_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the instrument flat product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ifs.instrument_flat",
                                   "ifs_instrument_flat.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.ifu_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the IFU flat product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ifs.instrument_flat",
                                   "ifs_ifu_flat.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.make_badpix",
                                   CPL_TYPE_BOOL,
                                   "Controls if a seperate static badpixel map is requested for output. "
                                   ,"ifs.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.nofit",
                                   CPL_TYPE_BOOL,
                                   "Allows polynomial fitting for flat field determination to be turned off. "
                                   "Instead the input raw frames will simply be collapsed with a median. "
                                   ,"ifs.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.robust_fit",
                                   CPL_TYPE_BOOL,
                                   "Controls if fitting method is to be a robust linear fit. This will reduce the effect of cosmic "
                                   "rays and other temporary bad pixels. See e.g. Numerical Recipes for a description of the algorithm "
                                   ,"ifs.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.badpixfilename",
                                   CPL_TYPE_STRING,
                                   "Controls the filename of the badpixel map, if requested for output. "
                                   "Ignored if no make_badpix is FALSE. "
                                   ,"ifs.instrument_flat",
                                   "iff_badpixels.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ifs.instrument_flat.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = clean mean, 3 = Weighted mean. "
                                   ,"ifs.instrument_flat",
                                   1 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.instrument_flat.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   ,"ifs.instrument_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.instrument_flat.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ifs.instrument_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.badpix_lowtolerance",
                                   CPL_TYPE_DOUBLE,
                                   "Threshold value for linearity badpixels. All pixels that have a flat field (slope) "
                                   "below this value will be flagged as bad "
                                   ,"ifs.instrument_flat",
                                   0.1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.badpix_uptolerance",
                                   CPL_TYPE_DOUBLE,
                                   "Threshold value for linearity badpixels. All pixels that have a flat field (slope) "
                                   "above this value will be flagged as bad "
                                   ,"ifs.instrument_flat",
                                   10.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.badpix_chisqtolerance",
                                   CPL_TYPE_DOUBLE,
                                   "Threshold value for linearity badpixels. All pixels that have chi-squared value for "
                                   "the linear fit that is above this value will be flagged as bad "
                                   ,"ifs.instrument_flat",
                                   50.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.instrument_flat.use_illumination",
                                   CPL_TYPE_BOOL,
                                   "Controls if the illumination pattern of lenslets is to be taken into "
                                   "account in the cube creation or not. A low level wave-like structure "
                                   "can appear in the result if it is not applied. However, calculation of "
                                   "of the illumination fraction affects the performance of the recipe and "
                                   "so this option should only be enabled if the artefacts adversely affect "
                                   "the results. Note that there is a corresponding option on the ifs_science_dr "
                                   "recipe which should match the chosen option here. "
                                   ,"ifs.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ifs_instrument_flat_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ifs_instrument_flat_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ifs_instrument_flat
           structure.
 @param    self     the sph_ifs_instrument_flat recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ifs_instrument_flat_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ifs_instrument_flat_check_frames( sph_ifs_instrument_flat* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_FLAT_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_FLAT_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_FLAT_RAW);
        rerr = SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->wave_calib_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
    if ( ! self->wave_calib_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract wave_calib_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_WAVE_CALIB_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->wave_calib_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_SPEC_POS_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->specpos_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_SPEC_POS_CALIB );
    if ( ! self->specpos_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract specpos_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_SPEC_POS_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->specpos_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_background_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    if ( ! self->master_background_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_background_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_CAL_BACKGROUND_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_background_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long1_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG_CALIB );
    if ( ! self->master_dff_long1_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract master_dff_long1_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG_CALIB);
        rerr = SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long1_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long2_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
    if ( ! self->master_dff_long2_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract master_dff_long2_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG2_CALIB);
        rerr = SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long2_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long3_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
    if ( ! self->master_dff_long3_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract master_dff_long3_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG3_CALIB);
        rerr = SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long3_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long4_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
    if ( ! self->master_dff_long4_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_long4_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG4_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long4_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_longbb_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
    if ( ! self->master_dff_longbb_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_longbb_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONGBB_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_longbb_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preamp_flat = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
    if ( ! self->preamp_flat )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preamp_flat frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_PREAMP_FLAT);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->preamp_flat, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_short_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
    if ( ! self->master_dff_short_frame )
    {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_short_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_SHORT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_short_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ifs_instrument_flat
           structure.
 @param    self     the sph_ifs_instrument_flat recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ifs_instrument_flat_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_instrument_flat_check_params( sph_ifs_instrument_flat* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.iff_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.iff_filename");
    }

    self->instrument_flat_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.ifu_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.ifu_filename");
    }

    self->ifu_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.make_badpix");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.make_badpix");
    }

    self->make_badpix = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.nofit");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.nofit");
    }

    self->nofit = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.robust_fit");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.robust_fit");
    }

    self->robust_fit = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.badpixfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.badpixfilename");
    }

    self->badpix_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.badpix_lowtolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.badpix_lowtolerance");
    }

    self->badpix_lowtolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.badpix_uptolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.badpix_uptolerance");
    }

    self->badpix_uptolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.badpix_chisqtolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.badpix_chisqtolerance");
    }

    self->badpix_chisqtolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.instrument_flat.use_illumination");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.instrument_flat.use_illumination");
    }

    self->use_illum = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ifs_instrument_flat structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ifs_instrument_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ifs_instrument_flat* sph_ifs_instrument_flat_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ifs_instrument_flat*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ifs_instrument_flat) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IFS_INSTRUMENT_FLAT_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ifs_instrument_flat_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_instrument_flat_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ifs_instrument_flat_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ifs_instrument_flat structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ifs_instrument_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_instrument_flat_delete( sph_ifs_instrument_flat* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->wave_calib_frame != NULL ) {
        cpl_frame_delete( self->wave_calib_frame );
        self->wave_calib_frame = NULL;
    }
    if ( self->specpos_frame != NULL ) {
        cpl_frame_delete( self->specpos_frame );
        self->specpos_frame = NULL;
    }
    if ( self->master_background_frame != NULL ) {
        cpl_frame_delete( self->master_background_frame );
        self->master_background_frame = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->master_dff_long1_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long1_frame );
        self->master_dff_long1_frame = NULL;
    }
    if ( self->master_dff_long2_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long2_frame );
        self->master_dff_long2_frame = NULL;
    }
    if ( self->master_dff_long3_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long3_frame );
        self->master_dff_long3_frame = NULL;
    }
    if ( self->master_dff_long4_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long4_frame );
        self->master_dff_long4_frame = NULL;
    }
    if ( self->master_dff_longbb_frame != NULL ) {
        cpl_frame_delete( self->master_dff_longbb_frame );
        self->master_dff_longbb_frame = NULL;
    }
    if ( self->preamp_flat != NULL ) {
        cpl_frame_delete( self->preamp_flat );
        self->preamp_flat = NULL;
    }
    if ( self->master_dff_short_frame != NULL ) {
        cpl_frame_delete( self->master_dff_short_frame );
        self->master_dff_short_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
