/***********************************************************************************************/
 /******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
 /***********************************************************************************************/

 /* $Id: $
  * This file is part of the SPHERE Pipeline
  * Copyright (C) 2007-2010 European Southern Observatory
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
 
 /*
  * $Author: $
  * $Date: $
  * $Revision: $
  * $Name: $
  */
 
 /*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/
 
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
 
 #include "sph_ifs_wave_calib.h"
 #include "sph_common_keywords.h"
 #include "sph_ifs_keywords.h"
 #include "sph_ifs_tags.h"
 #include "sph_master_frame.h"
 #include "sph_error.h"
 #include "sph_cube.h"
 #include "sph_utils.h"
 
 #include <math.h>
 #include <assert.h>
 #include <cpl.h>
 
 /*-----------------------------------------------------------------------------
   Error Codes
  -----------------------------------------------------------------------------*/
 
 sph_error_code SPH_IFS_WAVE_CALIB_GENERAL              = SPH_IFS_WAVE_CALIB_ERR_START + 0;
 sph_error_code SPH_IFS_WAVE_CALIB_NO_VALID_DIT_LIST    = SPH_IFS_WAVE_CALIB_ERR_START + 1;
 
 sph_error_code SPH_IFS_WAVE_CALIB_PARAMETER_MISSING    = SPH_IFS_WAVE_CALIB_ERR_START + 3;
 sph_error_code SPH_IFS_WAVE_CALIB_FRAMES_MISSING       = SPH_IFS_WAVE_CALIB_ERR_START + 4;
 
 /*-----------------------------------------------------------------------------
  Private function prototypes
  -----------------------------------------------------------------------------*/
 
 static int sph_ifs_wave_calib_create_plugin ( cpl_plugin * );
 static int sph_ifs_wave_calib_exec_plugin ( cpl_plugin * );
 static int sph_ifs_wave_calib_destroy_plugin ( cpl_plugin * );
 
 /*-----------------------------------------------------------------------------
  Static variables
  -----------------------------------------------------------------------------*/
 
 static const char* sph_ifs_wave_calib_help = 
     "RECIPE INPUT FRAMES: \n"
     "-------------------- \n"
     "Tag                           Min,Max   Description\n"
     "IFS_WAVECALIB_RAW               1, -1   The raw input frames with clearly identifyable spectra lines.\n"
     "IFS_SPECPOS                     1,  1   The spectra positions calibration.\n"
     "IFS_INSTRUMENT_FLAT_FIELD       0,  1   An optional flat frame to apply before spectra lines are found and wavelengths are calibrated.\n"
     "IFS_CAL_BACKGROUND              0,  1   An optional master background frame for dark subtraction.\n"
     "IFS_MASTER_DARK                 0,  1   An optional master dark frame for dark subtraction.\n"
     "\n"
     "RAW FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Type   Optional  Description\n"
     "\n"
     "DESCRIPTION:\n"
     "------------\n"
     "This is the recipe responsible for calibrating the pixel to wavelength associations for the IFS. The approach taken for the IFS in SPHERE is model based: the initial model as created by the spectra positions calibration recipe is used as input and the observed wavelength calibration frames are used to modify this model, adjusting the pixel to wavelength associations. This approach assumes implicitly that there are no large discrepancies between the model and the actual wavelength associations.\n"
     "Before the wavelength associations are determined, the raw input frames are combined using the specified combination method (mean, clean mean or median). Optionally either a master background or a master dark dark is subtracted and the result is divided by an optional flat field.\n"
     "RECIPE PRODUCTS: \n"
     "-------------------- \n"
     "Tag                      Format         Description\n"
     "IFS_WAVECALIB                      FITS[Im(7)]    The calibrated pixel description table (PDT) written out as images. The PDT is written as a\n"
     "                                        FITS file with 6 extensions, corresponding to: wavelength, spectra region id, lenslet id, wavelength width,\n"
     "                                        second derivate of wavelength and illumination fraction.  The last extension flags bad spectra for which\n"
     "                                        no good fit was found.\n"
     "                                        Currently the last three extensions are not used in any recipe.\n"
     "IFS_WAVECALIB_CUBE                 FITS[Imcube(4)]The wavelength calibrated cube.\n"
     "\n"
     "PRODUCT FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Frame          Type    Description\n"
     "\n"
 ;
 
 /*-----------------------------------------------------------------------------
  Function code
  -----------------------------------------------------------------------------*/
 /*----------------------------------------------------------------------------*/
 /**
  * @defgroup sph_ifs_wave_calib Create Master Dark Recipe
  *
  * This module provides the recipe plugin and relating functions for the
  * creation of the master dark .
  *
  * @par Synopsis:
  * @code
  *   #include "sph_ifs_wave_calib.h"
  * @endcode
  */
 /*----------------------------------------------------------------------------*/
 /**@{*/
 
 /*****************************************************************************
  *
  *
  *      First come the static and global functions necessary for the
  *      normal working of the recipe as plugin....
  *
  *
  * ***************************************************************************/
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Build the list of available plugins, for this module.
  @param    list    the plugin list
  @return   0 if everything is ok, 1 otherwise
  @note     Only this function is exported
 
  Create the recipe instance and make it available to the application
  using the interface.
  */
 /*----------------------------------------------------------------------------*/
 int cpl_plugin_get_info(cpl_pluginlist * list)
 {
     cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
     cpl_plugin * plugin = &recipe->interface;
 
     if (cpl_plugin_init(plugin,
                         CPL_PLUGIN_API,
                         SPH_IFS_WAVE_CALIB_VERSION,
                         CPL_PLUGIN_TYPE_RECIPE,
                         "sph_ifs_wave_calib",
                         "Create the wavelength calibration data",
                         sph_ifs_wave_calib_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                         "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                         sph_ifs_wave_calib_create_plugin,
                         sph_ifs_wave_calib_exec_plugin,
                         sph_ifs_wave_calib_destroy_plugin) )
     {
         cpl_msg_error( cpl_func, "Plugin initialization failed");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
 
     if (cpl_pluginlist_append(list, plugin) )
     {
         cpl_msg_error( cpl_func, "Error adding plugin to list");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Setup the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Defining the command-line/configuration parameters for the recipe.
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_wave_calib_create_plugin(cpl_plugin * plugin)
 {
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                        cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error(cpl_func, "Null plugin");
         cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     if ( plugin != NULL ) {
         cpl_recipe * recipe = (cpl_recipe *)plugin;
         recipe->parameters = sph_ifs_wave_calib_create_paramlist();
         if ( recipe->parameters == NULL ) {
             return SPH_IFS_WAVE_CALIB_GENERAL;
         }
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Testing for setup of the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Wrapper to make the static plugin creation function accessible from outside
  for testing purposes.
  */
 /*----------------------------------------------------------------------------*/
 int sph_ifs_wave_calib_create_test(cpl_plugin * plugin)
 {
     return (int)sph_ifs_wave_calib_create_plugin(plugin);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Execute the plugin instance given by the interface
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_wave_calib_exec_plugin(cpl_plugin * plugin)
 {
 
     cpl_recipe*             recipe                  = NULL;
     cpl_error_code          recipe_code;
     sph_ifs_wave_calib*    sph_recipe      = NULL;
     cpl_errorstate          initial_errorstate      = cpl_errorstate_get();
 
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
         cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
         return (int)cpl_error_get_code();
     }
 
     recipe = (cpl_recipe *)plugin;
 
     if (recipe->parameters == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (recipe->frames == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     sph_recipe = sph_ifs_wave_calib_new( recipe->frames, recipe->parameters );
     if ( sph_recipe == NULL ) {
         recipe_code = cpl_error_set_where(cpl_func);
     } else {
 
         recipe_code = sph_ifs_wave_calib_run( sph_recipe );
 
         sph_ifs_wave_calib_delete( sph_recipe );
     }
 
     if ( !cpl_errorstate_is_equal(initial_errorstate) )
     {
         cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
     }
     sph_end_erex(); //close the sphere system
     return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                  ? CPL_ERROR_EOL : recipe_code);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Destroy what has been created by the 'create' function
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_wave_calib_destroy_plugin(cpl_plugin * plugin)
 {
     cpl_recipe * recipe;
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     recipe = (cpl_recipe *)plugin;
 
     cpl_parameterlist_delete(recipe->parameters);
 
     return 0;
 }
 
 /*****************************************************************************
  *
  *
  *      Here come the "Member" functions of the sph_ifs_wave_calib struct
  *
  *
  * ***************************************************************************/
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Fill a pre-allocated parameterlist for the recipe
  @param    result A pre-allocated parameterlist
  @return   CPL_ERROR_NONE iff successful
 
  This function fills the standard parameterlist for the recipe
 
  */
 /*----------------------------------------------------------------------------*/
 static cpl_error_code sph_ifs_wave_calib_fill_parameterlist(cpl_parameterlist * result)
 {
     cpl_parameter* p;
 
         /* Code to set up parameters GENERATED DO NOT EDIT */

         p = cpl_parameter_new_value("ifs.wave_calib.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename of the calibrated IFS model. "
                                    ,"ifs.wave_calib",
                                    "pdt_wave_calib.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("ifs.wave_calib.coll_alg",
                                    CPL_TYPE_INT,
                                    "The collapse algorithm to use to combine the input raw frames. "
                                    ,"ifs.wave_calib",
                                    2 ,
                                    3,0,1,2);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.number_lines",
                                    CPL_TYPE_INT,
                                    "The number of wavelength lines to fit. A number of zero (default) means automatic setting. "
                                    "In that case the number of wavelengths and the wavelengths themselves are set automatically "
                                    "from the header of the pixel description table. "
                                    ,"ifs.wave_calib",
                                    0 ,
                                    0,5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.wavelength_line1",
                                    CPL_TYPE_DOUBLE,
                                    "The wavelength of the first line "
                                    ,"ifs.wave_calib",
                                    0.98772 ,
                                    0.9,2.5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.wavelength_line2",
                                    CPL_TYPE_DOUBLE,
                                    "The wavelength of the second line "
                                    ,"ifs.wave_calib",
                                    1.12371 ,
                                    0.9,2.5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.wavelength_line3",
                                    CPL_TYPE_DOUBLE,
                                    "The wavelength of the third line (only used if number_lines > 2) "
                                    ,"ifs.wave_calib",
                                    1.30937 ,
                                    0.9,2.5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.wavelength_line4",
                                    CPL_TYPE_DOUBLE,
                                    "The wavelength of the fourth line (only used if number_lines > 3) "
                                    ,"ifs.wave_calib",
                                    1.5451 ,
                                    0.9,2.5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.wavelength_line5",
                                    CPL_TYPE_DOUBLE,
                                    "The wavelength of the fourth line (only used if number_lines > 4) "
                                    ,"ifs.wave_calib",
                                    1.5451 ,
                                    0.9,2.5);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.line_threshold",
                                    CPL_TYPE_DOUBLE,
                                    "The threshold value to use for identifying spectral lines. "
                                    ,"ifs.wave_calib",
                                    90.0 ,
                                    0.0,40000.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.wave_calib.polyfit_order",
                                    CPL_TYPE_INT,
                                    "The order of the polynomial to use for the wavelength model. For example, "
                                    "if the order is 1, a linear model with constant dispersion is assumed. "
                                    ,"ifs.wave_calib",
                                    2 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.wave_calib.no_spline_interpol",
                                    CPL_TYPE_BOOL,
                                    "Do not use esoteric spline interpolation after wavelength fit. "
                                    "If true, the polynomial fit result will be directly inserted into the spectra without endpoint adaptation. "
                                    ,"ifs.wave_calib",
                                    1 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.fit_window_size",
                                    CPL_TYPE_INT,
                                    "Half the tolerance around the predicted wavelength position to search for the actual maximum. This value "
                                    "should absolutely be smaller than the minimal distance between line wavelengths (in pixels). "
                                    ,"ifs.wave_calib",
                                    4 ,
                                    1,10);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.clean_mean.reject_high",
                                    CPL_TYPE_INT,
                                    "Number of pixels to reject at high end for the clean mean combination method. "
                                    ,"ifs.wave_calib",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.wave_calib.clean_mean.reject_low",
                                    CPL_TYPE_INT,
                                    "Number of pixels to reject at low end for the clean mean combination method. "
                                    ,"ifs.wave_calib",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.wave_calib.save_addprod",
                                    CPL_TYPE_BOOL,
                                    "Flag to signal whether additional products - in this case the wavelength calibrated "
                                    "cube - should be saved. "
                                    ,"ifs.wave_calib",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return cpl_error_set_where(cpl_func);
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief  Create and return the standard parameterlist for the recipe
  @return The standard parameterlist or NULL on error
  @note   The returned object must be deallocated using cpl_parameterlist_delete
 
  */
 /*----------------------------------------------------------------------------*/
 cpl_parameterlist* sph_ifs_wave_calib_create_paramlist(void)
 {
     cpl_parameterlist* self = cpl_parameterlist_new();
 
     if (sph_ifs_wave_calib_fill_parameterlist(self)) {
         cpl_parameterlist_delete(self);
         self = NULL;
         (void)cpl_error_set_where(cpl_func);
     }
 
     return self;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe frames, and assign them to the sph_ifs_wave_calib
            structure.
  @param    self     the sph_ifs_wave_calib recipe structure
  @return   error code of the check.
 
  This checks the frames that were given in the sph_ifs_wave_calib_new function
  as parameters for the correctness and completeness. If the frames needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code  sph_ifs_wave_calib_check_frames( sph_ifs_wave_calib* self )
 {
     sph_error_code           rerr            = CPL_ERROR_NONE;
     /* Code to check frames GENERATED DO NOT EDIT */

     cpl_frame* aframe;
     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_WAVE_CALIB_RAW );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_WAVE_CALIB_RAW );
     if ( ! self->rawframes )
     {
         sph_error_raise( SPH_IFS_WAVE_CALIB_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_ERROR,
                          "Could not extract rawframes frames."
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_WAVE_CALIB_RAW);
         rerr = SPH_IFS_WAVE_CALIB_FRAMES_MISSING;
         return rerr;
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->rawframes );
          for ( int ii = 0; ii < numframes; ++ii ) {
              cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
              const char* ifname = cpl_frame_get_filename(iframe);
              cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
              if (pl == NULL ) {
                  sph_error_raise(cpl_error_get_code(),
                     __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Could not read keywords from file %s. "
                  "Either the file is not readable or corrupted. ",
                   ifname);
              }
              else {
                  rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                  cpl_propertylist_delete(pl); pl=NULL;
              }
          }
          numframes -= (int)cpl_frameset_get_size( self->rawframes );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_SPEC_POS_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->specpos_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_SPEC_POS_CALIB );
     if ( ! self->specpos_frame )
     {
         sph_error_raise( SPH_IFS_WAVE_CALIB_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_ERROR,
                          "Could not extract specpos_frame frames."
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_SPEC_POS_CALIB);
         rerr = SPH_IFS_WAVE_CALIB_FRAMES_MISSING;
         return rerr;
     }

     else {

          rerr = cpl_frame_set_group( self->specpos_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_FLAT_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_iff_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_FLAT_CALIB );
     if ( ! self->master_iff_frame )
     {
         sph_error_raise( SPH_IFS_WAVE_CALIB_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_iff_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_FLAT_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_iff_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_background_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
     if ( ! self->master_background_frame )
     {
         sph_error_raise( SPH_IFS_WAVE_CALIB_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_background_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_CAL_BACKGROUND_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_background_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     if ( ! self->master_dark_frame )
     {
         sph_error_raise( SPH_IFS_WAVE_CALIB_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DARK_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
     }

     /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );
 
     return rerr;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe parameters, and assign them to the sph_ifs_wave_calib
            structure.
  @param    self     the sph_ifs_wave_calib recipe structure
  @return   error code of the check.
 
  This checks the parameters that were given in the sph_ifs_wave_calib_new function
  as parameters for the correctness and completeness. If the parameters needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_wave_calib_check_params( sph_ifs_wave_calib* self ) {
     sph_error_code                 rerr               = CPL_ERROR_NONE;
     const cpl_parameter*           param              = NULL;
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
     self->framecomb_parameterlist = cpl_parameterlist_new();
     /* Code to check parameters GENERATED DO NOT EDIT */

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.outfilename");
     }

     self->wave_calib_filename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.coll_alg");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.coll_alg");
     }

     self->coll_alg = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.number_lines");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.number_lines");
     }

     self->number_lines = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.wavelength_line1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.wavelength_line1");
     }

     self->wavelength_line1 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.wavelength_line2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.wavelength_line2");
     }

     self->wavelength_line2 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.wavelength_line3");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.wavelength_line3");
     }

     self->wavelength_line3 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.wavelength_line4");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.wavelength_line4");
     }

     self->wavelength_line4 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.wavelength_line5");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.wavelength_line5");
     }

     self->wavelength_line5 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.line_threshold");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.line_threshold");
     }

     self->line_threshold = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.polyfit_order");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.polyfit_order");
     }

     self->polyfit_order = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.no_spline_interpol");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.no_spline_interpol");
     }

     self->no_spline_interpol = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.fit_window_size");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.fit_window_size");
     }

     self->fit_window_size = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.clean_mean.reject_high");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.clean_mean.reject_high");
     }

     self->clean_mean_reject_high = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_high",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.clean_mean.reject_low");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.clean_mean.reject_low");
     }

     self->clean_mean_reject_low = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_low",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.wave_calib.save_addprod");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.wave_calib.save_addprod");
     }

     self->save_addprod = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return rerr;
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Create a new sph_ifs_wave_calib structure.
 
  @param    frameset     the input recipe frames
  @param    parlist      the input recipe parameters
 
  @return   pointer to newly created structure or NULL in case of error
 
  This creates a new sph_ifs_wave_calib_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_ifs_wave_calib* sph_ifs_wave_calib_new( cpl_frameset * frameset,
                                               cpl_parameterlist * parlist )
 {
     sph_ifs_wave_calib*    result      = NULL;
     int                     rerr        = CPL_ERROR_NONE;
 
     sph_init_erex();
     if ( frameset == NULL || parlist == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return NULL;
     }
 
     result = cpl_calloc( 1, sizeof(sph_ifs_wave_calib) );
 
     if ( result == NULL ) {
         sph_error_raise( SPH_IFS_WAVE_CALIB_GENERAL, __FILE__, __func__,
                          __LINE__, SPH_ERROR_ERROR,
                          "Could not allocate the structure.");
         return result;
     }
 
     result->inframes = frameset;
     result->inparams = parlist;
 
     rerr = sph_ifs_wave_calib_check_frames( result );
     if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_wave_calib_check_params( result );
 
     if ( rerr != CPL_ERROR_NONE ) {
         if ( result ) {
             sph_ifs_wave_calib_delete( result );
         }
         result = NULL;
     }
 
     return result;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Delete the sph_ifs_wave_calib structure.
 
  @param    self         the structure tp delete
 
  @return   error code of the operation
 
  This creates a new sph_ifs_wave_calib_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_wave_calib_delete( sph_ifs_wave_calib* self )
 {
     sph_error_code          rerr            = CPL_ERROR_NONE;
 
     if ( self == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return rerr;
     }
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
 
     /* Code to delete recipe pointers GENERATED DO NOT EDIT */

     if ( self->rawframes != NULL ) {
         cpl_frameset_delete( self->rawframes );
         self->rawframes = NULL;
     }
     if ( self->specpos_frame != NULL ) {
         cpl_frame_delete( self->specpos_frame );
         self->specpos_frame = NULL;
     }
     if ( self->master_iff_frame != NULL ) {
         cpl_frame_delete( self->master_iff_frame );
         self->master_iff_frame = NULL;
     }
     if ( self->master_background_frame != NULL ) {
         cpl_frame_delete( self->master_background_frame );
         self->master_background_frame = NULL;
     }
     if ( self->master_dark_frame != NULL ) {
         cpl_frame_delete( self->master_dark_frame );
         self->master_dark_frame = NULL;
     }
  
     /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     if ( self->current_raw_frameset ) {
         cpl_frameset_delete(self->current_raw_frameset);
         self->current_raw_frameset = NULL;
     }
     sph_polygon_free_all();
     cpl_free(    self);
     return rerr;
 
 }
 
 
 /**@}*/
 
