/* This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SPH_SPEC_DECONV_
#define SPH_SPEC_DECONV_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>

/*-----------------------------------------------------------------------------
 Function prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code sph_spec_deconv(cpl_frameset* inframes,
                               const cpl_frameset* current_raw_frameset,
                               const cpl_parameterlist* inparams,
                               const cpl_parameterlist* framecomb_parameterlist,
                               const char* tag,
                               const char* recipe,
                               const char* outfilename,
                               int order,
                               short user_cent,
                               double cx,
                               double cy,
                               double reflambda,
                               double smooth_fwhm,
                               const cpl_frameset* science_frameset);

#endif
