/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IRD_COMMON_SCIENCE_H_
#define SPH_IRD_COMMON_SCIENCE_H_

#include <cpl.h>
#include "sph_error.h"
#include "sph_master_frame.h"
#include "sph_cube.h"
#include "sph_fctable.h"
#include "sph_ird_instrument_model.h"
#include "sph_filter_table.h"
#include "sph_transform.h"

extern const char* const SPH_IRD_STAR_CENTER_TIME_UT_NAME;
extern const char* const SPH_IRD_STAR_CENTER_CENTLEFTX_NAME;
extern const char* const SPH_IRD_STAR_CENTER_CENTLEFTY_NAME;
extern const char* const SPH_IRD_STAR_CENTER_CENTRIGHTX_NAME;
extern const char* const SPH_IRD_STAR_CENTER_CENTRIGHTY_NAME;
extern const char* const SPH_IRD_STAR_CENTER_DMS_POS_X_NAME;
extern const char* const SPH_IRD_STAR_CENTER_DMS_POS_Y_NAME;

typedef struct sph_ird_common_science____ {
    cpl_frameset* inframes;
    cpl_frameset* scframes;
    sph_master_frame* dark;
    sph_master_frame* flat;
    sph_master_frame* tff;
    cpl_image* bpix;
    sph_filter_table* filter_table;
    sph_distortion_model* distort_left;
    sph_distortion_model* distort_right;
    cpl_parameterlist* inparams;
    double minr;
    double maxr;
    int rotate_flag;
    int flag_sdi;
    int least_square;
    const char* tag;
    const char* recipe;
    sph_ird_instrument_model* irdmodel;
    sph_transform* transform;
} sph_ird_common_science;

sph_error_code
sph_ird_common_science_set_transform(sph_ird_common_science* self,
        sph_transform* transform);

sph_ird_common_science*
sph_ird_common_science_new(cpl_frameset* inframes, cpl_parameterlist* inparams,
        cpl_frame* dark, cpl_frame* flat, cpl_frame* bpix,
        cpl_frame* distortion, cpl_frame* filter, cpl_frame* irdmodel,
        const cpl_frameset*,
        const char* recipe, const char* tag);

void
sph_ird_common_science_delete(sph_ird_common_science* self);

sph_error_code
sph_ird_common_science_set_tff(sph_ird_common_science* self, cpl_frame* tff);

cpl_frameset*
sph_ird_common_science_create_fctables(cpl_frameset* rawframes,
        cpl_frame* fcframe, int keep_fctable, int verbose);

sph_error_code
sph_ird_common_science_process_cubes(sph_ird_common_science* sci,
                                     const cpl_frameset* rawframes,
                                     cpl_frameset* scframes,
                                     cpl_frameset** left_out,
                                     cpl_frameset** right_out,
                                     cpl_frameset** total_out,
                                     const char* left_procatg,
                                     const char* right_procatg,
                                     const char* total_procatg);

cpl_error_code sph_ird_common_science_put_wcs(cpl_propertylist* self,
                                              double x, double y);

#endif
