/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IRD_GAIN_H_

#define SPH_IRD_GAIN_H_
#define SPH_IRD_GAIN_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ird_gain that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ird_gain_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     gain_outfilename                      ; /* The parameter of ird.gain.outfilename */

    short                           save_addprod                          ; /* The parameter of ird.gain.save_addprod */

    const char*                     nonlin_outfilename                    ; /* The parameter of ird.gain.nonlin_filename */

    const char*                     nonlin_bpixfilename                   ; /* The parameter of ird.gain.nonlin_bpixname */

    int                             coll_alg                              ; /* The parameter of ird.gain.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ird.gain.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ird.gain.clean_mean.reject_low */

    int                             order                                 ; /* The parameter of ird.gain.order */

    double                          lintolerance                          ; /* The parameter of ird.gain.lin_tolerance */

    short                           preproc                               ; /* The parameter of ird.gain.preproc */

    short                           vacca                                 ; /* The parameter of ird.gain.vacca */

    cpl_frameset*                   rawframes                             ; /* The IRD_GAIN_RAW frames */

    cpl_frame*                      static_badpixel_frame                 ; /* The IRD_STATIC_BADPIXELMAP frames */

    sph_framelist*                  gain_framelist                        ; /* The GAIN_FRAMELIST data field */

    sph_cube*                       gain_cube                             ; /* The GAIN_CUBE data field */

} sph_ird_gain;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ird_gain_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ird_gain.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ird_gain* sph_ird_gain_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ird_gain_check_frames( sph_ird_gain* self );

sph_error_code sph_ird_gain_check_params( sph_ird_gain* parlist );

cpl_error_code sph_ird_gain_run( sph_ird_gain* self );

sph_error_code sph_ird_gain_delete( sph_ird_gain* self );
cpl_parameterlist*  sph_ird_gain_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ird_gain.c */


/* End of extra function declarations that are defined in sph_ird_gain_run.c */



#endif /*SPH_IRD_GAIN_H_*/
