/***********************************************************************************************/
 /******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
 /***********************************************************************************************/

 /* $Id: $
  * This file is part of the SPHERE Pipeline
  * Copyright (C) 2007-2010 European Southern Observatory
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
 
 /*
  * $Author: $
  * $Date: $
  * $Revision: $
  * $Name: $
  */
 
 /*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/
 
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
 
 #include "sph_zpl_science_p1.h"
 #include "sph_common_keywords.h"
 #include "sph_zpl_keywords.h"
 #include "sph_zpl_tags.h"
 #include "sph_master_frame.h"
 #include "sph_error.h"
 #include "sph_cube.h"
 #include "sph_utils.h"
 
 #include <math.h>
 #include <assert.h>
 #include <cpl.h>
 
 /*-----------------------------------------------------------------------------
   Error Codes
  -----------------------------------------------------------------------------*/
 
 sph_error_code SPH_ZPL_SCIENCE_P1_GENERAL              = SPH_ZPL_SCIENCE_P1_ERR_START + 0;
 sph_error_code SPH_ZPL_SCIENCE_P1_NO_VALID_DIT_LIST    = SPH_ZPL_SCIENCE_P1_ERR_START + 1;
 
 sph_error_code SPH_ZPL_SCIENCE_P1_PARAMETER_MISSING    = SPH_ZPL_SCIENCE_P1_ERR_START + 3;
 sph_error_code SPH_ZPL_SCIENCE_P1_FRAMES_MISSING       = SPH_ZPL_SCIENCE_P1_ERR_START + 4;
 
 /*-----------------------------------------------------------------------------
  Private function prototypes
  -----------------------------------------------------------------------------*/
 
 static int sph_zpl_science_p1_create_plugin ( cpl_plugin * );
 static int sph_zpl_science_p1_exec_plugin ( cpl_plugin * );
 static int sph_zpl_science_p1_destroy_plugin ( cpl_plugin * );
 
 /*-----------------------------------------------------------------------------
  Static variables
  -----------------------------------------------------------------------------*/
 
 static const char* sph_zpl_science_p1_help = 
     "RECIPE INPUT FRAMES: \n"
     "-------------------- \n"
     "Tag                           Min,Max   Description\n"
     "ZPL_SCIENCE_P1_RAW              0, -1   The raw  frames in the polarimetric modes with the two extensions  fits file format:\n"
     "                                        - first extension represents data cube of NDITS frames from camera-1 for a given DIT, including prescan/overscan area of 2 ADUs;\n"
     "                                        - second extension represents data cube of NDITS zimpol frames from camera-2 for a given DIT, including prescan/overscan area of 2 ADUs\n"
     "ZPL_SCIENCE_P1_PREPROC          0, -1   The pre-processed raw science polarimetry frames, polarimetric mode P1\n"
     "                                        Format: ZPL EXP\n"
     "ZPL_SCIENCE_P1_PREPROC_CAM1     0, -1   The pre-processed raw science polarimetry frames, polarimetric mode P1\n"
     "                                        Format: ZPL EXP\n"
     "ZPL_SCIENCE_P1_PREPROC_CAM2     0, -1   The pre-processed raw science polarimetry frames, polarimetric mode P1\n"
     "                                        Format: ZPL EXP\n"
     "ZPL_MASTER_BIAS                 0,  1   The master bias frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_MASTER_BIAS_CAM1            0,  1   The master bias frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_MASTER_BIAS_CAM2            0,  1   The master bias frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_MASTER_DARK                 0,  1   The master dark frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_MASTER_DARK_CAM1            0,  1   The master dark frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_MASTER_DARK_CAM2            0,  1   The master dark frame. Should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_INT_FLAT_FIELD              0,  1   The intensity flat field calibration frame. It should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_INT_FLAT_FIELD_CAM1         0,  1   The intensity flat field calibration frame. It should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_INT_FLAT_FIELD_CAM2         0,  1   The intensity flat field calibration frame. It should have readout mode as the science frames.\n"
     "                                        Format: QUAD IMAGE = [Im(16)]\n"
     "ZPL_INT_FLAT_FIELD_MASTER       0,  1   The master intensity flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_INT_FLAT_FIELD_MASTER_CAM1  0,  1   The master intensity flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_INT_FLAT_FIELD_MASTER_CAM2  0,  1   The master intensity flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_POL_FLAT_FIELD              0,  1   The double image polarization flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: DOUBLE IMAGE = [Im(8)]\n"
     "ZPL_POL_FLAT_FIELD_CAM1         0,  1   The double image polarization flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: DOUBLE IMAGE = [Im(8)]\n"
     "ZPL_POL_FLAT_FIELD_CAM2         0,  1   The double image  polarization flat field frame. Should have readout mode as the science frames.\n"
     "                                        Format: DOUBLE IMAGE = [Im(8)]\n"
     "ZPL_MODEM_EFF                   0,  1   The master modem (modulation/de-modulation) efficiency frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_MODEM_EFF_CAM1              0,  1   The master modem (modulation/de-modulation) efficiency frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_MODEM_EFF_CAM2              0,  1   The master modem (modulation/de-modulation) efficiency frame. Should have readout mode as the science frames.\n"
     "                                        Format: MASTER FRAME = [Im(4)]\n"
     "ZPL_STAR_CENTER_POL_CAM1        0,  1   The star center calibrated frame, that provides the coordinates of the\n"
     "                                        field center in order to perform a correct image de-rotation.\n"
     "                                        Format: DOUBLE IMAGE\n"
     "ZPL_STAR_CENTER_POL_CAM2        0,  1   The star center calibrated frame, that provides the coordinates of the\n"
     "                                        field center in order to perform a correct image de-rotation.\n"
     "                                        Format: DOUBLE IMAGE\n"
     "ZPL_STAR_CENTER_POL             0,  1   The star center calibrated frame, that provides the coordinates of the\n"
     "                                        field center in order to perform a correct image de-rotation.\n"
     "                                        Format: DOUBLE IMAGE\n"
     "ZPL_FIELD_CENTER_TABLE          0, -1   The field center table frames (to be used in the case of the off-line pipeline).\n"
     "                                        This frame can either be a FITS file (binary table) or an ASCII table.\n"
     "                                        The table should gave one row for each input science image\n"
     "                                        (so, if e.g. 5 cubes of each 10 planes are this\n"
     "                                        table should have 50 rows) with the columns center-x(I) and center-y(I),\n"
     "                                        center-x(P) and center-y(P), angle,  where centers are given in pixel coordinates.\n"
     "                                        The ascii file should have a postfix <originalname>_preproc_cam1(2).fits_fctable.txt\n"
     "                                        Note: if this file is presented the star center calibration should be omitted\n"
     "                                        Format: ASCII/Binary table\n"
     "ZPL_POLHIGH_STAR_TABLE          0,  1   The catalog for the calculation of the offset QC parameters in case of high polarization\n"
     "                                        Format: cpl_table\n"
     "ZPL_FILTER_TABLE                0,  1   A filter table, when present used to determine the wavelength for the Strehl estimation.\n"
     "                                        This is a static calibration frame describing the ZIMPOL filters.\n"
     "                                        The format of the FITS table is\n"
     "                                                  \n"
     "                                        10A        10A       D           D            D          D\n"
     "                                        filter_key filter_id lambda_cam1 lambda_cam2  width_cam1 width_cam2\n"
     "                                                  \n"
     "ZPL_POL_CORRECT_TABLE           0,  1   A table containing the shifts associated to the filters. It is used to correct the P and THETA QC\n"
     "                                        parameters when processing a standard polarimetric standard star\n"
     "                                        Format: cpl_table\n"
     "\n"
     "RAW FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Type   Optional  Description\n"
     "ESO DRS PC PROD TYPE          string No        This keyword is mandatory if the pre-processed data are used. \n"
     "                                               As the format of the zimpol pre-processed data is complicated, this keyword was introduced in order \n"
     "                                               to garantee that the pre-processed input frames are polarimetric pre-processed data, \n"
     "                                               produced by the sph_zpl_preproc utility recipe. \n"
     "                                                              \n"
     "                                               Note: if raw data are used (default), then all keywords needed for the pre-processing recipe \n"
     "                                               (see sph_zpl_preproc) must be presented in the raw data. \n"
     "ESO OCS3 ZIMPOL POL STOKES    string No        Stokes parameters (Qplus, Qminus, Uplus, Uminus) \n"
     "                                               SPH_COMMON_KEYWORD_CAM1_DITHERING_X		double	0	0	100.0 \n"
     "                                               X-position of the arm1(camera-1) [pix] \n"
     "                                               SPH_COMMON_KEYWORD_CAM1_DITHERING_Y		double	0	0	100.0 \n"
     "                                               Y-position of the arm1(camera-1) [pix] \n"
     "                                               SPH_COMMON_KEYWORD_CAM2_DITHERING_X		double	0	0	100.0 \n"
     "                                               X-position of the arm2(camera-2) [pix] \n"
     "                                               SPH_COMMON_KEYWORD_CAM2_DITHERING_Y		double	0	0	100.0 \n"
     "                                               Y-position of the arm2(camera-2) [pix] \n"
     "                                               SPH_COMMON_KEYWORD_DROT2_MODE	string	0	0	0 \n"
     "                                               De-rotator mode: ELEV(pupil stabilized), SKY(field stabilized) \n"
     "\n"
     "DESCRIPTION:\n"
     "------------\n"
     "The recipe produces combined science frame [and corresponing Mueller matrix elements (not implemented!)]\n"
     "of the Q and/or U measurements the in the polarization modes.\n"
     "\n"
     "The input frames might be either science polarimetric raw frames with the ZPL_SCIENCE_P1_RAW tag,\n"
     "or pre-processed science raw frames, which should carry the ZPL_SCIENCE_P1_PREPROC_CAM1 and/or\n"
     "ZPL_SCIENCE_P1_PREPROC_CAM2 tags, and calibration frames:\n"
     "- master bias calibration frames (if any) with the ZPL_MASTER_BIAS_CAM1 and/or ZPL_MASTER_BIAS_CAM2 tags, and\n"
     "- master dark calibration frames (if any) with the ZPL_MASTER_DARK_CAM1 and/or ZPL_MASTER_DARK_CAM2 tags, and\n"
     "- master intensity flat field calibration frames with the  ZPL_INT_FLAT_FIELD_MASTER_CAM1 and/or ZPL_INT_FLAT_FIELD_MASTER_CAM2 tags, and\n"
     "- polariztion flat field calibration frames with the ZPL_POL_FLAT_PREPROC_CAM1 and/or  ZPL_POL_FLAT_PREPROC_CAM2 tags, and\n"
     "- modem/de-modulation (modem) efficiency calibration frames with the ZPL_MODEM_EFF_CAM1 and/or ZPL_MODEM_EFF_CAM1 tags.\n"
     "The intensity flat calibration frames can be also used in the format of the QUAD IMAGE (see the description in sph_zpl_intensity_flat recipe) with\n"
     "the corresponding ZPL_INT_FLAT_FIELD_CAM1 and/or ZPL_INT_FLAT_FIELD_CAM2 tags. If both formats of the intensity flat field calibrations are presented\n"
     "in sof-file the MASTER format will be used.\n"
     "\n"
     "If input frames are raw frames then the recipe first performs the pre-processing step for all input frames (raw cubes),\n"
     "creating corresponding pre-processed frames (cubes) for both ZIMPOL cameras (see also sph_zpl_preproc for the detailed description of the\n"
     "pre-processing step).\n"
     "\n"
     "Then, all pre-processed raw science frames are organized in the measurement groups with regards to the Stokes parameters:\n"
     "Q [Qplus, Qminus] and/or or U [Uplus, Uminus].\n"
     "These input frames frames should carry the SPH_ZPL_TAG_SCIENCE_P1_PREPROC_RAW tag.\n"
     "The pre-processed frames of each group for both cameras are then calibrated by subtacting a corresponding master bias frame and a master dark frame,\n"
     "and dividing the results by a corresponding intensity flat field frame.\n"
     "Then the Stokes parameters are calulated for each group creating double image (I,P) frames.\n"
     "The polarization flat and modem efficiency calibrations are applied to the created double image frames of the Stokes parameters.\n"
     "The calibrated frames of each group are then de-dithered, de-rotated and saved as intermediate products (note: if the\n"
     "zpl.science_p1.save_interprod is set to TRUE, the recipe will also save the so called field center table which contains the\n"
     "the calculated center positions and parallactical angles (to be more specific: an angle to be used for the de-rotation)\n"
     "for each plane of the pre-processed fits cube(s)). Note: the calibration frames with\n"
     "SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM1(CAM2) tags provide the center coordinates to rotate around.\n"
     "If these calibrations are not presented the center of the frames will be used (normally, xc=yc=512 pixel).\n"
     "\n"
     "All de-dithered and de-rotated frames are avareged using collapse mean algorithm (for each group Qplus, Qminus, Uplus, Uminus).\n"
     "The combined frames of each groups of the DOUBLE IMAGE (8 extensions) format specified as follows:\n"
     "- combined intensity image (I), its badpixel-map, ncomb-map and rms-map.\n"
     "- combined polarimetric image (P), its badpixel-map, ncomb-map and rms-map.\n"
     "\n"
     "At the final step the double image frames (Qplus and Qminus) as well as (Uplus and Uminus) are combined polarimetrically\n"
     "(Q: I = [I(+Q) + I(-Q)]/2, P = [P(+Q) - P(-Q)]/2; U: I = [I(+U) + I(-U)]/2, P = [P(+U) - P(-U)]/2 )\n"
     "\n"
     "The output Q and/or U double images for both cameras are reduced pipeline data products.\n"
     "\n"
     "\n"
     "RECIPE PRODUCTS: \n"
     "-------------------- \n"
     "Tag                      Format         Description\n"
     "ZPL_SCIENCE_P1_REDUCED_Q           FITS[Im(8)]    The final combined science frame [I_Q, P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the Q measurement I_Q  corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the Q measurement P_Q  , corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QPLUS       FITS[Im(8)]    The resulting combined science frame of [+I_Q, +P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +Q measurement +I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +Q measurement +P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QMINUS      FITS[Im(8)]    The resulting combined science frame [-I_Q, -P_Q] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -Q measurement -I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -Q measurement -P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_U           FITS[Im(8)]    The final combined science frame [I_U, P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the  U measurement I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the U measurement  P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UPLUS       FITS[Im(8)]    The resulting combined science frame of [+I_U, +P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +U measurement +I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +U measurement +P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UMINUS      FITS[Im(8)]    The resulting combined science frame [-I_U, -P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -U measurement -I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -U measurement -P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_Q_CAM1      FITS[Im(8)]    The final combined science frame [I_Q, P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the Q measurement I_Q  corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the Q measurement P_Q  , corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM1  FITS[Im(8)]    The resulting combined science frame of [+I_Q, +P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +Q measurement +I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +Q measurement +P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QMINUS_CAM1 FITS[Im(8)]    The resulting combined science frame [-I_Q, -P_Q] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -Q measurement -I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -Q measurement -P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_U_CAM1      FITS[Im(8)]    The final combined science frame [I_U, P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the  U measurement I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the U measurement  P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UPLUS_CAM1  FITS[Im(8)]    The resulting combined science frame of [+I_U, +P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +U measurement +I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +U measurement +P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UMINUS_CAM1 FITS[Im(8)]    The resulting combined science frame [-I_U, -P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -U measurement -I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -U measurement -P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_Q_CAM2      FITS[Im(8)]    The final combined science frame [I_Q, P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the Q measurement I_Q  corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the Q measurement P_Q  , corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM2  FITS[Im(8)]    The resulting combined science frame of [+I_Q, +P_Q]  is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +Q measurement +I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +Q measurement +P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_QMINUS_CAM2 FITS[Im(8)]    The resulting combined science frame [-I_Q, -P_Q] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -Q measurement -I_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -Q measurement -P_Q, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_U_CAM2      FITS[Im(8)]    The final combined science frame [I_U, P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the  U measurement I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the U measurement  P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UPLUS_CAM2  FITS[Im(8)]    The resulting combined science frame of [+I_U, +P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science plus intensity image of the +U measurement +I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science plus polarization image of the +U measurement +P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "ZPL_SCIENCE_P1_REDUCED_UMINUS_CAM2 FITS[Im(8)]    The resulting combined science frame [-I_U, -P_U] is of the DOUBLE IMAGE format.\n"
     "                                        This frame contains 8 image extensions:\n"
     "                                        - reduced science intensity image of the -U measurement -I_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "                                        - reduced science polarization image of the -U measurement -P_U, corresponding badpixel-map, ncomb-map and rms-map;\n"
     "\n"
     "PRODUCT FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Frame          Type    Description\n"
     "\n"
 ;
 
 /*-----------------------------------------------------------------------------
  Function code
  -----------------------------------------------------------------------------*/
 /*----------------------------------------------------------------------------*/
 /**
  * @defgroup sph_zpl_science_p1 Create Master Dark Recipe
  *
  * This module provides the recipe plugin and relating functions for the
  * creation of the master dark .
  *
  * @par Synopsis:
  * @code
  *   #include "sph_zpl_science_p1.h"
  * @endcode
  */
 /*----------------------------------------------------------------------------*/
 /**@{*/
 
 /*****************************************************************************
  *
  *
  *      First come the static and global functions necessary for the
  *      normal working of the recipe as plugin....
  *
  *
  * ***************************************************************************/
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Build the list of available plugins, for this module.
  @param    list    the plugin list
  @return   0 if everything is ok, 1 otherwise
  @note     Only this function is exported
 
  Create the recipe instance and make it available to the application
  using the interface.
  */
 /*----------------------------------------------------------------------------*/
 int cpl_plugin_get_info(cpl_pluginlist * list)
 {
     cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
     cpl_plugin * plugin = &recipe->interface;
 
     if (cpl_plugin_init(plugin,
                         CPL_PLUGIN_API,
                         SPH_ZPL_SCIENCE_P1_VERSION,
                         CPL_PLUGIN_TYPE_RECIPE,
                         "sph_zpl_science_p1",
                         "Reduce science frames of the Q and/or U observations in the polarization P1 mode.",
                         sph_zpl_science_p1_help, "Alexey Pavlov <pavlov@mpia-hd.mpg.de>",
                         "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                         sph_zpl_science_p1_create_plugin,
                         sph_zpl_science_p1_exec_plugin,
                         sph_zpl_science_p1_destroy_plugin) )
     {
         cpl_msg_error( cpl_func, "Plugin initialization failed");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
 
     if (cpl_pluginlist_append(list, plugin) )
     {
         cpl_msg_error( cpl_func, "Error adding plugin to list");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Setup the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Defining the command-line/configuration parameters for the recipe.
  */
 /*----------------------------------------------------------------------------*/
 static int sph_zpl_science_p1_create_plugin(cpl_plugin * plugin)
 {
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                        cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error(cpl_func, "Null plugin");
         cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     if ( plugin != NULL ) {
         cpl_recipe * recipe = (cpl_recipe *)plugin;
         recipe->parameters = sph_zpl_science_p1_create_paramlist();
         if ( recipe->parameters == NULL ) {
             return SPH_ZPL_SCIENCE_P1_GENERAL;
         }
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Testing for setup of the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Wrapper to make the static plugin creation function accessible from outside
  for testing purposes.
  */
 /*----------------------------------------------------------------------------*/
 int sph_zpl_science_p1_create_test(cpl_plugin * plugin)
 {
     return (int)sph_zpl_science_p1_create_plugin(plugin);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Execute the plugin instance given by the interface
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_zpl_science_p1_exec_plugin(cpl_plugin * plugin)
 {
 
     cpl_recipe*             recipe                  = NULL;
     cpl_error_code          recipe_code;
     sph_zpl_science_p1*    sph_recipe      = NULL;
     cpl_errorstate          initial_errorstate      = cpl_errorstate_get();
 
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
         cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
         return (int)cpl_error_get_code();
     }
 
     recipe = (cpl_recipe *)plugin;
 
     if (recipe->parameters == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (recipe->frames == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     sph_recipe = sph_zpl_science_p1_new( recipe->frames, recipe->parameters );
     if ( sph_recipe == NULL ) {
         recipe_code = cpl_error_set_where(cpl_func);
     } else {
 
         recipe_code = sph_zpl_science_p1_run( sph_recipe );
 
         sph_zpl_science_p1_delete( sph_recipe );
     }
 
     if ( !cpl_errorstate_is_equal(initial_errorstate) )
     {
         cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
     }
     sph_end_erex(); //close the sphere system
     return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                  ? CPL_ERROR_EOL : recipe_code);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Destroy what has been created by the 'create' function
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_zpl_science_p1_destroy_plugin(cpl_plugin * plugin)
 {
     cpl_recipe * recipe;
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     recipe = (cpl_recipe *)plugin;
 
     cpl_parameterlist_delete(recipe->parameters);
 
     return 0;
 }
 
 /*****************************************************************************
  *
  *
  *      Here come the "Member" functions of the sph_zpl_science_p1 struct
  *
  *
  * ***************************************************************************/
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Fill a pre-allocated parameterlist for the recipe
  @param    result A pre-allocated parameterlist
  @return   CPL_ERROR_NONE iff successful
 
  This function fills the standard parameterlist for the recipe
 
  */
 /*----------------------------------------------------------------------------*/
 static cpl_error_code sph_zpl_science_p1_fill_parameterlist(cpl_parameterlist * result)
 {
     cpl_parameter* p;
 
         /* Code to set up parameters GENERATED DO NOT EDIT */

         p = cpl_parameter_new_value("zpl.science_p1.outfilename_q",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_q.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_q.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_q",
                                    "zpl_science_p1_plus_q.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_q.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_q",
                                    "zpl_science_p1_minus_q.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.outfilename_u",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_u.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_u.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_u",
                                    "zpl_science_p1_plus_u_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_u.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_u",
                                    "zpl_science_p1_minus_u.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.outfilename_q_cam1",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_q_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_q_cam1.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_q_cam1",
                                    "zpl_science_p1_plus_q_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_q_cam1.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_q_cam1",
                                    "zpl_science_p1_minus_q_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.outfilename_u_cam1",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_u_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_u_cam1.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_u_cam1",
                                    "zpl_science_p1_plus_u_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_u_cam1.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_u_cam1",
                                    "zpl_science_p1_minus_u_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.outfilename_q_cam2",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_q_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_q_cam2.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_q_cam2",
                                    "zpl_science_p1_plus_q_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_q_cam2.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -Q. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_q_cam2",
                                    "zpl_science_p1_minus_q_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.outfilename_u_cam2",
                                    CPL_TYPE_STRING,
                                    "The output filename for the final science product U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1",
                                    "zpl_science_p1_u_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_plus_u_cam2.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science plus product +U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_plus_u_cam2",
                                    "zpl_science_p1_plus_u_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1_minus_u_cam2.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the science minus product -U. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"zpl.science_p1_minus_u_cam2",
                                    "zpl_science_p1_minus_u_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.subtract_overscan",
                                    CPL_TYPE_BOOL,
                                    "Flag to set if the overscan mean values must be subtracted from pre-processed data (TRUE) "
                                    "Note that this parameter is applied if pre-processed data containt overscan table "
                                    ,"zpl.science_p1",
                                    1 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.keep_intermediate",
                                    CPL_TYPE_BOOL,
                                    "Flag to set if intermediate data must be saved, namely pre-processed and overscan pre-processed subtracted data (FALSE) "
                                    "Note that this setting this parameter to TRUE will use a very large amount of disk space "
                                    ,"zpl.science_p1",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.save_interprod",
                                    CPL_TYPE_BOOL,
                                    "Flag to set if the field center table, plus the final calibrated cube without rotation, must be saved as intermediate product (FALSE) "
                                    "Note that this parameter must be only applied for the offline pipeline "
                                    ,"zpl.science_p1",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("zpl.science_p1.coll_alg",
                                    CPL_TYPE_INT,
                                    "Set the collapse algorithm. The available algorithms: 0 = Mean, 1 = Median. Default is 0 = Mean. "
                                    ,"zpl.science_p1",
                                    0 ,
                                    3,0,1,2);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("zpl.science_p1.filter_radius",
                                    CPL_TYPE_DOUBLE,
                                    "Filter radius for frame combination. A non zero value leads to suppression "
                                    "of high frequencies in the fourier domain before frame combination. The value "
                                    "expresses the minimum unsuppressed frequency as fraction of total frequency "
                                    "domain radius (a value of 1 would suppress essentially all frequencies). "
                                    ,"zpl.science_p1",
                                    0.0 ,
                                    0.0,1.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.science_p1.star_center_iframe",
                                    CPL_TYPE_BOOL,
                                    "Flag to set if only the center coordinates of the iframe from the star center calibration frame "
                                    "should be used as a center coordinates to de-rotate iframe and pframe (TRUE) "
                                    ,"zpl.science_p1",
                                    1 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("zpl.science_p1.center_xoffset_cam1",
                                    CPL_TYPE_DOUBLE,
                                    "X-offset from the center of the image for cam1 "
                                    ,"zpl.science_p1",
                                    0.0 ,
                                    -512.0,512.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("zpl.science_p1.center_yoffset_cam1",
                                    CPL_TYPE_DOUBLE,
                                    "Y-offset from the center of the image for cam1 "
                                    ,"zpl.science_p1",
                                    0.0 ,
                                    -512.0,512.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("zpl.science_p1.center_xoffset_cam2",
                                    CPL_TYPE_DOUBLE,
                                    "X-offset from the center of the image for cam2 "
                                    ,"zpl.science_p1",
                                    0.0 ,
                                    -512.0,512.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("zpl.science_p1.center_yoffset_cam2",
                                    CPL_TYPE_DOUBLE,
                                    "Y-offset from the center of the image for cam2 "
                                    ,"zpl.science_p1",
                                    0.0 ,
                                    -512.0,512.0);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.preproc.outfilename_cam1",
                                    CPL_TYPE_STRING,
                                    "The postfix-  of the intermediate filename of the pre-processed raw data for the CAMERA-1. "
                                    ,"zpl.preproc",
                                    "preproc_cam1.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("zpl.preproc.outfilename_cam2",
                                    CPL_TYPE_STRING,
                                    "The postfix- of the  intermediate filename of the pre-processed raw data for the CAMERA-2. "
                                    ,"zpl.preproc",
                                    "preproc_cam2.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return cpl_error_set_where(cpl_func);
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief  Create and return the standard parameterlist for the recipe
  @return The standard parameterlist or NULL on error
  @note   The returned object must be deallocated using cpl_parameterlist_delete
 
  */
 /*----------------------------------------------------------------------------*/
 cpl_parameterlist* sph_zpl_science_p1_create_paramlist(void)
 {
     cpl_parameterlist* self = cpl_parameterlist_new();
 
     if (sph_zpl_science_p1_fill_parameterlist(self)) {
         cpl_parameterlist_delete(self);
         self = NULL;
         (void)cpl_error_set_where(cpl_func);
     }
 
     return self;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe frames, and assign them to the sph_zpl_science_p1
            structure.
  @param    self     the sph_zpl_science_p1 recipe structure
  @return   error code of the check.
 
  This checks the frames that were given in the sph_zpl_science_p1_new function
  as parameters for the correctness and completeness. If the frames needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code  sph_zpl_science_p1_check_frames( sph_zpl_science_p1* self )
 {
     sph_error_code           rerr            = CPL_ERROR_NONE;
     /* Code to check frames GENERATED DO NOT EDIT */

     cpl_frame* aframe;
     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_RAW );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->rawframes = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_RAW );
     if ( ! self->rawframes )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract rawframes frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_SCIENCE_P1_RAW);
         cpl_error_reset();
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->rawframes );
          for ( int ii = 0; ii < numframes; ++ii ) {
              cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
              const char* ifname = cpl_frame_get_filename(iframe);
              cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
              if (pl == NULL ) {
                  sph_error_raise(cpl_error_get_code(),
                     __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Could not read keywords from file %s. "
                  "Either the file is not readable or corrupted. ",
                   ifname);
              }
              else {
                  rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                  int haskey, okval;
                  haskey = 0;okval = 0;
                  if ( cpl_propertylist_has(pl,"ESO DRS PC PROD TYPE") )  {
                      haskey = 1;
                      if ( cpl_propertylist_get_type(pl,"ESO DRS PC PROD TYPE") == CPL_TYPE_STRING )  {
                          okval = 1; //Type is string so always ok
                      } 
                      if ( haskey == 0 || okval == 0 ) {
                          sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                             __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                          "Could not read a keyword ESO DRS PC PROD TYPE from file %s. "
                          "that has __type string "
                          "and values between 0.0 and 0.0 "
                          "The recipe requires this. ",
                          ifname);
                      }
                  }
                  haskey = 0;okval = 0;
                  if ( cpl_propertylist_has(pl,"ESO OCS3 ZIMPOL POL STOKES") )  {
                      haskey = 1;
                      if ( cpl_propertylist_get_type(pl,"ESO OCS3 ZIMPOL POL STOKES") == CPL_TYPE_STRING )  {
                          okval = 1; //Type is string so always ok
                      } 
                      if ( haskey == 0 || okval == 0 ) {
                          sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                             __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                          "Could not read a keyword ESO OCS3 ZIMPOL POL STOKES from file %s. "
                          "that has __type string "
                          "and values between 0.0 and 0.0 "
                          "The recipe requires this. ",
                          ifname);
                      }
                  }
                  cpl_propertylist_delete(pl); pl=NULL;
              }
          }
          numframes -= (int)cpl_frameset_get_size( self->rawframes );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_RAW );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->preproc_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_RAW );
     if ( ! self->preproc_frames )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract preproc_frames frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_SCIENCE_P1_PREPROC_RAW);
         cpl_error_reset();
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->preproc_frames );
          for ( int ii = 0; ii < numframes; ++ii ) {
          }
          numframes -= (int)cpl_frameset_get_size( self->preproc_frames );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->preproc_frames_cam1 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM1 );
     if ( ! self->preproc_frames_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract preproc_frames_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM1);
         cpl_error_reset();
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
          for ( int ii = 0; ii < numframes; ++ii ) {
          }
          numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->preproc_frames_cam2 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM2 );
     if ( ! self->preproc_frames_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract preproc_frames_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM2);
         cpl_error_reset();
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
          for ( int ii = 0; ii < numframes; ++ii ) {
          }
          numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_bias_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB );
     if ( ! self->master_bias_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_bias_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_BIAS_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_bias_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_bias_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM1 );
     if ( ! self->master_bias_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_bias_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_BIAS_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_bias_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_bias_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM2 );
     if ( ! self->master_bias_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_bias_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_BIAS_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_bias_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB );
     if ( ! self->master_dark_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_DARK_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM1 );
     if ( ! self->master_dark_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_DARK_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM2 );
     if ( ! self->master_dark_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_DARK_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB );
     if ( ! self->intensity_flat_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFF_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM1 );
     if ( ! self->intensity_flat_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFF_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM2 );
     if ( ! self->intensity_flat_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFF_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame_master = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB );
     if ( ! self->intensity_flat_frame_master )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame_master frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFFM_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame_master, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame_master_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM1 );
     if ( ! self->intensity_flat_frame_master_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame_master_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFFM_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame_master_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->intensity_flat_frame_master_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM2 );
     if ( ! self->intensity_flat_frame_master_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract intensity_flat_frame_master_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_IFFM_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->intensity_flat_frame_master_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->polarization_flat_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_PFF_CALIB );
     if ( ! self->polarization_flat_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract polarization_flat_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_PFF_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->polarization_flat_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->polarization_flat_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_PFF_CALIB_CAM1 );
     if ( ! self->polarization_flat_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract polarization_flat_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_PFF_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->polarization_flat_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->polarization_flat_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_PFF_CALIB_CAM2 );
     if ( ! self->polarization_flat_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract polarization_flat_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_PFF_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->polarization_flat_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->modem_efficiency_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB );
     if ( ! self->modem_efficiency_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract modem_efficiency_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_MODEM_EFF_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->modem_efficiency_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->modem_efficiency_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM1 );
     if ( ! self->modem_efficiency_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract modem_efficiency_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->modem_efficiency_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->modem_efficiency_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM2 );
     if ( ! self->modem_efficiency_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract modem_efficiency_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->modem_efficiency_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM1 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->star_center_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM1 );
     if ( ! self->star_center_frame_cam1 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract star_center_frame_cam1 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM1);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->star_center_frame_cam1, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM2 );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->star_center_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM2 );
     if ( ! self->star_center_frame_cam2 )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract star_center_frame_cam2 frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM2);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->star_center_frame_cam2, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->star_center_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_POL_CALIB );
     if ( ! self->star_center_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract star_center_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_STAR_CENTER_POL_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->star_center_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_FIELD_CENTER_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->fctable_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_FIELD_CENTER_CALIB );
     if ( ! self->fctable_frames )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract fctable_frames frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_FIELD_CENTER_CALIB);
         cpl_error_reset();
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->fctable_frames );
          for ( int ii = 0; ii < numframes; ++ii ) {
          }
          numframes -= (int)cpl_frameset_get_size( self->fctable_frames );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_POL_HIGH_CATG );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->high_polarization_std_stars_catalog = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_POL_HIGH_CATG );
     if ( ! self->high_polarization_std_stars_catalog )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract high_polarization_std_stars_catalog frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_POL_HIGH_CATG);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->high_polarization_std_stars_catalog, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_FILTER_TABLE_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->filter_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_FILTER_TABLE_CALIB );
     if ( ! self->filter_frame )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract filter_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_FILTER_TABLE_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->filter_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_POL_CORRECTIONS_TABLE_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->std_star_pol_correction = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_POL_CORRECTIONS_TABLE_CALIB );
     if ( ! self->std_star_pol_correction )
     {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract std_star_pol_correction frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_ZPL_TAG_POL_CORRECTIONS_TABLE_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->std_star_pol_correction, CPL_FRAME_GROUP_CALIB );
     }

     /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );
 
     return rerr;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe parameters, and assign them to the sph_zpl_science_p1
            structure.
  @param    self     the sph_zpl_science_p1 recipe structure
  @return   error code of the check.
 
  This checks the parameters that were given in the sph_zpl_science_p1_new function
  as parameters for the correctness and completeness. If the parameters needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_zpl_science_p1_check_params( sph_zpl_science_p1* self ) {
     sph_error_code                 rerr               = CPL_ERROR_NONE;
     const cpl_parameter*           param              = NULL;
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
     self->framecomb_parameterlist = cpl_parameterlist_new();
     /* Code to check parameters GENERATED DO NOT EDIT */

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_q");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_q");
     }

     self->science_p1_outfilename_q = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_q.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_q.outfilename");
     }

     self->science_p1_plus_q_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_q.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_q.outfilename");
     }

     self->science_p1_minus_q_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_u");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_u");
     }

     self->science_p1_outfilename_u = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_u.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_u.outfilename");
     }

     self->science_p1_plus_u_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_u.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_u.outfilename");
     }

     self->science_p1_minus_u_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_q_cam1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_q_cam1");
     }

     self->science_p1_outfilename_q_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_q_cam1.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_q_cam1.outfilename");
     }

     self->science_p1_plus_q_outfilename_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_q_cam1.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_q_cam1.outfilename");
     }

     self->science_p1_minus_q_outfilename_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_u_cam1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_u_cam1");
     }

     self->science_p1_outfilename_u_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_u_cam1.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_u_cam1.outfilename");
     }

     self->science_p1_plus_u_outfilename_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_u_cam1.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_u_cam1.outfilename");
     }

     self->science_p1_minus_u_outfilename_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_q_cam2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_q_cam2");
     }

     self->science_p1_outfilename_q_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_q_cam2.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_q_cam2.outfilename");
     }

     self->science_p1_plus_q_outfilename_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_q_cam2.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_q_cam2.outfilename");
     }

     self->science_p1_minus_q_outfilename_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.outfilename_u_cam2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.outfilename_u_cam2");
     }

     self->science_p1_outfilename_u_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_plus_u_cam2.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_plus_u_cam2.outfilename");
     }

     self->science_p1_plus_u_outfilename_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1_minus_u_cam2.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1_minus_u_cam2.outfilename");
     }

     self->science_p1_minus_u_outfilename_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.subtract_overscan");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.subtract_overscan");
     }

     self->subtract_overscan = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.keep_intermediate");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.keep_intermediate");
     }

     self->keep_intermediate = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.save_interprod");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.save_interprod");
     }

     self->save_interprod = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.coll_alg");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.coll_alg");
     }

     self->coll_alg = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.filter_radius");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.filter_radius");
     }

     self->filter_radius = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.star_center_iframe");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.star_center_iframe");
     }

     self->star_center_iframe = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.center_xoffset_cam1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.center_xoffset_cam1");
     }

     self->center_xoffset_cam1 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.center_yoffset_cam1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.center_yoffset_cam1");
     }

     self->center_yoffset_cam1 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.center_xoffset_cam2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.center_xoffset_cam2");
     }

     self->center_xoffset_cam2 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.science_p1.center_yoffset_cam2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.science_p1.center_yoffset_cam2");
     }

     self->center_yoffset_cam2 = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.preproc.outfilename_cam1");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.preproc.outfilename_cam1");
     }

     self->outfilename_cam1 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "zpl.preproc.outfilename_cam2");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "zpl.preproc.outfilename_cam2");
     }

     self->outfilename_cam2 = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return rerr;
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Create a new sph_zpl_science_p1 structure.
 
  @param    frameset     the input recipe frames
  @param    parlist      the input recipe parameters
 
  @return   pointer to newly created structure or NULL in case of error
 
  This creates a new sph_zpl_science_p1_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_zpl_science_p1* sph_zpl_science_p1_new( cpl_frameset * frameset,
                                               cpl_parameterlist * parlist )
 {
     sph_zpl_science_p1*    result      = NULL;
     int                     rerr        = CPL_ERROR_NONE;
 
     sph_init_erex();
     if ( frameset == NULL || parlist == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return NULL;
     }
 
     result = cpl_calloc( 1, sizeof(sph_zpl_science_p1) );
 
     if ( result == NULL ) {
         sph_error_raise( SPH_ZPL_SCIENCE_P1_GENERAL, __FILE__, __func__,
                          __LINE__, SPH_ERROR_ERROR,
                          "Could not allocate the structure.");
         return result;
     }
 
     result->inframes = frameset;
     result->inparams = parlist;
 
     rerr = sph_zpl_science_p1_check_frames( result );
     if ( rerr == CPL_ERROR_NONE) rerr = sph_zpl_science_p1_check_params( result );
 
     if ( rerr != CPL_ERROR_NONE ) {
         if ( result ) {
             sph_zpl_science_p1_delete( result );
         }
         result = NULL;
     }
 
     return result;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Delete the sph_zpl_science_p1 structure.
 
  @param    self         the structure tp delete
 
  @return   error code of the operation
 
  This creates a new sph_zpl_science_p1_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_zpl_science_p1_delete( sph_zpl_science_p1* self )
 {
     sph_error_code          rerr            = CPL_ERROR_NONE;
 
     if ( self == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return rerr;
     }
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
 
     /* Code to delete recipe pointers GENERATED DO NOT EDIT */

     if ( self->rawframes != NULL ) {
         cpl_frameset_delete( self->rawframes );
         self->rawframes = NULL;
     }
     if ( self->preproc_frames != NULL ) {
         cpl_frameset_delete( self->preproc_frames );
         self->preproc_frames = NULL;
     }
     if ( self->preproc_frames_cam1 != NULL ) {
         cpl_frameset_delete( self->preproc_frames_cam1 );
         self->preproc_frames_cam1 = NULL;
     }
     if ( self->preproc_frames_cam2 != NULL ) {
         cpl_frameset_delete( self->preproc_frames_cam2 );
         self->preproc_frames_cam2 = NULL;
     }
     if ( self->master_bias_frame != NULL ) {
         cpl_frame_delete( self->master_bias_frame );
         self->master_bias_frame = NULL;
     }
     if ( self->master_bias_frame_cam1 != NULL ) {
         cpl_frame_delete( self->master_bias_frame_cam1 );
         self->master_bias_frame_cam1 = NULL;
     }
     if ( self->master_bias_frame_cam2 != NULL ) {
         cpl_frame_delete( self->master_bias_frame_cam2 );
         self->master_bias_frame_cam2 = NULL;
     }
     if ( self->master_dark_frame != NULL ) {
         cpl_frame_delete( self->master_dark_frame );
         self->master_dark_frame = NULL;
     }
     if ( self->master_dark_frame_cam1 != NULL ) {
         cpl_frame_delete( self->master_dark_frame_cam1 );
         self->master_dark_frame_cam1 = NULL;
     }
     if ( self->master_dark_frame_cam2 != NULL ) {
         cpl_frame_delete( self->master_dark_frame_cam2 );
         self->master_dark_frame_cam2 = NULL;
     }
     if ( self->intensity_flat_frame != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame );
         self->intensity_flat_frame = NULL;
     }
     if ( self->intensity_flat_frame_cam1 != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame_cam1 );
         self->intensity_flat_frame_cam1 = NULL;
     }
     if ( self->intensity_flat_frame_cam2 != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame_cam2 );
         self->intensity_flat_frame_cam2 = NULL;
     }
     if ( self->intensity_flat_frame_master != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame_master );
         self->intensity_flat_frame_master = NULL;
     }
     if ( self->intensity_flat_frame_master_cam1 != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame_master_cam1 );
         self->intensity_flat_frame_master_cam1 = NULL;
     }
     if ( self->intensity_flat_frame_master_cam2 != NULL ) {
         cpl_frame_delete( self->intensity_flat_frame_master_cam2 );
         self->intensity_flat_frame_master_cam2 = NULL;
     }
     if ( self->polarization_flat_frame != NULL ) {
         cpl_frame_delete( self->polarization_flat_frame );
         self->polarization_flat_frame = NULL;
     }
     if ( self->polarization_flat_frame_cam1 != NULL ) {
         cpl_frame_delete( self->polarization_flat_frame_cam1 );
         self->polarization_flat_frame_cam1 = NULL;
     }
     if ( self->polarization_flat_frame_cam2 != NULL ) {
         cpl_frame_delete( self->polarization_flat_frame_cam2 );
         self->polarization_flat_frame_cam2 = NULL;
     }
     if ( self->modem_efficiency_frame != NULL ) {
         cpl_frame_delete( self->modem_efficiency_frame );
         self->modem_efficiency_frame = NULL;
     }
     if ( self->modem_efficiency_frame_cam1 != NULL ) {
         cpl_frame_delete( self->modem_efficiency_frame_cam1 );
         self->modem_efficiency_frame_cam1 = NULL;
     }
     if ( self->modem_efficiency_frame_cam2 != NULL ) {
         cpl_frame_delete( self->modem_efficiency_frame_cam2 );
         self->modem_efficiency_frame_cam2 = NULL;
     }
     if ( self->star_center_frame_cam1 != NULL ) {
         cpl_frame_delete( self->star_center_frame_cam1 );
         self->star_center_frame_cam1 = NULL;
     }
     if ( self->star_center_frame_cam2 != NULL ) {
         cpl_frame_delete( self->star_center_frame_cam2 );
         self->star_center_frame_cam2 = NULL;
     }
     if ( self->star_center_frame != NULL ) {
         cpl_frame_delete( self->star_center_frame );
         self->star_center_frame = NULL;
     }
     if ( self->fctable_frames != NULL ) {
         cpl_frameset_delete( self->fctable_frames );
         self->fctable_frames = NULL;
     }
     if ( self->high_polarization_std_stars_catalog != NULL ) {
         cpl_frame_delete( self->high_polarization_std_stars_catalog );
         self->high_polarization_std_stars_catalog = NULL;
     }
     if ( self->filter_frame != NULL ) {
         cpl_frame_delete( self->filter_frame );
         self->filter_frame = NULL;
     }
     if ( self->std_star_pol_correction != NULL ) {
         cpl_frame_delete( self->std_star_pol_correction );
         self->std_star_pol_correction = NULL;
     }
  
     sph_zpl_science_pol_product_delete(self->science_di_q);
     sph_zpl_science_pol_product_delete(self->science_di_q_plus);
     sph_zpl_science_pol_product_delete(self->science_di_q_minus);
     sph_zpl_science_pol_product_delete(self->science_di_u);
     sph_zpl_science_pol_product_delete(self->science_di_u_plus);
     sph_zpl_science_pol_product_delete(self->science_di_u_minus);
     sph_zpl_science_pol_product_delete(self->science_di_q_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_q_plus_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_q_minus_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_u_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_u_plus_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_u_minus_cam1);
     sph_zpl_science_pol_product_delete(self->science_di_q_cam2);
     sph_zpl_science_pol_product_delete(self->science_di_q_plus_cam2);
     sph_zpl_science_pol_product_delete(self->science_di_q_minus_cam2);
     sph_zpl_science_pol_product_delete(self->science_di_u_cam2);
     sph_zpl_science_pol_product_delete(self->science_di_u_plus_cam2);
     sph_zpl_science_pol_product_delete(self->science_di_u_minus_cam2);
     /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     if ( self->current_raw_frameset ) {
         cpl_frameset_delete(self->current_raw_frameset);
         self->current_raw_frameset = NULL;
     }
     sph_polygon_free_all();
     cpl_free(    self);
     return rerr;
 
 }
 
 
 /**@}*/
 