/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


/*
 * sph_zpl_star_center_common.h
 *
 *  Created on: Nov 26, 2015
 *      Author: pavlov
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_error.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"

#ifndef SPH_ZPL_STAR_CENTER_COMMON_H_
#define SPH_ZPL_STAR_CENTER_COMMON_H_


/*-----------------------------------------------------------------------------
 Type definition
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
 Function declaration
 -----------------------------------------------------------------------------*/

sph_error_code sph_zpl_star_center_common_get_center( sph_master_frame* mf,
                                                       double sigma, int unsharp_window,
                                                       double* dx,   double* dy );

cpl_propertylist* sph_zpl_star_center_common_get_center_double_image( sph_double_image* di,
                                                       double sigma, int unsharp_window);

#endif /* SPH_ZPL_STAR_CENTER_COMMON_H_ */
