/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include<config.h>

#ifndef SPH_ZPL_TAGS_H_
#define SPH_ZPL_TAGS_H_

#define SPH_RECIPE_NAME_ZPL_PREPROC					  "sph_zpl_preproc"
#define SPH_RECIPE_NAME_ZPL_MASTER_BIAS				  "sph_zpl_master_bias"
#define SPH_RECIPE_NAME_ZPL_MASTER_BIAS_IMAGING		  "sph_zpl_master_bias_imaging"
#define SPH_RECIPE_NAME_ZPL_MASTER_DARK_IMAGING		  "sph_zpl_master_dark_imaging"
#define SPH_RECIPE_NAME_ZPL_MASTER_DARK              "sph_zpl_master_dark"
#define SPH_RECIPE_NAME_ZPL_IFF                      "sph_zpl_intensity_flat"
#define SPH_RECIPE_NAME_ZPL_IFF_IMAGING              "sph_zpl_intensity_flat_imaging"
#define SPH_RECIPE_NAME_ZPL_PFF                      "sph_zpl_polarization_flat"
#define SPH_RECIPE_NAME_ZPL_MEFF                     "sph_zpl_modem_efficiency"
#define SPH_RECIPE_NAME_ZPL_SCIENCE_P1			  	  "sph_zpl_science_p1"
#define SPH_RECIPE_NAME_ZPL_SCIENCE_P23				  "sph_zpl_science_p23"
#define SPH_RECIPE_NAME_ZPL_SCIENCE_IMAGING			  "sph_zpl_science_imaging"
#define SPH_RECIPE_NAME_ZPL_STAR_CENTER_IMG           "sph_zpl_star_center_img"
#define SPH_RECIPE_NAME_ZPL_STAR_CENTER_POL           "sph_zpl_star_center_pol"
#define SPH_PIPELINE_NAME_ZIMPOL                     PACKAGE_STRING
#define SPH_ZPL_TAG_SCIENCE_RAW               		 "ZPL_SCIENCE_RAW"

#define SPH_ZPL_TAG_PREPROC_RAW                         "ZPL_PREPROC_RAW"
#define SPH_ZPL_TAG_PREPROC_CALIB                       "ZPL_PREPROC" // It must be changed for each sort of Raw Data
#define SPH_ZPL_TAG_PREPROC_IMAGING_RAW                         "ZPL_PREPROC_IMAGING_RAW"
#define SPH_ZPL_TAG_PREPROC_IMAGING_CALIB                       "ZPL_PREPROC_IMAGING" // It must be changed for each sort of Raw Data
#define SPH_ZPL_TAG_REMOVE_RAW                         "ZPL_REMOVE_RAW"
#define SPH_ZPL_TAG_REMOVE_CALIB                       "ZPL_REMOVE"

#define SPH_ZPL_TAG_DARK_RAW                         "ZPL_DARK_RAW"
#define SPH_ZPL_TAG_DARK_PREPROC_RAW				 "ZPL_DARK_PREPROC"
#define SPH_ZPL_TAG_DARK_PREPROC_CAM1				 "ZPL_DARK_PREPROC_CAM1"
#define SPH_ZPL_TAG_DARK_PREPROC_CAM2				 "ZPL_DARK_PREPROC_CAM2"
#define SPH_ZPL_TAG_DARK_CALIB                       "ZPL_MASTER_DARK"
#define SPH_ZPL_TAG_DARK_CALIB_CAM1                  "ZPL_MASTER_DARK_CAM1"
#define SPH_ZPL_TAG_DARK_CALIB_CAM2                  "ZPL_MASTER_DARK_CAM2"

#define SPH_ZPL_TAG_PFF_RAW                         "ZPL_POL_FLAT_FIELD_RAW"
#define SPH_ZPL_TAG_PFF_PREPROC_RAW					"ZPL_POL_FLAT_PREPROC"
#define SPH_ZPL_TAG_PFF_PREPROC_CAM1				"ZPL_POL_FLAT_PREPROC_CAM1"
#define SPH_ZPL_TAG_PFF_PREPROC_CAM2				"ZPL_POL_FLAT_PREPROC_CAM2"
#define SPH_ZPL_TAG_PFF_CALIB                       "ZPL_POL_FLAT_FIELD"
#define SPH_ZPL_TAG_PFF_CALIB_CAM1                  "ZPL_POL_FLAT_FIELD_CAM1"
#define SPH_ZPL_TAG_PFF_CALIB_CAM2                  "ZPL_POL_FLAT_FIELD_CAM2"

#define SPH_ZPL_TAG_BIAS_RAW                          "ZPL_BIAS_RAW"
#define SPH_ZPL_TAG_BIAS_PREPROC_RAW				  "ZPL_BIAS_PREPROC"
#define SPH_ZPL_TAG_BIAS_PREPROC_CAM1				  "ZPL_BIAS_PREPROC_CAM1"
#define SPH_ZPL_TAG_BIAS_PREPROC_CAM2				  "ZPL_BIAS_PREPROC_CAM2"
#define SPH_ZPL_TAG_BIAS_CALIB                        "ZPL_MASTER_BIAS"
#define SPH_ZPL_TAG_BIAS_CALIB_CAM1					  "ZPL_MASTER_BIAS_CAM1"
#define SPH_ZPL_TAG_BIAS_CALIB_CAM2					  "ZPL_MASTER_BIAS_CAM2"

#define SPH_ZPL_TAG_BIAS_IMAGING_RAW                          "ZPL_BIAS_IMAGING_RAW"
#define SPH_ZPL_TAG_BIAS_IMAGING_PREPROC_RAW				  "ZPL_BIAS_IMAGING_PREPROC"
#define SPH_ZPL_TAG_BIAS_IMAGING_PREPROC_CAM1				  "ZPL_BIAS_IMAGING_PREPROC_CAM1"
#define SPH_ZPL_TAG_BIAS_IMAGING_PREPROC_CAM2				  "ZPL_BIAS_IMAGING_PREPROC_CAM2"
#define SPH_ZPL_TAG_BIAS_IMAGING_CALIB           	          "ZPL_MASTER_BIAS_IMAGING"
#define SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1                   "ZPL_MASTER_BIAS_IMAGING_CAM1"
#define SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2                   "ZPL_MASTER_BIAS_IMAGING_CAM2"

#define SPH_ZPL_TAG_DARK_IMAGING_RAW                          "ZPL_DARK_IMAGING_RAW"
#define SPH_ZPL_TAG_DARK_IMAGING_PREPROC_RAW				  "ZPL_DARK_IMAGING_PREPROC"
#define SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM1				  "ZPL_DARK_IMAGING_PREPROC_CAM1"
#define SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM2				  "ZPL_DARK_IMAGING_PREPROC_CAM2"
#define SPH_ZPL_TAG_DARK_IMAGING_CALIB                        "ZPL_MASTER_DARK_IMAGING"
#define SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM1                   "ZPL_MASTER_DARK_IMAGING_CAM1"
#define SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM2                   "ZPL_MASTER_DARK_IMAGING_CAM2"

#define SPH_ZPL_TAG_IFF_IMAGING_RAW                          "ZPL_INT_FLAT_FIELD_IMAGING_RAW"
#define SPH_ZPL_TAG_IFF_IMAGING_PREPROC_RAW					 "ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_RAW"
#define SPH_ZPL_TAG_IFF_IMAGING_PREPROC_CAM1				 "ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_CAM1"
#define SPH_ZPL_TAG_IFF_IMAGING_PREPROC_CAM2				 "ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_CAM2"
#define SPH_ZPL_TAG_IFF_IMAGING_CALIB           	         "ZPL_INT_FLAT_FIELD_IMAGING"
#define SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM1         	         "ZPL_INT_FLAT_FIELD_IMAGING_CAM1"
#define SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM2         	         "ZPL_INT_FLAT_FIELD_IMAGING_CAM2"
#define SPH_ZPL_TAG_IFF_IMAGING_NONORM_CALIB			 	 "ZPL_INT_FLAT_FIELD_IMAGING_NONORM"
#define SPH_ZPL_TAG_IFF_IMAGING_NONORM_CALIB_CAM1		 	 "ZPL_INT_FLAT_FIELD_IMAGING_NONORM_CAM1"
#define SPH_ZPL_TAG_IFF_IMAGING_NONORM_CALIB_CAM2			 "ZPL_INT_FLAT_FIELD_IMAGING_NONORM_CAM2"

#define SPH_ZPL_TAG_POINT_PATTERN           	         		"ZPL_POINT_PATTERN"

#define SPH_ZPL_TAG_DISTORTION_MAP_IMAGING_RAW					"ZPL_DISTORTION_MAP_IMAGING_RAW"
#define SPH_ZPL_TAG_DISTORTION_MAP_IMAGING_PREPROC_RAW			"ZPL_DISTORTION_MAP_IMAGING_PREPROC_RAW"
#define SPH_ZPL_TAG_DISTORTION_MAP_IMAGING_CALIB               "ZPL_DISTORTION_MAP_IMAGING_CALIB"

#define SPH_ZPL_TAG_SCIENCE_IMAGING_RAW                     "ZPL_SCIENCE_IMAGING_RAW"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_RAW				"ZPL_SCIENCE_IMAGING_PREPROC_RAW"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM1			"ZPL_SCIENCE_IMAGING_PREPROC_CAM1"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM2			"ZPL_SCIENCE_IMAGING_PREPROC_CAM2"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_CALIB_CAM1 	         "ZPL_SCIENCE_IMAGING_REDUCED_CAM1"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_CALIB_CAM2 	         "ZPL_SCIENCE_IMAGING_REDUCED_CAM2"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_CALIB_TMP			 "ZPL_SCIENCE_IMAGING_CALIB_TMP"
#define SPH_ZPL_TAG_SCIENCE_IMAGING_CALIB                "ZPL_SCIENCE_IMAGING_REDUCED"

#define SPH_ZPL_TAG_BASIC_POL_RAW                     	"ZPL_BASIC_POL_RAW"
#define SPH_ZPL_TAG_BASIC_POL_PREPROC_RAW				"ZPL_BASIC_POL_PREPROC_RAW"
#define SPH_ZPL_TAG_BASIC_POL_CALIB             		"ZPL_BASIC_POL_CALIBRATED"

#define SPH_ZPL_TAG_BASIC_COLL_POL_RAW                     	"ZPL_BASIC_COLL_POL_RAW"
#define SPH_ZPL_TAG_BASIC_COLL_POL_PREPROC_RAW				"ZPL_BASIC_COLL_POL_PREPROC_RAW"
#define SPH_ZPL_TAG_BASIC_COLL_POL_CALIB             		"ZPL_BASIC_COLL_POL_REDUCED"
#define SPH_ZPL_TAG_BASIC_COLL_POL_PLUS_CALIB             	"ZPL_BASIC_COLL_POL_PLUS_REDUCED"
#define SPH_ZPL_TAG_BASIC_COLL_POL_MINUS_CALIB             	"ZPL_BASIC_COLL_POL_MINUS_REDUCED"

#define SPH_ZPL_TAG_BASIC_IMAGING_RAW                      "ZPL_IMAGING_RAW"
#define SPH_ZPL_TAG_BASIC_IMAGING_PREPROC_RAW				"ZPL_BASIC_IMAGING_PREPROC_RAW"
#define SPH_ZPL_TAG_BASIC_IMAGING_CALIB                    "ZPL_BASIC_IMAGING_CALIBRATED"

#define SPH_ZPL_TAG_BASIC_COLLAPSE_IMAGING_RAW                      "ZPL_IMAGING_RAW"
#define SPH_ZPL_TAG_BASIC_COLLAPSE_IMAGING_PREPROC_RAW				"ZPL_BASIC_COLLAPSE_IMAGING_PREPROC_RAW"
#define SPH_ZPL_TAG_BASIC_COLLAPSE_IMAGING_CALIB                    "ZPL_BASIC_COLLAPSE_IMAGING_REDUCED"

#define SPH_ZPL_TAG_IFF_RAW						 "ZPL_INT_FLAT_FIELD_RAW"
#define SPH_ZPL_TAG_IFF_PREPROC_RAW				 "ZPL_INT_FLAT_PREPROC"
#define SPH_ZPL_TAG_IFF_PREPROC_CAM1			 "ZPL_INT_FLAT_PREPROC_CAM1"
#define SPH_ZPL_TAG_IFF_PREPROC_CAM2			 "ZPL_INT_FLAT_PREPROC_CAM2"
#define SPH_ZPL_TAG_IFF_CALIB		   			 "ZPL_INT_FLAT_FIELD"
#define SPH_ZPL_TAG_IFF_CALIB_CAM1	   			 "ZPL_INT_FLAT_FIELD_CAM1"
#define SPH_ZPL_TAG_IFF_CALIB_CAM2	   			 "ZPL_INT_FLAT_FIELD_CAM2"
#define SPH_ZPL_TAG_IFF_NONORM_CALIB			 "ZPL_INT_FLAT_FIELD_NONORM"
#define SPH_ZPL_TAG_IFFM_NONORM_CALIB			 "ZPL_INT_FLAT_FIELD_NONORM_MASTER"
#define SPH_ZPL_TAG_IFF_NONORM_CALIB_CAM1		 "ZPL_INT_FLAT_FIELD_NONORM_CAM1"
#define SPH_ZPL_TAG_IFFM_NONORM_CALIB_CAM1		 "ZPL_INT_FLAT_FIELD_NONORM_MASTER_CAM1"
#define SPH_ZPL_TAG_IFF_NONORM_CALIB_CAM2		 "ZPL_INT_FLAT_FIELD_NONORM_CAM2"
#define SPH_ZPL_TAG_IFFM_NONORM_CALIB_CAM2		 "ZPL_INT_FLAT_FIELD_NONORM_MASTER_CAM2"
#define SPH_ZPL_TAG_IFFM_CALIB		   			 "ZPL_INT_FLAT_FIELD_MASTER"
#define SPH_ZPL_TAG_IFFM_CALIB_CAM1	   			 "ZPL_INT_FLAT_FIELD_MASTER_CAM1"
#define SPH_ZPL_TAG_IFFM_CALIB_CAM2	   			 "ZPL_INT_FLAT_FIELD_MASTER_CAM2"

#define SPH_ZPL_TAG_MODEM_EFF_RAW               	"ZPL_MODEM_EFF_RAW"
#define SPH_ZPL_TAG_MODEM_EFF_PREPROC_RAW       	"ZPL_MODEM_EFF_PREPROC_RAW"
#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_RAW				"ZPL_MODEM_EFF_QPLUS_RAW"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_RAW			"ZPL_MODEM_EFF_QMINUS_RAW"
#define SPH_ZPL_TAG_MODEM_EFF_PREPROC_CAM1		    "ZPL_MODEM_EFF_PREPROC_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_PREPROC_CAM2  		"ZPL_MODEM_EFF_PREPROC_CAM2"

#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_PREPROC_CAM1    "ZPL_MODEM_EFF_PREPROC_QPLUS_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_PREPROC_CAM1  	"ZPL_MODEM_EFF_PREPROC_QMINUS_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_PREPROC_CAM2    "ZPL_MODEM_EFF_PREPROC_QPLUS_CAM2"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_PREPROC_CAM2  	"ZPL_MODEM_EFF_PREPROC_QMINUS_CAM2"
#define SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM1            "ZPL_MODEM_EFF_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_CALIB_CAM1      "ZPL_MODEM_EFF_QPLUS_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_CALIB_CAM1     "ZPL_MODEM_EFF_QMINUS_CAM1"
#define SPH_ZPL_TAG_MODEM_EFF_CALIB_CAM2            "ZPL_MODEM_EFF_CAM2"
#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_CALIB_CAM2      "ZPL_MODEM_EFF_QPLUS_CAM2"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_CALIB_CAM2     "ZPL_MODEM_EFF_QMINUS_CAM2"
#define SPH_ZPL_TAG_MODEM_EFF_CALIB					"ZPL_MODEM_EFF"
#define SPH_ZPL_TAG_MODEM_EFF_QPLUS_CALIB			"ZPL_MODEM_EFF_QPLUS"
#define SPH_ZPL_TAG_MODEM_EFF_QMINUS_CALIB			"ZPL_MODEM_EFF_QMINUS"

#define SPH_ZPL_TAG_AOC_EFF_RAW               "ZPL_AOC_EFF_RAW"
#define SPH_ZPL_TAG_AOC_EFF_PREPROC_RAW       "ZPL_AOC_EFF_PREPROC_RAW"
#define SPH_ZPL_TAG_AOC_EFF_CALIB             "ZPL_AOC_EFF"
#define SPH_ZPL_TAG_AOC_EFF_PLUS_CALIB        "ZPL_AOC_EFF_PLUS"
#define SPH_ZPL_TAG_AOC_EFF_MINUS_CALIB       "ZPL_AOC_EFF_MINUS"
#define SPH_ZPL_TAG_AOC_EFF_QQ_CALIB          "ZPL_AOC_EFF_QQ"   //it is used in the science recipe C_QQ
#define SPH_ZPL_TAG_AOC_EFF_UU_CALIB          "ZPL_AOC_EFF_UU"   //it is used in the science recipe C_UU
#define SPH_ZPL_TAG_AOC_OFFSET_RAW               "ZPL_AOC_OFFSET_RAW"
#define SPH_ZPL_TAG_AOC_OFFSET_PREPROC_RAW       "ZPL_AOC_OFFSET_PREPROC_RAW"
#define SPH_ZPL_TAG_AOC_OFFSET_CALIB             "ZPL_AOC_OFFSET"
#define SPH_ZPL_TAG_AOC_OFFSET_PLUS_CALIB        "ZPL_AOC_OFFSET_PLUS"
#define SPH_ZPL_TAG_AOC_OFFSET_MINUS_CALIB       "ZPL_AOC_OFFSET_MINUS"
#define SPH_ZPL_TAG_AOC_OFFSET_IQ_CALIB          "ZPL_AOC_OFFSET_IQ"   //it is used only for monitoring
#define SPH_ZPL_TAG_AOC_OFFSET_IU_CALIB          "ZPL_AOC_OFFSET_IU"   //it is used only for monitoring
#define SPH_ZPL_TAG_AOC_CROSSTALK_RAW               "ZPL_AOC_CROSSTALK_RAW"
#define SPH_ZPL_TAG_AOC_CROSSTALK_PREPROC_RAW       "ZPL_AOC_CROSSTALK_PREPROC_RAW"
#define SPH_ZPL_TAG_AOC_CROSSTALK_CALIB             "ZPL_AOC_CROSSTALK"
#define SPH_ZPL_TAG_AOC_CROSSTALK_PLUS_CALIB        "ZPL_AOC_OFFSET_PLUS"
#define SPH_ZPL_TAG_AOC_CROSSTALK_MINUS_CALIB       "ZPL_AOC_OFFSET_MINUS"
#define SPH_ZPL_TAG_AOC_CROSSTALK_UQ_CALIB	         "ZPL_AOC_CROSSTALK_UQ"
#define SPH_ZPL_TAG_AOC_CROSSTALK_UV_CALIB       	 "ZPL_AOC_CROSSTALK_UV"
#define SPH_ZPL_TAG_AOC_CROSSTALK_QU_CALIB	         "ZPL_AOC_CROSSTALK_QU"
#define SPH_ZPL_TAG_AOC_CROSSTALK_QV_CALIB       	 "ZPL_AOC_CROSSTALK_QV"
#define SPH_ZPL_TAG_AOC_CROSSTALK_VQ_CALIB			 "ZPL_AOC_CROSSTALK_VQ" //it is used only for monitoring
#define SPH_ZPL_TAG_AOC_CROSSTALK_VU_CALIB       	 "ZPL_AOC_CROSSTALK_VU" //it is used only for monitoring

#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_RAW               "ZPL_ZIMPOL_CROSSTALK_RAW"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_PREPROC_RAW       "ZPL_ZIMPOL_CROSSTALK_PREPROC_RAW"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_CALIB             "ZPL_ZIMPOL_CROSSTALK"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_PLUS_CALIB        "ZPL_ZIMPOL_CROSSTALK_PLUS"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_MINUS_CALIB       "ZPL_ZIMPOL_CROSSTALK_MINUS"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_UQ_CALIB	        "ZPL_ZIMPOL_CROSSTALK_UQ"
#define SPH_ZPL_TAG_ZIMPOL_CROSSTALK_VQ_CALIB       	"ZPL_ZIMPOL_CROSSTALK_VQ"

#define SPH_ZPL_TAG_TELE_OFFSET_RAW               "ZPL_TELE_OFFSET_RAW"
#define SPH_ZPL_TAG_TELE_OFFSET_PREPROC_RAW       "ZPL_TELE_OFFSET_PREPROC_RAW"
#define SPH_ZPL_TAG_TELE_OFFSET_CALIB             "ZPL_TELE_OFFSET"
#define SPH_ZPL_TAG_TELE_OFFSET_IQ_CALIB          "ZPL_TELE_OFFSET_IQ"
#define SPH_ZPL_TAG_TELE_OFFSET_IU_CALIB          "ZPL_TELE_OFFSET_IU"

#define SPH_ZPL_TAG_TELE_CROSSTALK_RAW               "ZPL_TELE_CROSSTALK_RAW"
#define SPH_ZPL_TAG_TELE_CROSSTALK_PREPROC_RAW       "ZPL_TELE_CROSSTALK_PREPROC_RAW"
#define SPH_ZPL_TAG_TELE_CROSSTALK_CALIB             "ZPL_TELE_CROSSTALK"
#define SPH_ZPL_TAG_TELE_CROSSTALK_QU_CALIB			  "ZPL_TELE_CROSSTALK_QU"
#define SPH_ZPL_TAG_TELE_CROSSTALK_QV_CALIB			  "ZPL_TELE_CROSSTALK_QV"
#define SPH_ZPL_TAG_TELE_CROSSTALK_UQ_CALIB			  "ZPL_TELE_CROSSTALK_UQ"
#define SPH_ZPL_TAG_TELE_CROSSTALK_UV_CALIB			  "ZPL_TELE_CROSSTALK_UV"
#define SPH_ZPL_TAG_TELE_CROSSTALK_VQ_CALIB			  "ZPL_TELE_CROSSTALK_VQ"
#define SPH_ZPL_TAG_TELE_CROSSTALK_VU_CALIB			  "ZPL_TELE_CROSSTALK_VU"

#define SPH_ZPL_TAG_TELE_ZEROPOINT_RAW               "ZPL_TELE_ZEROPOINT_RAW"
#define SPH_ZPL_TAG_TELE_ZEROPOINT_PREPROC_RAW       "ZPL_TELE_ZEROPOINT_PREPROC_RAW"
#define SPH_ZPL_TAG_TELE_ZEROPOINT_CALIB             "ZPL_TELE_ZEROPOINT"
#define SPH_ZPL_TAG_TELE_ZEROPOINT_QQ_CALIB          "ZPL_TELE_ZEROPOINT_QQ"
#define SPH_ZPL_TAG_TELE_ZEROPOINT_UU_CALIB          "ZPL_TELE_ZEROPOINT_UU"

#define SPH_ZPL_TAG_SCIENCE_P2_RAW	  				"ZPL_SCIENCE_P2_RAW"
#define SPH_ZPL_TAG_SCIENCE_P2_PREPROC_RAW	"		ZPL_SCIENCE_P2_PREPROC_RAW"
#define SPH_ZPL_TAG_SCIENCE_P2_CALIB				"ZPL_SCIENCE_P2_REDUCED"

#define SPH_ZPL_TAG_FIELD_CENTER_CALIB				"ZPL_FIELD_CENTER_TABLE" //use for the asci table

#define SPH_ZPL_TAG_STAR_CENTER_IMG_RAW             "ZPL_STAR_CENTER_IMG_RAW"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_PREPROC_RAW     "ZPL_STAR_CENTER_IMG_PREPROC"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_PREPROC_CAM1    "ZPL_STAR_CENTER_IMG_PREPROC_CAM1"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_PREPROC_CAM2    "ZPL_STAR_CENTER_IMG_PREPROC_CAM2"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB           "ZPL_STAR_CENTER_IMG"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM1      "ZPL_STAR_CENTER_IMG_CAM1"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM2      "ZPL_STAR_CENTER_IMG_CAM2"
#define SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_TMP           "ZPL_STAR_CENTER_IMG_TMP"

#define SPH_ZPL_TAG_STAR_CENTER_POL_RAW             "ZPL_STAR_CENTER_POL_RAW"
#define SPH_ZPL_TAG_STAR_CENTER_POL_PREPROC_RAW     "ZPL_STAR_CENTER_POL_PREPROC"
#define SPH_ZPL_TAG_STAR_CENTER_POL_PREPROC_CAM1    "ZPL_STAR_CENTER_POL_PREPROC_CAM1"
#define SPH_ZPL_TAG_STAR_CENTER_POL_PREPROC_CAM2    "ZPL_STAR_CENTER_POL_PREPROC_CAM2"
#define SPH_ZPL_TAG_STAR_CENTER_POL_CALIB           "ZPL_STAR_CENTER_POL"
#define SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM1      "ZPL_STAR_CENTER_POL_CAM1"
#define SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_CAM2      "ZPL_STAR_CENTER_POL_CAM2"
#define SPH_ZPL_TAG_STAR_CENTER_POL_CALIB_TMP       "ZPL_STAR_CENTER_POL_TMP"


/* science p1 mode */
#define SPH_ZPL_TAG_SCIENCE_P1_RAW	  					"ZPL_SCIENCE_P1_RAW"
#define SPH_ZPL_TAG_SCIENCE_P1_PREPROC_RAW				"ZPL_SCIENCE_P1_PREPROC"
#define SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM1				"ZPL_SCIENCE_P1_PREPROC_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_PREPROC_CAM2				"ZPL_SCIENCE_P1_PREPROC_CAM2"

#define SPH_ZPL_TAG_SCIENCE_P1_Q_CALIB_CAM1				"ZPL_SCIENCE_P1_REDUCED_Q_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_QPLUS_CALIB_CAM1			"ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_QMINUS_CALIB_CAM1		"ZPL_SCIENCE_P1_REDUCED_QMINUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_U_CALIB_CAM1				"ZPL_SCIENCE_P1_REDUCED_U_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_UPLUS_CALIB_CAM1			"ZPL_SCIENCE_P1_REDUCED_UPLUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P1_UMINUS_CALIB_CAM1		"ZPL_SCIENCE_P1_REDUCED_UMINUS_CAM1"

#define SPH_ZPL_TAG_SCIENCE_P1_Q_CALIB_CAM2				"ZPL_SCIENCE_P1_REDUCED_Q_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P1_QPLUS_CALIB_CAM2			"ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P1_QMINUS_CALIB_CAM2		"ZPL_SCIENCE_P1_REDUCED_QMINUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P1_U_CALIB_CAM2				"ZPL_SCIENCE_P1_REDUCED_U_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P1_UPLUS_CALIB_CAM2			"ZPL_SCIENCE_P1_REDUCED_UPLUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P1_UMINUS_CALIB_CAM2		"ZPL_SCIENCE_P1_REDUCED_UMINUS_CAM2"

#define SPH_ZPL_TAG_SCIENCE_P1_Q_CALIB             "ZPL_SCIENCE_P1_REDUCED_Q"
#define SPH_ZPL_TAG_SCIENCE_P1_QPLUS_CALIB         "ZPL_SCIENCE_P1_REDUCED_QPLUS"
#define SPH_ZPL_TAG_SCIENCE_P1_QMINUS_CALIB        "ZPL_SCIENCE_P1_REDUCED_QMINUS"
#define SPH_ZPL_TAG_SCIENCE_P1_U_CALIB             "ZPL_SCIENCE_P1_REDUCED_U"
#define SPH_ZPL_TAG_SCIENCE_P1_UPLUS_CALIB         "ZPL_SCIENCE_P1_REDUCED_UPLUS"
#define SPH_ZPL_TAG_SCIENCE_P1_UMINUS_CALIB        "ZPL_SCIENCE_P1_REDUCED_UMINUS"


#define SPH_ZPL_TAG_SCIENCE_P1_CALIB					"ZPL_SCIENCE_P1_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P1_PLUS_CALIB				"ZPL_SCIENCE_P1_PLUS_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P1_MINUS_CALIB				"ZPL_SCIENCE_P1_MINUS_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P1_CALIB_TMP				"ZPL_SCIENCE_P1_CALIB_TMP"
#define SPH_ZPL_TAG_SCIENCE_P1_Q_RAW		  			"ZPL_SCIENCE_P1_Q_RAW"
#define SPH_ZPL_TAG_SCIENCE_P1_Q_PREPROC_RAW			"ZPL_SCIENCE_P1_Q_PREPROC_RAW"
//#define SPH_ZPL_TAG_SCIENCE_P1_Q_CALIB					"ZPL_SCIENCE_P1_Q_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P1_U_RAW	  				"ZPL_SCIENCE_P1_U_RAW"
#define SPH_ZPL_TAG_SCIENCE_P1_U_PREPROC_RAW			"ZPL_SCIENCE_P1_U_PREPROC_RAW"
//#define SPH_ZPL_TAG_SCIENCE_P1_U_CALIB					"ZPL_SCIENCE_P1_U_REDUCED"

#define SPH_ZPL_TAG_SCIENCE_XMATRIX_ELEMENTS			"ZPL_SCIENCE_XMATRIX_ELEMENTS"
#define SPH_ZPL_TAG_SCIENCE_Q_XMATRIX_ELEMENTS			"ZPL_SCIENCE_Q_XMATRIX_ELEMENTS"
#define SPH_ZPL_TAG_SCIENCE_U_XMATRIX_ELEMENTS			"ZPL_SCIENCE_U_XMATRIX_ELEMENTS"

/* science p23 modes */
#define SPH_ZPL_TAG_SCIENCE_P23_RAW	  						"ZPL_SCIENCE_P23_RAW"
#define SPH_ZPL_TAG_SCIENCE_P23_PREPROC_CAM1				"ZPL_SCIENCE_P23_PREPROC_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_PREPROC_CAM2                "ZPL_SCIENCE_P23_PREPROC_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_PREPROC_RAW                 "ZPL_SCIENCE_P23_PREPROC"
#define SPH_ZPL_TAG_SCIENCE_P23_Q_RAW	  					"ZPL_SCIENCE_P23_Q_RAW"
#define SPH_ZPL_TAG_SCIENCE_P23_Q_PREPROC_RAW				"ZPL_SCIENCE_P23_Q_PREPROC_RAW"
#define SPH_ZPL_TAG_SCIENCE_P23_Q_CALIB						"ZPL_SCIENCE_P23_Q_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P23_U_RAW	  					"ZPL_SCIENCE_P23_U_RAW"
#define SPH_ZPL_TAG_SCIENCE_P23_U_PREPROC_RAW				"ZPL_SCIENCE_P23_U_PREPROC_RAW"
#define SPH_ZPL_TAG_SCIENCE_P23_U_CALIB						"ZPL_SCIENCE_P23_U_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P23_Q_CALIB_CAM1				"ZPL_SCIENCE_P23_REDUCED_Q_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_QPLUS_CALIB_CAM1			"ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_QMINUS_CALIB_CAM1			"ZPL_SCIENCE_P23_REDUCED_QMINUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_U_CALIB_CAM1				"ZPL_SCIENCE_P23_REDUCED_U_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_UPLUS_CALIB_CAM1			"ZPL_SCIENCE_P23_REDUCED_UPLUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_UMINUS_CALIB_CAM1			"ZPL_SCIENCE_P23_REDUCED_UMINUS_CAM1"
#define SPH_ZPL_TAG_SCIENCE_P23_Q_CALIB_CAM2				"ZPL_SCIENCE_P23_REDUCED_Q_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_QPLUS_CALIB_CAM2			"ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_QMINUS_CALIB_CAM2			"ZPL_SCIENCE_P23_REDUCED_QMINUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_U_CALIB_CAM2				"ZPL_SCIENCE_P23_REDUCED_U_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_UPLUS_CALIB_CAM2			"ZPL_SCIENCE_P23_REDUCED_UPLUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_UMINUS_CALIB_CAM2			"ZPL_SCIENCE_P23_REDUCED_UMINUS_CAM2"
#define SPH_ZPL_TAG_SCIENCE_P23_CALIB						"ZPL_SCIENCE_P23_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P23_PLUS_CALIB					"ZPL_SCIENCE_P23_PLUS_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P23_MINUS_CALIB					"ZPL_SCIENCE_P23_MINUS_REDUCED"
#define SPH_ZPL_TAG_SCIENCE_P23_CALIB_TMP					"ZPL_SCIENCE_P23_CALIB_TMP"

#define SPH_ZPL_TAG_DISPERSION_MODEL_CALIB       "ZPL_DISPERSION_MODEL"

#define SPH_ZPL_TAG_CALIB_LINES_TABLE_CALIB      "ZPL_CALIBRATION_LINES TABLE"

#define SPH_ZPL_TAG_FILTER_TABLE_CALIB "ZPL_FILTER_TABLE"


#define SPH_ZPL_MASTER_DARK_TAG_VALID_SETTINGS   "ZPL_MASTER_DARK_SETTINGS"
#define SPH_ZPL_MASTER_BIAS_TAG_VALID_SETTINGS   "ZPL_MASTER_BIAS_SETTINGS"

#define SPH_ZPL_TAG_HOTPIXELMAP_CALIB		      			"ZPL_HOTPIXELMAP"
#define SPH_ZPL_TAG_STATIC_BADPIXELMAP_CALIB     			"ZPL_STATIC_BADPIXELMAP"
#define SPH_ZPL_TAG_STATIC_BADPIXELMAP_IMAGING_CALIB     	"ZPL_STATIC_BADPIXELMAP_IMAGING"
#define SPH_ZPL_TAG_STATIC_BADPIXELMAP_IMAGING_CALIB_CAM1  	"ZPL_STATIC_BADPIXELMAP_IMAGING_CAM1"
#define SPH_ZPL_TAG_STATIC_BADPIXELMAP_IMAGING_CALIB_CAM2  	"ZPL_STATIC_BADPIXELMAP_IMAGING_CAM2"

#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_CALIB 			"ZPL_NON_LINEAR_BADPIXELMAP"
#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_CALIB_CAM1 		"ZPL_NON_LINEAR_BADPIXELMAP_CAM1"
#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_CALIB_CAM2 		"ZPL_NON_LINEAR_BADPIXELMAP_CAM2"
#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_IMAGING_CALIB 	"ZPL_NON_LINEAR_BADPIXELMAP_IMAGING"
#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_IMAGING_CALIB_CAM1 	"ZPL_NON_LINEAR_BADPIXELMAP_IMAGING_CAM1"
#define SPH_ZPL_TAG_NON_LINEAR_BADPIXELMAP_IMAGING_CALIB_CAM2 	"ZPL_NON_LINEAR_BADPIXELMAP_IMAGING_CAM2"

#define SPH_ZPL_INTENSITY_FLAT_TAG_VALID_SETTINGS		"ZPL_MASTER_IFF_SETTINGS"
#define SPH_ZPL_SPECTRA_POSITIONS_TAG_VALID_SETTINGS   "ZPL_SPECTRA_POSITIONS_SETTINGS"
#define SPH_ZPL_WAVE_CALIB_TAG_VALID_SETTINGS   "ZPL_WAVE_CALIB_SETTINGS"

#define SPH_ZPL_TAG_PHOT_TABLE_CALIB   "ZPL_PHOT_STAR_TABLE"

#define SPH_ZPL_TAG_POL_HIGH_CATG   "ZPL_POLHIGH_STAR_TABLE"

#define SPH_ZPL_TAG_POL_CORRECTIONS_TABLE_CALIB "ZPL_POL_CORRECT_TABLE"
#endif /* SPH_ZPL_TAGS_H_ */
