/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * sph_crosstalkco.h
 *
 *  Created on: 26 Sep 2015
 *      Author: ole
 */
#include "sph_raw_image_corrector_data.h"

#ifndef SPHERP_SRC_SPHERE_SPH_CROSSTALKCO_H_
#define SPHERP_SRC_SPHERE_SPH_CROSSTALKCO_H_

cpl_error_code
sph_crosstalkco_apply_to_raw_cube(
		cpl_frameset* allframes,
		cpl_frame* raw_cube_frame,
		cpl_size sepmax,
		double bfac,
		double powfac,
		cpl_size lg_scale_corr_window,
		double threshold,
		double smoothing_fwhm,
		double stephist);

cpl_error_code
sph_crosstalkco_correct_image_in_place(sph_raw_image_corrector_data* data,cpl_image** image);

#endif /* SPHERP_SRC_SPHERE_SPH_CROSSTALKCO_H_ */
