/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#ifndef sph_cube_H_
#define sph_cube_H_

#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_quad_image.h"
#include "sph_pixel_description_table.h"
#include "sph_pixel_descriptor.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_framelist.h"

/*-----------------------------------------------------------------------------
 Type definition
 -----------------------------------------------------------------------------*/
enum _sph_interpol_alg_ {
    SPH_INTERPOL_ALG_NONE             = 0,
    SPH_INTERPOL_ALG_LINEAR           = 1,
    SPH_INTERPOL_ALG_QUADRATIC        = 2
};
typedef enum _sph_interpol_alg_ sph_interpol_alg;

enum sph_cube_ext {
    SPH_CUBE_IMAGE_EXT               = 0,
    SPH_CUBE_BADPIX_EXT              = 1,
    SPH_CUBE_RMSMAP_EXT              = 2,
    SPH_CUBE_NCOMBMAP_EXT            = 3,
    SPH_CUBE_IMAGE2_EXT               = 4,
    SPH_CUBE_BADPIX2_EXT              = 5,
    SPH_CUBE_RMSMAP2_EXT              = 6,
    SPH_CUBE_NCOMBMAP2_EXT            = 7
};

enum _sph_cube_fitmode_ {
    SPH_CUBE_FITMODE_NORMAL             = 0,
    SPH_CUBE_FITMODE_MEAN               = 1,
    SPH_CUBE_FITMODE_MEAN_EXTERNAL      = 2
};

typedef enum _sph_cube_fitmode_ sph_cube_fitmode;
typedef struct _sph_cube_
{
    cpl_imagelist       *   imlist;
    cpl_table           *   assoc_table;
    cpl_type                type;
    sph_interpol_alg        interpol_alg;
    cpl_propertylist    *   proplist;
    char          *   filename;
    short int               file_exists;
    short int               nx;
    short int               ny;
    const cpl_frameset*     dfs_allframes;
    const cpl_frame*        dfs_template_frame;
    const cpl_parameterlist* dfs_paramlist;
    char*                   dfs_tag;
    char*                   dfs_pipename;
    char*                   dfs_recipe;
} sph_cube;

/*-----------------------------------------------------------------------------
 Function prototypes
 -----------------------------------------------------------------------------*/

sph_cube* sph_cube_new(const char* filename)
    CPL_ATTR_ALLOC;


sph_error_code sph_cube_append_master(sph_cube* self,
                                      const sph_master_frame* mframe,
                                      float zvalue);
sph_error_code sph_cube_append_double_image(sph_cube* self,
                                            const sph_double_image* dimage,
                                            float zvalue );

sph_cube* sph_cube_new_dfs(const char* filename,
                           const cpl_frameset* allframes,
                           const cpl_frame* template_frame,
                           const cpl_parameterlist* params,
                           const char* tag,
                           const char* recipe,
                           const char* pipename,
                           const cpl_propertylist* plist)
    CPL_ATTR_ALLOC;

sph_error_code
sph_cube_append_image(const char* fname,
                      const cpl_image* image,
                      const cpl_propertylist* pl,
                      int extend);
sph_error_code
sph_cube_finalise_all(const cpl_frameset* frameset);
sph_error_code
sph_cube_finalise_file(const char* fname);
void sph_cube_delete(sph_cube* self);

#endif /*sph_cube_H_*/
