/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_ERROR_H_
#define SPH_ERROR_H_

#include <cpl_error.h>
#include <stdio.h>

#define SPH_IRD_INVALID_DOUBLE -99.0

#define SPH_ERROR_MAX_MESSAGES 100000
#define SPH_FITS_ERR_START (CPL_ERROR_EOL + 100)
#define SPH_PDT_ERR_START (CPL_ERROR_EOL + 300)
#define SPH_SPECTRUM_ERR_START (CPL_ERROR_EOL + 400)
#define SPH_MASTER_FRAME_ERR_START (CPL_ERROR_EOL + 500)
#define SPH_FRAMELIST_ERR_START (CPL_ERROR_EOL + 600)
#define SPH_UTILS_ERR_START (CPL_ERROR_EOL + 700)
#define SPH_CUBE_ERR_START (CPL_ERROR_EOL + 800)
#define SPH_SMART_IMAGELIST_ERR_START (CPL_ERROR_EOL + 1000)
#define SPH_IFS_MASTER_DARK_ERR_START (CPL_ERROR_EOL + 1100)
#define SPH_IFS_MASTER_DETECTOR_FLAT_ERR_START (CPL_ERROR_EOL + 1200)
#define SPH_PIXEL_POLYFIT_TABLE_ERR_START (CPL_ERROR_EOL + 1300)
#define SPH_IRD_MASTER_DARK_ERR_START (CPL_ERROR_EOL + 1400)
#define SPH_IRD_INSTRUMENT_FLAT_ERR_START (CPL_ERROR_EOL + 1400)
#define SPH_IFS_INSTRUMENT_FLAT_ERR_START (CPL_ERROR_EOL + 1500)
#define SPH_IFS_SPECTRA_POSITIONS_ERR_START (CPL_ERROR_EOL + 1600)
#define SPH_IRD_SCIENCE_IMAGING_ERR_START (CPL_ERROR_EOL + 1700)
#define SPH_IRD_SCIENCE_DBI_ERR_START (CPL_ERROR_EOL + 1800)
#define SPH_DATASET_ERR_START (CPL_ERROR_EOL + 1900)
#define SPH_ZPL_MASTER_BIAS_ERR_START (CPL_ERROR_EOL + 2000)
#define SPH_DATASET_STATS_ERR_START (CPL_ERROR_EOL + 2100)
#define SPH_IFS_WAVE_CALIB_ERR_START (CPL_ERROR_EOL + 2200)
#define SPH_ZPL_MASTER_DARK_ERR_START (CPL_ERROR_EOL + 2300)
#define SPH_KEYWORD_ENGINE_START (CPL_ERROR_EOL + 2400)
#define SPH_LDT_ERR_START (CPL_ERROR_EOL + 2500)
#define SPH_KEYWORD_MANAGER_ERR_START (CPL_ERROR_EOL + 2600)
#define SPH_KEYWORDNODE_START (CPL_ERROR_EOL + 2700)
#define SPH_KEYSORT_DATAMANAGER_ERR_START  (CPL_ERROR_EOL + 2800)
#define SPH_DOUBLE_IMAGE_ERR_START  (CPL_ERROR_EOL + 2900)
#define SPH_IFS_SCIENCE_DR_ERR_START (CPL_ERROR_EOL + 3000)
#define SPH_IFS_LENSLET_MODEL_ERR_START (CPL_ERROR_EOL + 3100)
#define SPH_ZPL_INTENSITY_FLAT_ERR_START  (CPL_ERROR_EOL + 3200)
#define SPH_ZPL_POLARIZATION_FLAT_ERR_START (CPL_ERROR_EOL + 3300)
#define SPH_ZPL_MODEM_EFFICIENCY_ERR_START (CPL_ERROR_EOL + 3400)
#define SPH_IRD_INSTRUMENT_MODEL_ERR_START (CPL_ERROR_EOL + 3500)
#define SPH_QUAD_IMAGE_ERR_START (CPL_ERROR_EOL + 3600)
#define SPH_IFS_RON_ERR_START (CPL_ERROR_EOL + 3700)
#define SPH_IFS_GAIN_ERR_START (CPL_ERROR_EOL + 3800)
#define SPH_IFS_DETECTOR_PERSISTENCE_ERR_START (CPL_ERROR_EOL + 3900)
#define SPH_IRD_RON_ERR_START (CPL_ERROR_EOL + 4000)
#define SPH_IRD_GAIN_ERR_START (CPL_ERROR_EOL + 4100)
#define SPH_IRD_DETECTOR_PERSISTENCE_ERR_START (CPL_ERROR_EOL + 4200)
#define SPH_IRD_DISTORTION_MAP_ERR_START (CPL_ERROR_EOL + 4300)
#define SPH_IFS_DISTORTION_MAP_ERR_START (CPL_ERROR_EOL + 4400)
#define SPH_IFS_CAL_BACKGROUND_ERR_START (CPL_ERROR_EOL + 4500)
#define SPH_IRD_WAVE_CALIB_ERR_START (CPL_ERROR_EOL + 4600)
#define SPH_IRD_SPECTRA_RESOLUTION_ERR_START (CPL_ERROR_EOL + 4700)
#define SPH_IRD_SCIENCE_SPECTROSCOPY_ERR_START (CPL_ERROR_EOL + 4800)
#define SPH_IRD_TFF_ERR_START (CPL_ERROR_EOL + 4900)
#define SPH_IRD_PSF_REFERENCE_ERR_START (CPL_ERROR_EOL + 5000)
#define SPH_IRD_SKY_BG_ERR_START (CPL_ERROR_EOL + 5100)
#define SPH_IRD_INS_THROUGHPUT_ERR_START (CPL_ERROR_EOL + 5200)
#define SPH_FRAMECOMBINATION_ERR_START (CPL_ERROR_EOL + 5300)
#define SPH_IRD_STAR_CENTER_ERR_START (CPL_ERROR_EOL + 5400)
#define SPH_IRD_ATMOSPHERIC_ERR_START (CPL_ERROR_EOL + 5500)
#define SPH_IFS_DITHERING_EFFECTS_ERR_START (CPL_ERROR_EOL + 5600)
#define SPH_IFS_PSF_REFERENCE_ERR_START (CPL_ERROR_EOL + 5700)
#define SPH_IRD_SCIENCE_DPI_ERR_START (CPL_ERROR_EOL + 5800)
#define SPH_IRD_INS_POL_ERR_START (CPL_ERROR_EOL + 5900)
#define SPH_IRD_INS_POL_EFF_ERR_START (CPL_ERROR_EOL + 5900)
#define SPH_IRD_POL_ZPA_EFF_ERR_START (CPL_ERROR_EOL + 6000)
#define SPH_ZPL_PREPROC_ERR_START (CPL_ERROR_EOL + 6100)
#define SPH_IRD_ASTROMETRY_ERR_START (CPL_ERROR_EOL + 6200)
#define SPH_IFS_FLUX_CALIB_ERR_START (CPL_ERROR_EOL + 6300)
#define SPH_IFS_STD_PHOT_ERR_START (CPL_ERROR_EOL + 6400)
#define SPH_IFS_SKY_FLAT_ERR_START (CPL_ERROR_EOL + 6500)
#define SPH_IFS_SKY_CAL_ERR_START (CPL_ERROR_EOL + 6600)
#define SPH_IFS_ATMOSPHERIC_ERR_START (CPL_ERROR_EOL + 6700)
#define SPH_IFS_ASTROMETRY_ERR_START (CPL_ERROR_EOL + 6800)
#define SPH_IRD_TEL_POL_OFFSET_ERR_START (CPL_ERROR_EOL + 6900)
#define SPH_TRIPLE_IMAGE_ERR_START (CPL_ERROR_EOL + 7000)
#define SPH_IRD_ANDROMEDA_ERR_START (CPL_ERROR_EOL + 7100)
#define SPH_ZPL_MASTER_BIAS_IMAGING_ERR_START (CPL_ERROR_EOL + 7200)
#define SPH_ZPL_MASTER_DARK_IMAGING_ERR_START (CPL_ERROR_EOL + 7300)
#define SPH_ZPL_INTENSITY_FLAT_IMAGING_ERR_START  (CPL_ERROR_EOL + 7400)
#define SPH_ZPL_BASIC_POLARIZATION_ERR_START  (CPL_ERROR_EOL + 7500)
#define SPH_ZPL_BASIC_COLLAPSE_POLARIZATION_ERR_START  (CPL_ERROR_EOL + 7600)
#define SPH_ZPL_BASIC_IMAGING_ERR_START  (CPL_ERROR_EOL + 7700)
#define SPH_ZPL_BASIC_COLLAPSE_IMAGING_ERR_START  (CPL_ERROR_EOL + 7800)
#define SPH_ZPL_PREPROC_IMAGING_ERR_START (CPL_ERROR_EOL + 7900)
#define SPH_ZPL_ZIMPOL_CROSSTALK_ERR_START	(CPL_ERROR_EOL + 8000)
#define SPH_ZPL_AOC_EFFICIENCY_ERR_START	(CPL_ERROR_EOL + 8100)
#define SPH_ZPL_AOC_OFFSET_ERR_START		(CPL_ERROR_EOL + 8200)
#define SPH_ZPL_AOC_CROSSTALK_ERR_START		(CPL_ERROR_EOL + 8300)
#define SPH_IRD_LOCI_ERR_START     (CPL_ERROR_EOL + 8400)
#define SPH_ZPL_SCIENCE_P1_ERR_START        (CPL_ERROR_EOL + 8500)
#define SPH_IFS_SPEC_DECONV_ERR_START        (CPL_ERROR_EOL + 8600)
#define SPH_ZPL_SCIENCE_IMAGING_ERR_START    (CPL_ERROR_EOL + 8700)
#define SPH_ZPL_DISTORTION_MAP_IMAGING_ERR_START (CPL_ERROR_EOL + 8800)
#define SPH_IFS_XTALK_CORRECTION_ERR_START (CPL_ERROR_EOL + 8900)
#define SPH_IRD_XTALK_CORRECTION_ERR_START (CPL_ERROR_EOL + 9000)
#define SPH_IFS_SIMPLE_ADI_ERR_START (CPL_ERROR_EOL + 10000)
#define SPH_FRAMEGROUPS_ERR_START (CPL_ERROR_EOL + 10100)
#define SPH_ZPL_SCIENCE_P23_ERR_START (CPL_ERROR_EOL + 10200)
#define SPH_IRD_INS_BG_ERR_START (CPL_ERROR_EOL + 10300)
#define SPH_IFS_STAR_CENTER_ERR_START (CPL_ERROR_EOL + 10400)
#define SPH_ZPL_STAR_CENTER_IMG_ERR_START (CPL_ERROR_EOL + 10500)
#define SPH_ZPL_STAR_CENTER_POL_ERR_START (CPL_ERROR_EOL + 10600)

typedef struct _sph_error_ {
    char**  messages;
    int*    errlevels;
    int     nerrs;
    short   outcpl;
    short reset;
} sph_error;

typedef int sph_error_code;

extern const int SPH_ERROR_INFO ;
extern const int SPH_ERROR_WARNING;
extern const int SPH_ERROR_ERROR;

extern sph_error_code SPH_ERROR_GENERAL ;
extern sph_error_code SPH_ERROR_CPL_ERROR ;
extern sph_error_code SPH_ERROR_MEMORY_FAIL;
extern sph_error_code SPH_ERROR_INCONSISTENT_INPUT;
extern sph_error_code SPH_ERROR_PREVIOUS_OP_FAILED ;
extern sph_error_code SPH_ERROR_INFO_MESSAGE;

sph_error* sph_error_new(void);

int sph_error_dump_last(int severity);

int sph_error_get_last_code(void);

int sph_error_get_size(void);

int sph_error_dump(int severity);

int sph_error_abort(int severity);

//int sph_error_raise( int code, const char* file, const char* func,
//                     int line, int severity, const char* message, ...);
int sph_error_raise( int code, const char* file, const char* func,
                     int line, int severity, const char* message, ...) __attribute__((format(printf, 6, 7)));


int sph_error_delete(void);
int sph_error_format( const char* message, char** out );
int sph_error_reset(void);
void sph_error_set_reportlevel( int lvl );
void sph_error_unset_last(void);

#define SPH_NO_SELF sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "No pointer to self.");
#define SPH_INFO_MSG(msg) sph_error_raise( SPH_ERROR_GENERAL, __FILE__, __func__, __LINE__, SPH_ERROR_INFO, msg);
#define SPH_ERR(msg) sph_error_raise( SPH_ERROR_GENERAL, __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, msg);
#define SPH_WARNING(msg) sph_error_raise (SPH_ERROR_GENERAL, __FILE__, __func__, __LINE__, SPH_ERROR_WARNING, msg);
#define SPH_NULL_ERROR sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "Null input pointer.");
#define SPH_RAISE_CPL sph_error_raise( cpl_error_get_code(), __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "%s", cpl_error_get_message() );
#define SPH_RAISE_CPL_GOTO_EXIT { sph_error_raise( cpl_error_get_code(), __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "%s", cpl_error_get_message() );goto EXIT;}
#define SPH_ERROR_ENSURE_GOTO_EXIT(boolexpr,errcode) { if ( !(boolexpr) ) { sph_error_raise( errcode, __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "%s", cpl_error_get_message() );goto EXIT;} }
#define SPH_ENSURE_GOTO_EXIT(boolexpr,errcode) { if ( !(boolexpr) ) { cpl_error_set(__func__,errcode); goto EXIT;} }
#define SPH_RAISE_CPL_RESET sph_error_raise( cpl_error_get_code(), __FILE__, __func__, __LINE__, SPH_ERROR_ERROR, "%s", cpl_error_get_message() );cpl_error_reset();
#define SPH_ERROR_CHECK_STATE_ONERR_RETURN_ERRCODE if ( cpl_error_get_code() != CPL_ERROR_NONE ) { SPH_RAISE_CPL; return cpl_error_get_code(); }
#define SPH_ERROR_CHECK_STATE_ONERR_RETURN_NULL if ( cpl_error_get_code() != CPL_ERROR_NONE ) { SPH_RAISE_CPL; return NULL; }
#define SPH_ERROR_CHECK_STATE_ONERR_GOTO_EXIT if ( cpl_error_get_code() != CPL_ERROR_NONE ) { SPH_RAISE_CPL; goto EXIT; }
#define SPH_ERROR_CHECK_STATE_RETURN_ERRCODE { SPH_RAISE_CPL; return cpl_error_get_code(); }
#define SPH_ERROR_CHECK_STATE_RETURN_NULL { SPH_RAISE_CPL; return NULL; }
#define SPH_ERROR_RAISE_ERR(code,...) sph_error_raise(code , __FILE__, __func__, __LINE__, SPH_ERROR_ERROR,__VA_ARGS__ );
#define SPH_ERROR_RAISE_ERR_GOTO_EXIT(code,...) { sph_error_raise(code , __FILE__, __func__, __LINE__, SPH_ERROR_ERROR,__VA_ARGS__ );goto EXIT;}
#define SPH_ERROR_RAISE_INFO(code,...) sph_error_raise(code , __FILE__, __func__, __LINE__, SPH_ERROR_INFO, __VA_ARGS__ );
#define SPH_ERROR_RAISE_WARNING(code,...) sph_error_raise(code , __FILE__, __func__, __LINE__, SPH_ERROR_WARNING, __VA_ARGS__ );
#ifdef DEBUG
#define SPH_ERROR_RAISE_DBG_INFO(code,...) sph_error_raise(code , __FILE__, __func__, __LINE__, SPH_ERROR_INFO, __VA_ARGS__ );
#else
#define SPH_ERROR_RAISE_DBG_INFO(code,...) if ( 1 ) { }
#endif
#endif /*SPH_ERROR_H_*/
