/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FILTER_TABLE_H_
#define SPH_FILTER_TABLE_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include <cpl.h>

typedef struct _sph_filter_table_ {
    char**     filterNames;
    int       nfilters;
    cpl_vector*     left_lambda;
    cpl_vector*     right_lambda;
} sph_filter_table;


/*----------------------------------------------------------------------------
                            Function prototypes
 ----------------------------------------------------------------------------*/

sph_filter_table*  sph_filter_table_new(void) CPL_ATTR_ALLOC;
int sph_filter_table_get_size(const sph_filter_table* self);
#ifdef SPH_TABLE_ASCII
sph_filter_table*
sph_filter_table_load_ascii(const char* filename) CPL_ATTR_ALLOC;
#endif
sph_filter_table*
sph_filter_table_load_fits(const char* filename) CPL_ATTR_ALLOC;
sph_error_code
sph_filter_table_add_row(sph_filter_table* self,
        const char* filter_name,
        double left_lambda, double right_lambda);
cpl_vector*
sph_filter_table_get_left_lambdas(sph_filter_table* self);
cpl_vector*
sph_filter_table_get_right_lambdas(sph_filter_table* self);

cpl_error_code
sph_filter_table_get_left_right_lambda(const sph_filter_table* self,
                                       const char* filtername,
                                       double* pleft, double* pright);

#ifdef SPH_TABLE_ASCII
sph_error_code
sph_filter_table_save_ascii( const sph_filter_table* self, const char* filename );
#endif
void sph_filter_table_delete(sph_filter_table* self);

#endif /* SPH_filter_table_H_ */
