/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IRD_INSTRUMENT_MODEL_H_
#define SPH_IRD_INSTRUMENT_MODEL_H_
#include <cpl.h>
#include "sph_error.h"
#include "sph_master_frame.h"

extern const double SPH_IRD_INSTRUMENT_MODEL_DEROT_OFFSETELEV;
extern const double SPH_IRD_INSTRUMENT_MODEL_DEROT_OFFSETSKY;

extern const double SPH_IRD_INSTRUMENT_MODEL_PIX_SIZE_MICRONS;
extern const double SPH_IRD_INSTRUMENT_MODEL_DET_SIZE_PIX_X         ;
extern const double SPH_IRD_INSTRUMENT_MODEL_DET_SIZE_PIX_Y         ;
extern const double SPH_IRD_INSTRUMENT_MODEL_DET_SIZE_MICRONS    ;
extern const int SPH_IRD_INSTRUMENT_MODEL_SPLIT_PIXEL_X;
extern const int SPH_IRD_INSTRUMENT_MODEL_ZERO_WINDOW_START_Y;
extern const int SPH_IRD_INSTRUMENT_MODEL_WINDOW_SIZE_Y;



extern const char* SPH_IRD_INSTRUMENT_MODEL_SECNAME;
extern const char* SPH_IRD_INSTRUMENT_MODEL_PIX_SIZE_NAME			;
extern const char* SPH_IRD_INSTRUMENT_MODEL_DET_SIZE_X_NAME           ;
extern const char* SPH_IRD_INSTRUMENT_MODEL_DET_SIZE_Y_NAME           ;
extern const char* SPH_IRD_INSTRUMENT_MODEL_SPLIT_PIXEL_X_NAME;
extern const char* SPH_IRD_INSTRUMENT_MODEL_ZERO_WINDOW_START_Y_NAME;
extern const char* SPH_IRD_INSTRUMENT_MODEL_WINDOW_SIZE_Y_NAME;
extern const sph_error_code SPH_IRD_INSTRUMENT_MODEL_OUTSIDE_ARRAY;

typedef struct _sph_ird_instrument_model_ {
    int         detsize_pixels_x;         /* Size of detector in pixels */
    int         detsize_pixels_y;         /* Size of detector in pixels */
	double		pixsize_microns;        /* Size of pixel in microns */
	double		detsize_microns;        /* (Full) detector size in microns */
	double		minlambda;
	double		maxlambda;
	int			speclength;
	int			specwidth;
	double		zero_offsetx;
	double		zero_offsety;

	int         window_mode;            /* Special mode for small windows */
    int         window_mode_bl;            /* Special mode for small windows */
    int         window_mode_tr;            /* Special mode for small windows */

	int			split_pixel_x;			/* The pixel in x where left and right are split*/
	int			zero_window_start_y;	/* The pixel in y where the windows start */
	int			window_size_y;			/* The window height in pixels */
} sph_ird_instrument_model;


sph_ird_instrument_model* sph_ird_instrument_model_new(void) CPL_ATTR_ALLOC;
sph_ird_instrument_model* sph_ird_instrument_model_new_small(void)
    CPL_ATTR_ALLOC;
sph_ird_instrument_model*
sph_ird_instrument_model_new_from_propertylist( const cpl_propertylist* plist )
    CPL_ATTR_ALLOC;

sph_ird_instrument_model* sph_ird_instrument_model_load( const char* czFilename )
    CPL_ATTR_ALLOC;

sph_error_code sph_ird_instrument_model_save( const sph_ird_instrument_model* self,
                                              const char* czFilename );

cpl_propertylist* sph_ird_instrument_model_get_as_propertylist( sph_ird_instrument_model* self )
    CPL_ATTR_ALLOC;
cpl_mask*
sph_ird_instrument_model_get_mask_dbi_fov( sph_ird_instrument_model* self, double border )
    CPL_ATTR_ALLOC;

int sph_ird_instrument_model_check_in_dbi_fov(const sph_ird_instrument_model*,
                                              int, int, int, double);
sph_master_frame*
sph_ird_instrument_model_extract_right_master_frame( const sph_ird_instrument_model* self, 
                                                     const sph_master_frame* mframe )
    CPL_ATTR_ALLOC;
int sph_ird_instrument_model_pixel_inside_left(sph_ird_instrument_model* self,int xx,int yy);
int sph_ird_instrument_model_pixel_inside_right(sph_ird_instrument_model* self,int xx,int yy);
sph_master_frame*
sph_ird_instrument_model_extract_left_master_frame( const sph_ird_instrument_model* self,
                                                    const sph_master_frame* mframe )
    CPL_ATTR_ALLOC;

void sph_ird_instrument_model_delete( sph_ird_instrument_model* self );
cpl_mask*
sph_ird_instrument_model_extract_left_mask(
        sph_ird_instrument_model* self, cpl_mask* mask ) CPL_ATTR_ALLOC;
cpl_mask*
sph_ird_instrument_model_extract_right_mask(
        sph_ird_instrument_model* self, cpl_mask* mask ) CPL_ATTR_ALLOC;
sph_error_code
sph_ird_instrument_model_get_centre_right(
        const sph_ird_instrument_model* self,
        double* x,
        double* y);
sph_error_code
sph_ird_instrument_model_get_centre_left(
        const sph_ird_instrument_model* self,
        double* x,
        double* y);
sph_error_code
sph_ird_instrument_model_get_centre_left_subframe_coords(
        const sph_ird_instrument_model* self,
        double* x,
        double* y);
sph_error_code
sph_ird_instrument_model_get_centre_right_subframe_coords(
        const sph_ird_instrument_model* self,
        double* x,
        double* y);
sph_master_frame*
sph_ird_instrument_model_assemble(
        sph_ird_instrument_model* self,
        sph_master_frame* left,
        sph_master_frame* right) CPL_ATTR_ALLOC;

cpl_image*
sph_ird_instrument_model_assemble_image(
        sph_ird_instrument_model* self,
        cpl_image* left,
        cpl_image* right) CPL_ATTR_ALLOC;

sph_error_code
sph_ird_instrument_model_set_windows(
        sph_ird_instrument_model* self,
        int         window_size);

sph_error_code
sph_ird_instrument_model_adjust_centre_coords(
        sph_ird_instrument_model* self,
        double cxin,
        double cyin,
        double* cxout,
        double* cyout);

sph_error_code
sph_ird_instrument_model_adjust_centre_coords_v(
        sph_ird_instrument_model* self,
        cpl_vector* cxin,
        cpl_vector* cyin,
        cpl_vector** cxout,
        cpl_vector** cyout);

sph_error_code
sph_ird_instrument_model_crop_to_window(
        const sph_ird_instrument_model* self,
        sph_master_frame* result);

cpl_mask*
sph_ird_instrument_model_get_mask_leftwin(
        const sph_ird_instrument_model* self ) CPL_ATTR_ALLOC;
cpl_mask*
sph_ird_instrument_model_get_mask_rightwin(
        const sph_ird_instrument_model* self ) CPL_ATTR_ALLOC;
cpl_image*
sph_ird_instrument_model_extract_left_image( sph_ird_instrument_model* self, cpl_image* inim )
    CPL_ATTR_ALLOC;
cpl_image*
sph_ird_instrument_model_extract_right_image( sph_ird_instrument_model* self, cpl_image* inim )
    CPL_ATTR_ALLOC;

void sph_ird_instrument_raw_add_qc_counts(cpl_propertylist* self,
                                          const cpl_frameset* rawframes,
                                          const cpl_mask* left_mask,
                                          const cpl_mask* right_mask,
                                          cpl_boolean do_extra);
#endif /* SPH_IRD_INSTRUMENT_FLAT_H_ */
