/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_LOCI_SUBSECTION_H_
#define SPH_LOCI_SUBSECTION_H_


typedef struct _sph_loci_subsection_ {
    int     bb_ll_x;
    int     bb_ur_x;
    int     bb_ll_y;
    int     bb_ur_y;
    double  cx;
    double  cy;
    float  sub_minr;
    float  sub_maxr;
    float  sub_mintheta;
    float  sub_maxtheta;
    float  opt_minr;
    float  opt_maxr;
    float  opt_mintheta;
    float  opt_maxtheta;
    cpl_imagelist*  imlist;
    cpl_imagelist*  badlist;
    cpl_mask*  submask;
    cpl_mask*  optmask;
} sph_loci_subsection;


sph_loci_subsection*
sph_loci_subsection_new(void);

sph_error_code
sph_loci_subsection_load(
        sph_loci_subsection* self,
        cpl_frameset* frameset );

int
sph_loci_subsection_test_inside_subtract_region(sph_loci_subsection* self, int xx, int yy);

int
sph_loci_subsection_test_inside_opt_region(sph_loci_subsection* self, int xx, int yy);

cpl_image*
sph_loci_subsection_get_subtract_mask_image( sph_loci_subsection* self );

cpl_mask*
sph_loci_subsection_get_subtract_mask( sph_loci_subsection* self );

cpl_image*
sph_loci_subsection_get_subtract_image( sph_loci_subsection* self,int imid);

cpl_image*
sph_loci_subsection_get_opt_mask_image( sph_loci_subsection* self );

cpl_mask*
sph_loci_subsection_get_opt_mask( sph_loci_subsection* self );

cpl_image*
sph_loci_subsection_get_opt_image( sph_loci_subsection* self,int imid);

sph_error_code
sph_loci_subsection_calculate_subtract_mask(sph_loci_subsection* self );

sph_error_code
sph_loci_subsection_calculate_opt_mask(sph_loci_subsection* self );

sph_error_code
sph_loci_subsection_clear( sph_loci_subsection* self );

void sph_loci_subsection_delete( sph_loci_subsection* self );

#endif /* SPH_LOCI_SUBSECTION_H_ */
