/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


#ifndef SPH_OVERLAP_CALCULATOR_H_
#define SPH_OVERLAP_CALCULATOR_H_
#include <cpl.h>
#include "sph_polygon.h"

typedef struct _sph_overlap_calculator_
{
	cpl_image*			im;
	double				minx;
	double				maxx;
	double				miny;
	double				maxy;
	double				dx;
	double				dy;
    sph_polygon*        poly;
    sph_polygon*        stat_poly;
    int                 resolution;
} sph_overlap_calculator;

sph_error_code
sph_overlap_calculator_init(
        sph_overlap_calculator* self,
        sph_polygon* poly,
        double border);

sph_overlap_calculator*
sph_overlap_calculator_new(
		sph_polygon* poly,
		double border,
		int res);
sph_error_code
sph_overlap_calculator_precalc( sph_overlap_calculator* self );
double
sph_overlap_calculator_get_overlap(
		sph_overlap_calculator* self,
		double offset_x, double offset_y );

void
sph_overlap_calculator_delete( sph_overlap_calculator* self );

#endif /* SPH_OVERLAP_CALCULATOR_H_ */
