/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_POINT_PATTERN_H_
#define SPH_POINT_PATTERN_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "sph_point.h"

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct sph_point_pattern_ sph_point_pattern;

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_point_pattern* sph_point_pattern_new(void) CPL_ATTR_ALLOC;

sph_point_pattern* sph_point_pattern_new_(size_t) CPL_ATTR_ALLOC;

sph_point_pattern* sph_point_pattern_duplicate(const sph_point_pattern*)
    CPL_ATTR_ALLOC;

sph_point_pattern* sph_point_pattern_new_from_table(const cpl_frame*,
                                                    int) CPL_ATTR_ALLOC;

int sph_point_pattern_get_size(const sph_point_pattern*) CPL_ATTR_PURE;

double sph_point_pattern_get_x(const sph_point_pattern*,
                               cpl_size) CPL_ATTR_PURE CPL_ATTR_NONNULL;

double sph_point_pattern_get_y(const sph_point_pattern*,
                               cpl_size) CPL_ATTR_PURE CPL_ATTR_NONNULL;

const double* sph_point_pattern_get(const sph_point_pattern*,
                                    cpl_size) CPL_ATTR_PURE CPL_ATTR_NONNULL;

cpl_error_code sph_point_pattern_add(sph_point_pattern*,
                                     const sph_point_pattern*);

cpl_error_code sph_point_pattern_add_point(sph_point_pattern*,
                                           double,
                                           double);

sph_point_pattern* sph_point_pattern_new_from_image(
        const cpl_image* image,
        const cpl_image* errim,
        double sigma,
        double point_width_estimate,
        double boxfactor,
        double boxborder,
        cpl_size refsz,
        double * pfwhm) CPL_ATTR_ALLOC;

sph_error_code
sph_point_pattern_make_pairs( const sph_point_pattern* self,
		cpl_vector** ppairs_a, cpl_vector** ppairs_b,
		cpl_vector** pdistances,
		cpl_vector** pdotprods);

sph_error_code
sph_point_pattern_rotate(
        sph_point_pattern* self,
        double cx, double cy,
        double angle );
sph_error_code
sph_point_pattern_scale_around(
        sph_point_pattern* self,
        double cx, double cy,
        double scale );

sph_point_pattern*
sph_point_pattern_find_square( const sph_point_pattern* self ) CPL_ATTR_ALLOC;

sph_error_code
sph_point_pattern_centralise( sph_point_pattern* self );

double
sph_point_pattern_score_square( const sph_point_pattern* self,
		const int* p);

sph_error_code
sph_point_pattern_get_centre(const sph_point_pattern* self,
                             double* x, double* y );

sph_point* sph_point_pattern_get_point(const sph_point_pattern*, int)
    CPL_ATTR_ALLOC;

cpl_size sph_point_pattern_find_closest(const sph_point_pattern*,
                                        const double[2]);

cpl_image* sph_point_pattern_create_image( sph_point_pattern* self,
                                           int nx, int ny, double pointsize )
    CPL_ATTR_ALLOC;

double
sph_point_pattern_dotprod( const sph_point_pattern* self, int pA, int pB, int pC);

int
sph_point_pattern_find_closest_neighbour( sph_point_pattern* self, int n, double* pdist );
sph_error_code
sph_point_pattern_save( sph_point_pattern* self, const char* filename );
void sph_point_pattern_delete( sph_point_pattern* self );

int
sph_point_pattern_get_central_point(const sph_point_pattern* self,
                                    double* px, double* py);
sph_error_code
sph_point_pattern_add_offset( sph_point_pattern* self, double x0, double y0 );
sph_error_code
sph_point_pattern_centralise_wrt_central_point( sph_point_pattern* self );
sph_error_code
sph_point_pattern_save_dfs(
        sph_point_pattern* self,
        const char* outfilename,
        cpl_frameset* allframes,
        cpl_frame* template_frame,
        cpl_parameterlist* params,
        const char* tag,
        const char* recipe,
        const char* pipename,
        cpl_propertylist* plist );

sph_point_pattern*
sph_point_pattern_load_ascii(const char* filename);

sph_error_code
sph_point_pattern_save_ascii(
        sph_point_pattern* self,
        const char* filename );

cpl_error_code sph_point_pattern_draw_save(const sph_point_pattern*,
                                           const cpl_image*,
                                           const sph_point_pattern*,
                                           const cpl_image*,
                                           const sph_point_pattern*,
                                           const cpl_image*,
                                           double, double,
                                           const cpl_image*,
                                           double, double,
                                           double,
                                           const char*);

void sph_point_pattern_sort(sph_point_pattern*);

#endif /* SPH_POINT_PATTERN_H_ */
