/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_QUAD_IMAGE_H_
#define SPH_QUAD_IMAGE_H_
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_zpl_exposure.h"
#include "sph_error.h"

typedef struct _sph_quad_image_
{
	sph_double_image* 		zero_image;
	sph_double_image*		pi_image;
	cpl_propertylist*		properties;
	cpl_propertylist*		qclist;
} sph_quad_image;

/*-----------------------------------------------------------------------------
 Function prototypes
 -----------------------------------------------------------------------------*/
sph_quad_image* sph_quad_image_new( int nx, int ny )
    CPL_ATTR_ALLOC;
sph_quad_image* sph_quad_image_new_empty( void )
    CPL_ATTR_ALLOC;
sph_quad_image*
sph_quad_image_new_from_double_images( sph_double_image* di_zero,
                                       sph_double_image* di_pi)
    CPL_ATTR_ALLOC;
sph_quad_image*
sph_quad_image_new_from_zpl_exposures( const sph_zpl_exposure* zplexp )
    CPL_ATTR_ALLOC;
sph_quad_image*
sph_quad_image_new_from_master_frames( sph_master_frame* mf_zero_odd,
                                       sph_master_frame* mf_zero_even,
                                       sph_master_frame* mf_pi_odd,
                                       sph_master_frame* mf_pi_even)
    CPL_ATTR_ALLOC;
sph_double_image*
sph_quad_image_getcopy_zero_double_image ( const sph_quad_image* self )
    CPL_ATTR_ALLOC;
sph_double_image* sph_quad_image_get_zero_double_image ( sph_quad_image* self );
sph_double_image* sph_quad_image_getcopy_pi_double_image (sph_quad_image* self )
    CPL_ATTR_ALLOC;
sph_double_image* sph_quad_image_get_pi_double_image (sph_quad_image* self );

sph_quad_image* sph_quad_image_duplicate ( const sph_quad_image* self )
    CPL_ATTR_ALLOC;

sph_error_code	sph_quad_image_add_quad_image( sph_quad_image* self,
                                               const sph_quad_image* qiframe );
sph_error_code	sph_quad_image_subtract_quad_image( sph_quad_image* self,
                                                    const sph_quad_image* qiframe );
sph_error_code	sph_quad_image_multiply_double( sph_quad_image* self, double value );
sph_error_code	sph_quad_image_divide_quad_image( sph_quad_image* self,
                                                  const sph_quad_image* qimage);

sph_error_code
sph_quad_image_divide_master_frame( sph_quad_image* self,
                                    const sph_master_frame* mframe);

sph_error_code	sph_quad_image_divide_double( sph_quad_image* self, double value );

cpl_error_code sph_quad_image_quality_check( sph_quad_image* self );
cpl_error_code sph_quad_image_mask_sigma( sph_quad_image* self, double sigma);

sph_error_code
sph_quad_image_save( const sph_quad_image* self,
                     const char* czFilename,
                     const cpl_propertylist* pli );

sph_error_code
sph_quad_image_save_dfs(const sph_quad_image* self,
                        const char* outfilename,
                        cpl_frameset* allframes,
                        const cpl_frame* template_frame,
                        const cpl_parameterlist* params,
                        const char* tag,
                        const char* recipe,
                        const char* pipename,
                        const cpl_propertylist* plist);


sph_quad_image* sph_quad_image_load( const char* czFilename, int plane )
    CPL_ATTR_ALLOC;

void sph_quad_image_delete( sph_quad_image* self );

cpl_frameset*
sph_quad_image_create_quad_image_frameset_from_zplexp_frameset( const cpl_frameset* inframes )
    CPL_ATTR_ALLOC;

cpl_frameset*
sph_quad_image_create_quad_image_frameset_from_zplexp_cubes( const cpl_frameset* inframes )
    CPL_ATTR_ALLOC;

#endif /* SPH_QUAD_IMAGE_H_ */
