/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TEST_IFS_INSTRUMENT_MODEL_H_
#define SPH_TEST_IFS_INSTRUMENT_MODEL_H_
#include <cpl.h>
#include "sph_ifs_lenslet_model.h"
#include "sph_master_frame.h"
#include "sph_overlap_calculator.h"

typedef struct _sph_test_ifs_instrument_model_ {
    int pureflag;
    int prism_id;
    double dither_x;
    double dither_y;
    cpl_vector* filter_lambdas;
    cpl_vector* filter_transmission;
    cpl_vector* nd_filter_lambdas;
    cpl_vector* nd_filter_attenuation;
    sph_ifs_lenslet_model* lensmodel;
    cpl_vector* flatvals;
} sph_test_ifs_instrument_model;

sph_test_ifs_instrument_model*
sph_test_ifs_instrument_model_new_from_lenslet_model(
        sph_ifs_lenslet_model* model);

sph_test_ifs_instrument_model*
sph_test_ifs_instrument_model_new(int detector_pix_size,
        double lens_size_microns, int lenslets_per_side);

int
sph_test_ifs_instrument_model_get_nlens(sph_test_ifs_instrument_model* self);

sph_polygon*
sph_test_ifs_instrument_model_get_lenslet_hexagon(
        sph_test_ifs_instrument_model* self, int u, int v);

void
sph_test_ifs_instrument_model_delete(sph_test_ifs_instrument_model* self);

cpl_propertylist*
sph_test_ifs_instrument_model_get_proplist(sph_test_ifs_instrument_model* self);

cpl_image*
sph_test_ifs_instrument_model_disperse(sph_test_ifs_instrument_model* self,
        cpl_image* inim, double dx, double dy);

double
sph_test_ifs_instrument_model_get_flux_in_hexagon(
        sph_test_ifs_instrument_model* self, int uu, int vv,
        sph_overlap_calculator* oc, cpl_image* image);

sph_error_code
sph_test_ifs_instrument_model_set_flat_value(
        sph_test_ifs_instrument_model* self, int uu, int vv, double value);

double
sph_test_ifs_instrument_model_get_flat_value(
        sph_test_ifs_instrument_model* self, int uu, int vv);

sph_polygon*
sph_test_ifs_instrument_model_get_spec_region(
        sph_test_ifs_instrument_model* self, int uu, int vv);

#endif /* SPH_TEST_IFS_INSTRUMENT_MODEL_H_ */
