/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TEST_NGC_SIMULATOR_CCD_H_
#define SPH_TEST_NGC_SIMULATOR_CCD_H_

#include "sph_error.h"
#include <cpl.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

enum _sph_test_rom_ccd_ {
    SPH_TEST_NGC_ROM_CCD_SINGLE = 0, SPH_TEST_NGC_ROM_CCD_DC = 1
};

typedef enum _sph_test_rom_ccd_ sph_test_rom_ccd;

typedef enum _sph_test_ngc_ccd_simulator_modes_ {
    SPH_TEST_NGC_SIMULATOR_CCD_MODES_CONSTVALUE = 0,
} sph_test_ngc_ccd_simulator_modes;

typedef struct _sph_test_ngc_ccd_simulator_ {
    short poisson; //flag to set if poisson randomizing
    short add_ron_noise; // flag to set if add ron
    gsl_rng* pRNG;
    int det_size_x; // entire detector size in x
    int det_size_y; // entire detector size in y
    int adu1_nx;
    int adu1_ny;
    int adu2_nx;
    int adu2_ny;
    int adu1_ovrsx;
    int adu1_ovrsy;
    int adu1_presx;
    int adu1_presy;
    int adu2_ovrsx;
    int adu2_ovrsy;
    int adu2_presx;
    int adu2_presy;
    int timedelay;
    double mean_bias; // mean value for bias
    double sigma_bias;
    double mean_dark;
    double sigma_dark;
    sph_test_rom_ccd rom; // the readout mode;
    double ron; // the read out noise
    int ndead; // number of dead single pixels
    int nhot; // number of hot single pixels
    int ncrazy; // number of crazy single pixels
    double det_linear_factor; // the linear response factor
                              // (outsignal = factor * insignal )
    double det_qaudratic_factor; // the quadratic response factor
                                 // (outsignal = factor * insignal^2 )
    double lambda_ramp_linear; // the increase in out/in per wavelength
                               // with wavelength measured in mu
    double lambda_ramp_quadratic; // the increase in out/in per wavelength
                                  // with wavelength measured in mu
    short singlecube; // controls if frames are read into sinlge cube
    short dont_reset; // if set to yes, do not reset pixels
                      // between exposures
    cpl_vector* ditherpattern_x;
    cpl_vector* ditherpattern_y;
    cpl_image* flatim; // the detector flat
} sph_test_ngc_ccd_simulator;

sph_test_ngc_ccd_simulator*
sph_test_ngc_ccd_simulator_new(void);
cpl_image*
sph_test_ngc_ccd_simulator_create_detector_flat_image(
        sph_test_ngc_ccd_simulator* self);

cpl_image*
sph_test_ngc_ccd_simulator_create_dark_image(sph_test_ngc_ccd_simulator* self,
        int ndit, double exptime);

void sph_test_ngc_ccd_simulator_set_standard_ditherpattern(
        sph_test_ngc_ccd_simulator* self, int ndithers);

cpl_image*
sph_test_ngc_ccd_simulator_create_bias_image(sph_test_ngc_ccd_simulator* self,
        int ndit, double exptime);
cpl_frameset*
sph_test_ngc_ccd_simulator_create_raw_frameset_many(
        sph_test_ngc_ccd_simulator* self, cpl_frameset* inframes,
        double exptime, const char* base_filename, cpl_propertylist* pl,
        const char* tag);
cpl_frameset*
sph_test_ngc_ccd_simulator_create_raw_frameset(sph_test_ngc_ccd_simulator* self,
        cpl_frame* inframeA, cpl_frame* inframeB, double exptime,
        const char* base_filename, cpl_propertylist* pl, const char* tag,
        int ndit);

void sph_test_ngc_ccd_simulator_set_detector_size(
        sph_test_ngc_ccd_simulator* self, int nx, int ny);
void sph_test_ngc_ccd_simulator_set_bias(sph_test_ngc_ccd_simulator* self,
        double mean, double sigma);
void sph_test_ngc_ccd_simulator_set_dark(sph_test_ngc_ccd_simulator* self,
        double mean, double sigma);
void sph_test_ngc_ccd_simulator_set_readout_mode(
        sph_test_ngc_ccd_simulator* self, sph_test_rom_ccd mode);
void sph_test_ngc_ccd_simulator_set_readout_noise(
        sph_test_ngc_ccd_simulator* self, double ron);
void sph_test_ngc_ccd_simulator_set_num_deadpixels(
        sph_test_ngc_ccd_simulator* self, int n);
void sph_test_ngc_ccd_simulator_set_num_hotpixels(
        sph_test_ngc_ccd_simulator* self, int n);
void sph_test_ngc_ccd_simulator_set_num_crazypixels(
        sph_test_ngc_ccd_simulator* self, int n);
void sph_test_ngc_ccd_simulator_set_flat_linear_coeff(
        sph_test_ngc_ccd_simulator* self, double c);
void sph_test_ngc_ccd_simulator_set_flat_quadratic_coeff(
        sph_test_ngc_ccd_simulator* self, double c);
void sph_test_ngc_ccd_simulator_set_dont_reset(sph_test_ngc_ccd_simulator* self,
        int yesorno);
void sph_test_ngc_ccd_simulator_set_save_singlecube(
        sph_test_ngc_ccd_simulator* self, int yesorno);
void sph_test_ngc_ccd_simulator_set_add_noise(sph_test_ngc_ccd_simulator* self,
        int addnoise, int addpoisson);
void sph_test_ngc_ccd_simulator_set_dff_gradient(
        sph_test_ngc_ccd_simulator* self, double min, double max);
void sph_test_ngc_ccd_simulator_set_prescans(sph_test_ngc_ccd_simulator* self,
        int adu1_presx, int adu1_presy, int adu2_presx, int adu2_presy);
void sph_test_ngc_ccd_simulator_set_overscans(sph_test_ngc_ccd_simulator* self,
        int adu1_ovrsx, int adu1_ovrsy, int adu2_ovrsx, int adu2_ovrsy);
sph_error_code
sph_test_ngc_ccd_simulator_apply_mask(sph_test_ngc_ccd_simulator* self,
        cpl_image* inim);

void
sph_test_ngc_ccd_simulator_delete(sph_test_ngc_ccd_simulator* self);

#endif /* SPH_TEST_NGC_SIMULATOR_CCD_H_ */
