/* $Id: $
 *
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/


#include "sph_framelist.h"
#include "sph_common_keywords.h"
#include "sph_error.h"
#include "sph_test.h"
#include "sph_utils.h"
#include <cpl.h>

#include <math.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup techcal_master_test  Unit test of techcal_master recipe and 
 *                                  associated functions.               
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/
static
int cutest_init_framelist_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/

    sph_test_nop_code();
    return 0;

}

static
int cutest_clean_framelist_testsuite(void) {
    sph_error_dump(SPH_ERROR_ERROR);
    return sph_end_test();
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_new function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_new(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_create function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_create(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_create_cpl_image function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_create_cpl_image(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_create_from_dit function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_create_from_dit(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_create_from_mean function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_create_from_mean(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framelist_delete function. 
 */
/*----------------------------------------------------------------------------*/
static
void cutest_framelist_delete(void) {
    sph_test_later( "Not yet implemented!");
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of techcal_master_dark recipe and associated functions
 */
/*----------------------------------------------------------------------------*/
int main(void) {

    int result = 0;
    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("framelist_test", cutest_init_framelist_testsuite,
            cutest_clean_framelist_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite, "sph_framelist_new", cutest_framelist_new)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite, "sph_framelist_create_cpl_image",
                    cutest_framelist_create_cpl_image)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite, "sph_framelist_create",
                    cutest_framelist_create)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite, "sph_framelist_create_from_dit",
                    cutest_framelist_create_from_dit)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite, "sph_framelist_create_from_mean",
                    cutest_framelist_create_from_mean)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite, "sph_framelist_delete",
                    cutest_framelist_delete)) {
        return sph_test_get_error();
    }

    /* Run all tests using the CUnit Basic interface */
    sph_test_nop_int( 0);
    sph_test_nop_char("results.txt");
    result = sph_test_end();
    return result;
}

/**@}*/
