/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include "sph_test.h"
#include "sph_utils.h"
#include "sph_test_ngc_ir_simulator.h"
#include "sph_test_pupilimage_creator.h"
#include "sph_test_image_tools.h"
#include "sph_xtalk.h"
#include "sph_time.h"

#include <math.h>

#ifdef SPH_TEST_XTALK
static
void cutest_sph_xtalk_create_array_consistency(void);
static
void cutest_sph_xtalk_create_array(void);
static
void cutest_sph_xtalk_subtract_xtalk(void);
#endif
static
int cutest_sph_xtalk_init_testsuite(void);
static
int cutest_sph_xtalk_clean_testsuite(void);
static
void cutest_sph_xtalk_apply(void);
/*----------------------------------------------------------------------------*/
/**
 * @defgroup A CUnit Test Suite -- representing a collection of testcases
 * @par Synopsis:
 * @code
 * @endcode
 * @par Desciption:
 *
 * This module provides a collection of tests for one specific, distinct
 * module or set-up. The testing code is implemented using the CUnit
 * framework.
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test MAIN function
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("A cutest_sph_xtalk testsuite",
            cutest_sph_xtalk_init_testsuite, cutest_sph_xtalk_clean_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite, "Test apply xtalk", cutest_sph_xtalk_apply)) {
        return sph_test_get_error();
    }

    return sph_test_end();
}

static
void cutest_sph_xtalk_apply(void) {
    cpl_image* im = NULL;
    cpl_image* result = NULL;
    sph_xtalk* xtalk = NULL;
    double t = 0.0;

    sph_time_start_timer(0);
    im = sph_test_image_tools_create_flat_image_double(2048, 2048, 0.0);
    sph_test_image_tools_add_noise(im, 5.0, NULL);
    xtalk = sph_xtalk_new(32);
    cpl_test_eq(xtalk->npreamps, 32);
    cpl_test_nonnull( xtalk->coeffs );
    cpl_image_multiply_scalar(xtalk->coeffs, 0.0);

    result = sph_xtalk_apply(xtalk, im);
    t = sph_time_stop_timer(0);
    SPH_ERROR_RAISE_INFO(SPH_ERROR_GENERAL, "Time taken: %f", t);
    cpl_test_nonnull( result );
    cpl_image_delete(im);
    cpl_image_delete(result);
    sph_xtalk_delete(xtalk);
    return;
}
/*----------------------------------------------------------------------------*/
/*-                            INTERNAL HELPER FUNCTIONS                          */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 @brief    Function to initiailise the unit test suite
 */
/*----------------------------------------------------------------------------*/
static
int cutest_sph_xtalk_init_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/
    return sph_test_nop_code();
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Function to clean the unit test suite
 */
/*----------------------------------------------------------------------------*/
static
int cutest_sph_xtalk_clean_testsuite(void) {
    return sph_end_test();
}
/**@}*/
