from . import sphere_keywords as kwd
from .sphere_rules import (
    is_sphere, is_technical, is_test, is_calib, is_science
)

# grouping keywords
grpkwd_ird_dark = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.tpl_start
]
grpkwd_ird_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name,
    kwd.tpl_start
]
grpkwd_ird_flat = [
    kwd.dpr_tech,
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.det_read_curname,
    kwd.tpl_start
]
grpkwd_ird_lss_sci_wcal = [
    kwd.dpr_type,
    kwd.ins_comb_iflt,
    kwd.det_read_curname,
    kwd.tpl_start
]
grpkwd_ird_distortion = [
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name,
    kwd.ins4_opti10_name,
    kwd.tpl_start
]
grpkwd_ird_science_ctr = [
    kwd.dpr_type,
    kwd.arcfile
]
grpkwd_ird_img_science_obj_flx = [
    kwd.dpr_type,
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.det_read_curname,
    kwd.tpl_start
]
grpkwd_ird_pol_science_obj = [
    kwd.dpr_type,
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.det_read_curname,
    kwd.tpl_start
]

# setup keywords
setupkwd_ird_dark = [
    kwd.det_read_curname,
    kwd.det_ndit,
    kwd.det_seq1_dit
]
setupkwd_ird_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name
]
setupkwd_ird_flat = [
    kwd.dpr_tech,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name,
    kwd.ins4_opti10_name,
    kwd.det_read_curname
]
setupkwd_ird_distortion = [
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name,
    kwd.ins4_opti10_name
]
setupkwd_ird_img_science = [
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.det_read_curname
]
setupkwd_ird_pol_science_obj = [
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.det_read_curname
]
setupkwd_ird_lss_sci_wcal = [
    kwd.ins_comb_iflt,
    kwd.det_read_curname
]

# match keywords
matchkwd_ird_dark = [
    kwd.det_read_curname,
    kwd.det_seq1_dit
]
matchkwd_ird_ins_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name
]
matchkwd_ird_sky_bg = [
    kwd.obs_start,
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_filt2_name
]
matchkwd_ird_flat = [
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_opti8_name,
    kwd.det_read_curname
]

matchkwd_ird_img_science_flx_ctr = [
    kwd.obs_start,
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name
]
matchkwd_ird_pol_science_obj = [
    kwd.ins1_filt_name,
    kwd.ins1_opti1_name,
    kwd.ins1_opti2_name,
    kwd.obs_start
]
matchkwd_ird_img_std_phot = [
    kwd.ins1_filt_name,
    kwd.ins1_opti2_name,
    kwd.ins4_drot2_mode,
    kwd.aos_irloop_state,
    kwd.det_read_curname
]
matchkwd_ird_lss_wcal = [
    kwd.ins_comb_iflt
]


def is_irdis(f):
    return is_sphere and f[kwd.seq_arm] == "IRDIS"


def is_ird_technical(f):
    return is_technical(f) and is_irdis(f)


def is_ird_test(f):
    return is_test(f) and is_irdis(f)


def is_ird_acq(f):
    return is_irdis(f) and f[kwd.dpr_catg] == "ACQUISITION"


def is_ird_acq_object(f):
    return is_ird_acq(f) and f[kwd.dpr_type] == "OBJECT"


def is_ird_acq_dark(f):
    return is_ird_acq(f) and f[kwd.dpr_type] == "DARK"


def is_ird_acq_flat(f):
    return is_ird_acq(f) and f[kwd.dpr_type] == "FLAT,LAMP"


def is_ird_img_mode(f):
    return is_irdis and f[kwd.dpr_tech] in ["IMAGE,CLASSICAL", "IMAGE,DUAL", "IMAGE,CLASSICAL,CORONOGRAPHY",
                                            "IMAGE,DUAL,CORONOGRAPHY", "IMAGE,CLASSICAL,SAM", "IMAGE,DUAL,SAM"]


def is_ird_img_calib(f):
    return is_ird_img_mode(f) and is_calib(f)


def is_ird_pol_mode(f):
    return is_irdis and f[kwd.dpr_tech] in ["POLARIMETRY", "POLARIMETRY,CORONOGRAPHY", "POLARIMETRY,SAM"]


def is_ird_pol_calib(f):
    return is_ird_pol_mode(f) and is_calib(f)


def is_ird_lss_mode(f):
    return is_irdis and f[kwd.dpr_tech] in ["SPECTRUM", "SPECTRUM,CORONOGRAPHY"]


def is_ird_lss_calib(f):
    return is_irdis(f) and is_ird_lss_mode(f) and is_calib(f)


# classification rules for IMAGING
def is_ird_dark(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_type] == "DARK"


# INS1.FILT.NAME allows to distinguish between LSS (SPECTRUM) and IMAGE data when matching
def is_ird_ins_bg(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_type] == "DARK,BACKGROUND"


def is_ird_sky_bg(f):
    return is_irdis(f) and f[kwd.dpr_type] == "SKY"


# INS1.FILT.NAME allows to distinguish between LSS (SPECTRUM) and IMAGE data when matching
def is_ird_flat(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins1_opti1_name] == "OPEN" and \
        "POLARIMETRY" not in f[kwd.dpr_tech]


def is_ird_flat_pol_qc1(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and \
        f[kwd.ins1_opti1_name] == "OPEN" and f[kwd.ins4_opti8_name] == "H_NIR" and \
        "POLARIMETRY" in f[kwd.dpr_tech]


def is_ird_flat_pol_other(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and \
        f[kwd.ins1_opti1_name] == "OPEN" and f[kwd.ins4_opti8_name] != "H_NIR" and \
        "POLARIMETRY" in f[kwd.dpr_tech]


def is_ird_flat_rongain(f):
    return is_ird_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP,RONGAIN"


def is_ird_distortion(f):
    return is_irdis(f) and f[kwd.dpr_type] == "LAMP,DISTORT"


def is_ird_img_standard_flux(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] == "IMAGE,CLASSICAL" and f[kwd.dpr_type] == "STD,FLUX"


def is_ird_img_standard_flux_noprocess(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] in ["IMAGE,DUAL", "IMAGE,CLASSICAL,SAM",
                                                               "IMAGE,DUAL,SAM"] and f[kwd.dpr_type] == "STD,FLUX"


def is_ird_img_standard_astrometry(f):
    return is_irdis(f) and f[kwd.dpr_tech] in ["IMAGE", "IMAGE,DUAL"] and is_calib(f) and f[
        kwd.dpr_type] == "OBJECT,ASTROMETRY"


def is_ird_img_coronagraph_center(f):
    return is_science(f) and (is_ird_img_mode(f) or is_ird_pol_mode(f)) and \
        f[kwd.dpr_type] == "OBJECT,CENTER"  # and f["ocs.waffle.amp"] > 0


# covers OBJECT,CENTER for imaging and polarimetry as they use same recipe


def is_ird_science_flux_img(f):
    return is_ird_img_mode(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT,FLUX"


def is_ird_science_img(f):
    return is_ird_img_mode(f) and is_science(f) and f[kwd.dpr_type] in ["OBJECT"]


def is_ird_science_pol(f):
    return is_ird_pol_mode(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT"


def is_ird_science_flux_pol(f):
    return is_ird_pol_mode(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT,FLUX"


def is_ird_science_lss(f):
    return is_ird_lss_mode(f) and is_science(f) and f[kwd.dpr_type] != "SKY"


def is_ird_wavecal_lss(f):
    return is_ird_lss_mode(f) and is_calib(f) and f[kwd.dpr_type] == "LAMP,WAVE"


def is_ird_ncpa_unknown(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] == "IMAGE,PUPIL" \
        and f[kwd.dpr_type] in ["BACKGROUND,NCPA", "LAMP,NCPA"]


def is_ird_polarimetry_unknown(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] == "POLARIMETRY" \
        and f[kwd.dpr_type] in ["OBJECT", "STD,INSTRUMENT", "LAMP,EFFICIENCY"]


def is_ird_psfcalibrator_unknown(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] == "IMAGE" and f[kwd.dpr_type] in \
        ["BACKGROUND,PSF-CALIBRATOR", "LAMP,PSF-CALIBRATOR", "PSF-CALIBRATOR,BACKGROUND", "PSF-CALIBRATOR,LAMP"]


def is_ird_unknown(f):
    return is_irdis(f) and is_calib(f) and f[kwd.dpr_tech] == "TBD" and f[kwd.dpr_type] == "LAMP"


# Matching rules

# def is_assoc_lamp_mos(ref, f):
#    return match(ref, f, matchkwd["SPEC"] + ["ins.slit1.name"] + [kwd.tpl_start])

# ################  Association rules   ######################################################################
# ##  -  first, e.g.  ref=trigger (e.g. science)                                                           ###
# ##  -  second, e.g.  f=file to associate (e.g. calibration)                                              ###
# ############################################################################################################

def assoc_ird_distortion(ref, f):
    return (f[kwd.ins1_filt_name] == ref[kwd.ins1_filt_name]
            and f[kwd.ins1_opti1_name] == "OPEN" and f[kwd.ins1_opti2_name] == "CLEAR")


def assoc_ird_distortion_polarimetry(ref, f):
    return (f[kwd.ins1_filt_name] == ref[kwd.ins1_filt_name]
            and f[kwd.ins1_opti1_name] == "OPEN" and f[kwd.ins1_opti2_name] == "P0-90")
