from edps import ReportInput, task, FilterMode, qc1calib, calchecker

from .ifs_datasources import *
from .ifs_subwkf import (
    process_ifs_dark_background, process_ifs_standard, process_ifs_science, process_det_flat
)
from .sphere_task_functions import (
    which_disperser, is_YJH
)

"""
# Naming conventions
- Classification rules for raw frames start with `cls_`
- Classification rules for products have the same name as the PRO.CATG
- DataSources start with `raw_`
- Tasks start with `task_`
"""
__title__ = "SPHERE IFS workflow"

# ---  Processing Tasks  ----------------------------------#

# imaging cascade

# all
task_ifs_dark, task_ifs_ins_bg, task_ifs_sky_bg, task_ifs_static_bpm = process_ifs_dark_background()

# all
task_ifs_det_flat_nb1, task_ifs_det_flat_nb2, task_ifs_det_flat_nb3, task_ifs_det_flat_nb4, task_ifs_det_flat_bb = \
    process_det_flat(task_ifs_static_bpm)
# Determine the illuminated regions of the individual spectra in the IFU data (needed for all further processing)
task_ifs_specpos = (task("ifs_spectra_positions")
                    .with_recipe("sph_ifs_spectra_positions")
                    .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                    .with_report("sphere_wavelength", ReportInput.RECIPE_INPUTS_OUTPUTS)
                    .with_main_input(ifs_raw_specpos)
                    .with_associated_input(task_ifs_ins_bg, [IFS_CAL_BACKGROUND], min_ret=0)
                    .with_associated_input(task_ifs_dark, [IFS_MASTER_DARK], min_ret=1)
                    .with_associated_input(task_ifs_static_bpm, [IFS_STATIC_BADPIXELMAP], min_ret=0)
                    .with_meta_targets([qc1calib, calchecker])
                    .build())

# Determine the wavelength-pixel relation for each IFU spectrum, using the information from task_ifs_specpos
task_ifs_wavecal = (task("ifs_wavelength_calibration")
                    .with_recipe("sph_ifs_wave_calib")
                    .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                    .with_report("sphere_wavelength", ReportInput.RECIPE_INPUTS_OUTPUTS)
                    .with_main_input(ifs_raw_wavecalib)
                    .with_associated_input(task_ifs_ins_bg, [IFS_CAL_BACKGROUND], min_ret=0)
                    .with_associated_input(task_ifs_dark, [IFS_MASTER_DARK], min_ret=1)
                    .with_associated_input(task_ifs_static_bpm, [IFS_STATIC_BADPIXELMAP], min_ret=0)
                    .with_associated_input(task_ifs_specpos, [IFS_SPECPOS], min_ret=1)
                    .with_meta_targets([qc1calib, calchecker])
                    .build())
# Determine an IFU master flat with the pixel-to-pixel variation removed by the master detector flats and using
# the information on the illuminated regions and wavelength calibration from task_ifs_specpos and task_ifs_wavecal
# with the same pixel footprint as the science cube
task_ifs_ifu_flat = (task("ifs_ifu_flat")
                     .with_recipe("sph_ifs_instrument_flat")
                     .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                     .with_report("sphere_ifu_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(ifs_raw_ins_flat)
                     .with_dynamic_parameter("IFS_disperser", which_disperser)
                     .with_associated_input(task_ifs_ins_bg, [IFS_CAL_BACKGROUND], min_ret=0)
                     .with_associated_input(task_ifs_dark, [IFS_MASTER_DARK], min_ret=1)
                     .with_associated_input(task_ifs_static_bpm, [IFS_STATIC_BADPIXELMAP], min_ret=0)
                     .with_associated_input(task_ifs_wavecal, [IFS_WAVECALIB], min_ret=1)
                     .with_associated_input(task_ifs_det_flat_nb1, [IFS_MASTER_DFF_LONG1], min_ret=1)
                     .with_associated_input(task_ifs_det_flat_nb2, [IFS_MASTER_DFF_LONG2], min_ret=1)
                     .with_associated_input(task_ifs_det_flat_nb3, [IFS_MASTER_DFF_LONG3], min_ret=1)
                     .with_associated_input(task_ifs_det_flat_nb4, [IFS_MASTER_DFF_LONG4], condition=is_YJH,
                                            min_ret=0)
                     .with_associated_input(task_ifs_det_flat_bb, [IFS_MASTER_DFF_LONGBB], min_ret=1)
                     .with_input_filter(IFS_STATIC_BADPIXELMAP, IFS_WAVECALIB,
                                        IFS_MASTER_DFF_LONG1, IFS_MASTER_DFF_LONG2,
                                        IFS_MASTER_DFF_LONG3, IFS_MASTER_DFF_LONG4,
                                        IFS_MASTER_DFF_LONGBB, IFS_MASTER_DARK, IFS_CAL_BACKGROUND,
                                        mode=FilterMode.SELECT)
                     .with_meta_targets([qc1calib, calchecker])
                     .build())

# Commented because it is currently not used for anything
# task_ifs_rongain = (task("ifs_rongain")
#                    .with_recipe("sph_ifs_gain")
#                    .with_main_input(ifs_raw_flat_RONGain)
#                    .with_meta_targets([qc1calib])
#                    .build())

# Determine internal distortion
# No meta_targets except calchecker because the pipeline recipe does not work properly
task_ifs_distortion = (task("ifs_distortion_map")
                       .with_recipe("sph_ifs_distortion_map")
                       .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                       .with_main_input(ifs_raw_distortion)
                       .with_dynamic_parameter("IFS_disperser", which_disperser)
                       .with_associated_input(task_ifs_ins_bg, [IFS_CAL_BACKGROUND], min_ret=0)
                       .with_associated_input(task_ifs_dark, [IFS_MASTER_DARK], min_ret=1)
                       .with_associated_input(task_ifs_static_bpm, [IFS_STATIC_BADPIXELMAP], min_ret=0)
                       .with_associated_input(task_ifs_wavecal, [IFS_WAVECALIB], min_ret=0)
                       .with_associated_input(task_ifs_det_flat_nb1, [IFS_MASTER_DFF_LONG1], min_ret=0)
                       .with_associated_input(task_ifs_det_flat_nb2, [IFS_MASTER_DFF_LONG2], min_ret=0)
                       .with_associated_input(task_ifs_det_flat_nb3, [IFS_MASTER_DFF_LONG3], min_ret=0)
                       .with_associated_input(task_ifs_det_flat_nb4, [IFS_MASTER_DFF_LONG4], condition=is_YJH,
                                              min_ret=0)
                       .with_associated_input(task_ifs_det_flat_bb, [IFS_MASTER_DFF_LONGBB], min_ret=0)
                       .with_associated_input(task_ifs_ifu_flat, [IFS_IFU_FLAT_FIELD], min_ret=0)
                       .with_associated_input(ifs_point_pattern_table)
                       .with_input_filter(IFS_STATIC_BADPIXELMAP, IFS_WAVECALIB,
                                          IFS_MASTER_DFF_LONG1, IFS_MASTER_DFF_LONG2,
                                          IFS_MASTER_DFF_LONG3, IFS_MASTER_DFF_LONG4,
                                          IFS_MASTER_DFF_LONGBB, IFS_IFU_FLAT_FIELD, IFS_MASTER_DARK,
                                          IFS_CAL_BACKGROUND, mode=FilterMode.SELECT)
                       .with_meta_targets([qc1calib, calchecker])
                       .build())

# std
task_ifs_std_flux, task_ifs_std_astrometry = process_ifs_standard(task_ifs_dark, task_ifs_ins_bg, task_ifs_sky_bg,
                                                                  task_ifs_static_bpm, task_ifs_wavecal,
                                                                  task_ifs_det_flat_nb1, task_ifs_det_flat_nb2,
                                                                  task_ifs_det_flat_nb3, task_ifs_det_flat_nb4,
                                                                  task_ifs_det_flat_bb, task_ifs_ifu_flat,
                                                                  task_ifs_distortion)

# science
task_ifs_coronagraph_center, task_ifs_science_flux, task_ifs_science = \
    process_ifs_science(task_ifs_dark, task_ifs_ins_bg, task_ifs_sky_bg, task_ifs_wavecal,
                        task_ifs_det_flat_nb1, task_ifs_det_flat_nb2, task_ifs_det_flat_nb3, task_ifs_det_flat_nb4,
                        task_ifs_det_flat_bb, task_ifs_ifu_flat, task_ifs_distortion, task_ifs_static_bpm)
