from edps import match_rules, match, UNLIMITED

from . import sphere_keywords as kwd
from .sphere_rules import (
    is_calib, is_technical, is_test, is_sphere, is_science, is_img_calib,
    TEN_DAYS, TWELVE_DAYS,
)

# grouping keywords
grpkwd_zpl_bias = [
    kwd.det_read_curname,
    kwd.det_ndit,
    kwd.tpl_start
]
grpkwd_zpl_dark = [
    kwd.det_read_curname,
    kwd.exptime,
    kwd.det_ndit,
    kwd.tpl_start
]
grpkwd_zpl_flat = [
    kwd.ins3_opti1_name,
    kwd.ins3_opti2_name,
    kwd.ins3_opti3_name,
    kwd.ins3_opti4_name,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.det_read_curname,
    kwd.exptime,
    kwd.det_ndit,
    kwd.tpl_start
]
grpkwd_zpl_science_ctr_flx = [
    kwd.arcfile
]
grpkwd_zpl_science_obj = [
    kwd.ins3_opti2_name,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.det_read_curname,
    kwd.tpl_start
]

# setup keywords
setupkwd_zpl_bias = [
    kwd.det_read_curname
]
setupkwd_zpl_dark = [
    kwd.det_read_curname
]
setupkwd_zpl_flat = [
    kwd.ins3_opti1_name,
    kwd.ins3_opti2_name,
    kwd.ins3_opti3_name,
    kwd.ins3_opti4_name,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.det_read_curname,
    kwd.exptime,
    kwd.det_ndit
]
setupkwd_zpl_science_ctr_flx = [
    kwd.ins_comb_vcor,
    kwd.ins3_opti1_name,
    kwd.ins3_opti2_name,
    kwd.ins3_opti3_name,
    kwd.ins3_opti4_name,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.det_read_curname
]
setupkwd_zpl_science_obj = [
    kwd.ins3_opti2_name,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.det_read_curname
]

# match keywords
matchkwd_zpl_det = [
    kwd.det_read_curname
]
matchkwd_zpl_flat = [
    kwd.det_read_curname,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name
]
matchkwd_zpl_flat1 = [
    kwd.det_read_curname,
    kwd.ins3_opti5_name
]
matchkwd_zpl_flat2 = [
    kwd.det_read_curname,
    kwd.ins3_opti6_name
]
matchkwd_zpl_star_cal = [
    kwd.det_read_curname,
    kwd.ins3_opti5_name,
    kwd.ins3_opti6_name,
    kwd.obs_start
]


def is_zimpol(f):
    return is_sphere and f[kwd.seq_arm] == "ZIMPOL"


def is_zpl_technical(f):
    return is_technical(f) and is_zimpol(f)


def is_zpl_test(f):
    return is_test(f) and is_zimpol(f)


# classification rules for IMAGING
def is_zpl_acq(f):
    return is_zimpol(f) and f[kwd.dpr_catg] == "ACQUISITION"


def is_zpl_acq_object(f):
    return is_zpl_acq(f) and f[kwd.dpr_type] == "OBJECT"


def is_zpl_acq_dark(f):
    return is_zpl_acq(f) and f[kwd.dpr_type] == "DARK"


def is_zpl_acq_flat(f):
    return is_zpl_acq(f) and f[kwd.dpr_type] == "FLAT,LAMP"


def is_zpl_bias_img(f):
    return is_zimpol(f) and is_img_calib(f) and f[kwd.dpr_type] == "BIAS"


def is_zpl_dark_img(f):
    return is_zimpol(f) and is_img_calib(f) and f[kwd.dpr_type] == "DARK"


def is_zpl_flat_img(f):
    return is_zimpol(f) and is_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP"


def is_zpl_distortion_img(f):
    return is_zimpol(f) and is_img_calib(f) and f[kwd.dpr_type] == "LAMP,ASTROMETRY"


def is_zpl_standard_flux_img(f):
    return is_zimpol(f) and f[kwd.dpr_type] == "STD,FLUX" and \
        (f[kwd.dpr_tech] == "IMAGE" or f[kwd.dpr_tech] == "IMAGE,SAM")


def is_zpl_standard_astrometry_img(f):
    return is_zimpol(f) and is_img_calib(f) and f[kwd.dpr_type] == "STD,ASTROMETRY"


def is_zpl_coronagraph_center_img(f):
    return is_zimpol(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT,CENTER" and \
        (f[kwd.dpr_tech] == "IMAGE,PUPILSTAB"
         or f[kwd.dpr_tech] == "IMAGE,FIELDSTAB")


def is_zpl_science_flux_img(f):
    return is_zimpol(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT,FLUX" and \
        (f[kwd.dpr_tech] == "IMAGE,PUPILSTAB"
         or f[kwd.dpr_tech] == "IMAGE,FIELDSTAB")


def is_zpl_science_img(f):
    return is_zimpol(f) and is_science(f) and f[kwd.dpr_type] == "OBJECT" and \
        (f[kwd.dpr_tech] == "IMAGE,PUPILSTAB"
         or f[kwd.dpr_tech] == "IMAGE,FIELDSTAB"
         or f[kwd.dpr_tech] == "IMAGE,PUPILSTAB,SAM")


# Matching rules

# def is_assoc_lamp_mos(ref, f):
#    return match(ref, f, matchkwd["SPEC"] + ["ins.slit1.name"] + [kwd.tpl_start])
# classification rules for POLARIMETRY


def is_pol_mode(f):
    return f[kwd.dpr_tech] == "POLARIMETRY"


def is_pol_calib(f):
    return is_pol_mode(f) and is_calib(f)


def is_zpl_fast_pol(f):
    return is_zimpol(f) and f[kwd.det_read_curname] == "FastPolarimetry"


def is_zpl_bias_pol(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "BIAS"


def is_zpl_dark_pol(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "DARK"


def is_zpl_flat_pol(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP"


# modem_eff = efficiency of the modulation-demodulation cycle of rows in ZIMPOL detector
def is_zpl_modemeff(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "FLAT,POL100"


def is_zpl_distortion_pol(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "LAMP,ASTROMETRY"


def is_zpl_standard_pol0(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "STD,POL0"


def is_zpl_standard_polhigh(f):
    return is_zimpol(f) and is_pol_calib(f) and f[kwd.dpr_type] == "STD,POLHIGH"


def is_zpl_coronagraph_center_pol(f):
    return is_zimpol(f) and is_science(f) and \
        ((f[kwd.ins4_mode] == "ZIMPOL_P1" and f[kwd.dpr_tech] == "POLARIMETRY,P1")
         or (f[kwd.ins4_mode] == "ZIMPOL_P2" and f[kwd.dpr_tech] == "POLARIMETRY,P2")) \
        and f[kwd.dpr_type] == "OBJECT,CENTER"


def is_zpl_science_flux_pol_p1(f):
    return is_zimpol(f) and is_science(f) and f[kwd.ins4_mode] == "ZIMPOL_P1" \
        and f[kwd.dpr_tech] == "POLARIMETRY,P1" and f[kwd.dpr_type] == "OBJECT,FLUX"


def is_zpl_science_pol_p1(f):
    return is_zimpol(f) and is_science(f) \
        and f[kwd.dpr_tech] == "POLARIMETRY,P1" and f[kwd.dpr_type] == "OBJECT"


def is_zpl_coronagraph_center_pol_p2(f):
    return is_zimpol(f) and is_science(f) \
        and f[kwd.dpr_tech] == "POLARIMETRY,P2" and f[kwd.dpr_type] == "OBJECT,CENTER"


def is_zpl_science_flux_pol_p2(f):
    return is_zimpol(f) and is_science(f) \
        and f[kwd.dpr_tech] == "POLARIMETRY,P2" and f[kwd.dpr_type] == "OBJECT,FLUX"


def is_zpl_science_pol_p2(f):
    return is_zimpol(f) and is_science(f) \
        and f[kwd.dpr_tech] == "POLARIMETRY,P2" and f[kwd.dpr_type] == "OBJECT"


# ################  Association rules   ######################################################################
# ##  -  first, e.g.  ref=trigger (e.g. science)                                                           ###
# ##  -  second, e.g.  f=file to associate (e.g. calibration)                                              ###
# ############################################################################################################


def zpl_long_dark_cond(ref, f):
    return match(ref, f, [kwd.seq_arm, kwd.det_read_curname]) and ref[kwd.exptime] > 30


def zpl_bias_fast_pol_cond(ref, f):
    return match(ref, f, [kwd.seq_arm, kwd.det_read_curname]) and ref[kwd.det_read_curname] == "FastPolarimetry"


def zpl_ff1_cond(ref, f):
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti5_name] == f[kwd.ins3_opti5_name]
    c3 = ref[kwd.ins3_opti5_name] != "OPEN" or (ref[kwd.ins3_opti5_name] == "OPEN" and
                                                ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name])

    cond_ff1 = c1 and c2 and c3
    return cond_ff1


def zpl_ff2_cond(ref, f):
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti6_name] == f[kwd.ins3_opti6_name]
    c3 = ref[kwd.ins3_opti6_name] != "OPEN" or (ref[kwd.ins3_opti6_name] == "OPEN" and
                                                ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name])

    cond_ff2 = c1 and c2 and c3
    return cond_ff2


zpl_ff_cam1 = (match_rules()
               .with_match_function(zpl_ff1_cond, time_range=TEN_DAYS, level=0)
               .with_match_function(zpl_ff1_cond, time_range=TWELVE_DAYS, level=1)
               .with_match_function(zpl_ff1_cond, time_range=UNLIMITED, level=3)
               )

zpl_ff_cam2 = (match_rules()
               .with_match_function(zpl_ff2_cond, time_range=TEN_DAYS, level=0)
               .with_match_function(zpl_ff2_cond, time_range=TWELVE_DAYS, level=1)
               .with_match_function(zpl_ff2_cond, time_range=UNLIMITED, level=3)
               )


def zpl_modemeff1_cal_cond(ref, f):
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti5_name] == f[kwd.ins3_opti5_name]
    c3 = ref[kwd.ins3_opti5_name] != "OPEN" or (ref[kwd.ins3_opti5_name] == "OPEN" and
                                                ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name])

    cond_modemeff1_cal = c1 and c2 and c3 and ref[kwd.dpr_tech] == "POLARIMETRY" and ref[kwd.dpr_catg] == "CALIB"
    return cond_modemeff1_cal


def zpl_modemeff2_cal_cond(ref, f):
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti6_name] == f[kwd.ins3_opti6_name]
    c3 = ref[kwd.ins3_opti6_name] != "OPEN" or (ref[kwd.ins3_opti6_name] == "OPEN" and
                                                ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name])

    cond_modemeff2_cal = c1 and c2 and c3 and ref[kwd.dpr_tech] == "POLARIMETRY" and ref[kwd.dpr_catg] == "CALIB"
    return cond_modemeff2_cal


zpl_modemeff1_cal = (match_rules()
                     .with_match_function(zpl_modemeff1_cal_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff1_cal_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff1_cal_cond, time_range=UNLIMITED, level=3)
                     )

zpl_modemeff2_cal = (match_rules()
                     .with_match_function(zpl_modemeff2_cal_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff2_cal_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff2_cal_cond, time_range=UNLIMITED, level=3)
                     )


def zpl_modemeff1_flx_cond(ref, f):
    c0 = (ref[kwd.dpr_tech] == "POLARIMETRY,P1" or ref[kwd.dpr_tech] == "POLARIMETRY,P2") and \
         (ref[kwd.dpr_type] == "OBJECT,FLUX" or ref[kwd.dpr_type] == "OBJECT,CENTER")
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti5_name] != "OPEN"
    c3 = ref[kwd.ins3_opti5_name] == f[kwd.ins3_opti5_name]
    c4 = (f[kwd.ins3_opti5_name] == "N_R" and
          (ref[kwd.ins3_opti5_name] in ["R_PRIM", "B_Ha", "VBB", "CntHa", "Ha_NB", "N_Ha"]))
    c5 = (f[kwd.ins3_opti5_name] == "N_I" and
          (ref[kwd.ins3_opti5_name] in ["I_PRIM", "Cnt820", "KI", "TiO_717", "CH4_727", "Cnt748"]))
    c6 = ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name]
    c7 = (f[kwd.ins3_opti5_name] == "N_R" and
          (ref[kwd.ins3_opti2_name] in ["Ha_NB", "OI_630", "730_NB"]))
    c8 = (f[kwd.ins3_opti5_name] == "V" and
          (ref[kwd.ins3_opti2_name] in ["HeI", "V_S", "V_L"]))
    c9 = ref[kwd.ins3_opti2_name] == "I_L" and f[kwd.ins3_opti5_name] == "N_I"

    cond_modemeff1_flx = c0 and c1 and (c2 and (c3 or c4 or c5) or (c2 and (c6 or c7 or c8 or c9)))
    return cond_modemeff1_flx


def zpl_modemeff2_flx_cond(ref, f):
    c0 = (ref[kwd.dpr_tech] == "POLARIMETRY,P1" or ref[kwd.dpr_tech] == "POLARIMETRY,P2") and \
         (ref[kwd.dpr_type] == "OBJECT,FLUX" or ref[kwd.dpr_type] == "OBJECT,CENTER")
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti6_name] != "OPEN"
    c3 = ref[kwd.ins3_opti6_name] == f[kwd.ins3_opti6_name]
    c4 = (f[kwd.ins3_opti6_name] == "N_R" and
          (ref[kwd.ins3_opti6_name] in ["R_PRIM", "B_Ha", "VBB", "CntHa", "Ha_NB", "N_Ha"]))
    c5 = (f[kwd.ins3_opti6_name] == "N_I" and
          (ref[kwd.ins3_opti6_name] in ["I_PRIM", "Cnt820", "KI", "TiO_717", "CH4_727", "Cnt748"]))
    c6 = ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name]
    c7 = (f[kwd.ins3_opti6_name] == "N_R" and
          (ref[kwd.ins3_opti2_name] in ["Ha_NB", "OI_630", "730_NB"]))
    c8 = (f[kwd.ins3_opti6_name] == "V" and
          (ref[kwd.ins3_opti2_name] in ["HeI", "V_S", "V_L"]))
    c9 = ref[kwd.ins3_opti2_name] == "I_L" and f[kwd.ins3_opti6_name] == "N_I"

    cond_modemeff2_flx = c0 and c1 and (c2 and (c3 or c4 or c5) or (c2 and (c6 or c7 or c8 or c9)))
    return cond_modemeff2_flx


zpl_modemeff1_flx = (match_rules()
                     .with_match_function(zpl_modemeff1_flx_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff1_flx_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff1_flx_cond, time_range=UNLIMITED, level=3)
                     )

zpl_modemeff2_flx = (match_rules()
                     .with_match_function(zpl_modemeff2_flx_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff2_flx_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff2_flx_cond, time_range=UNLIMITED, level=3)
                     )


def zpl_modemeff1_sci_cond(ref, f):
    c0 = (ref[kwd.dpr_tech] == "POLARIMETRY,P1" or ref[kwd.dpr_tech] == "POLARIMETRY,P2") and \
         ref[kwd.dpr_type] == "OBJECT" and ref[kwd.dpr_catg] == "SCIENCE"
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti5_name] != "OPEN"
    c3 = ref[kwd.ins3_opti5_name] == f[kwd.ins3_opti5_name]
    c4 = (f[kwd.ins3_opti5_name] == "N_R" and
          (ref[kwd.ins3_opti5_name] in ["R_PRIM", "B_Ha", "VBB", "CntHa", "Ha_NB", "N_Ha"]))
    c5 = (f[kwd.ins3_opti5_name] == "N_I" and
          (ref[kwd.ins3_opti5_name] in ["I_PRIM", "Cnt820", "KI", "TiO_717", "CH4_727", "Cnt748"]))
    c6 = ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name]
    c7 = (f[kwd.ins3_opti5_name] == "N_R" and
          (ref[kwd.ins3_opti2_name] in ["Ha_NB", "OI_630", "730_NB"]))
    c8 = (f[kwd.ins3_opti5_name] == "V" and
          (ref[kwd.ins3_opti2_name] in ["HeI", "V_S", "V_L"]))
    c9 = ref[kwd.ins3_opti2_name] == "I_L" and f[kwd.ins3_opti5_name] == "N_I"

    cond_modemeff1_sci = c0 and c1 and (c2 and (c3 or c4 or c5) or (c2 and (c6 or c7 or c8 or c9)))
    return cond_modemeff1_sci


def zpl_modemeff2_sci_cond(ref, f):
    c0 = (ref[kwd.dpr_tech] == "POLARIMETRY,P1" or ref[kwd.dpr_tech] == "POLARIMETRY,P2") and \
         ref[kwd.dpr_type] == "OBJECT" and ref[kwd.dpr_catg] == "SCIENCE"
    c1 = ref[kwd.seq_arm] == f[kwd.seq_arm] and ref[kwd.det_read_curname] == f[kwd.det_read_curname]
    c2 = ref[kwd.ins3_opti6_name] != "OPEN"
    c3 = ref[kwd.ins3_opti6_name] == f[kwd.ins3_opti6_name]
    c4 = (f[kwd.ins3_opti6_name] == "N_R" and
          (ref[kwd.ins3_opti6_name] in ["R_PRIM", "B_Ha", "VBB", "CntHa", "Ha_NB", "N_Ha"]))
    c5 = (f[kwd.ins3_opti6_name] == "N_I" and
          (ref[kwd.ins3_opti6_name] in ["I_PRIM", "Cnt820", "KI", "TiO_717", "CH4_727", "Cnt748"]))
    c6 = ref[kwd.ins3_opti2_name] == f[kwd.ins3_opti2_name]
    c7 = (f[kwd.ins3_opti6_name] == "N_R" and
          (ref[kwd.ins3_opti2_name] in ["Ha_NB", "OI_630", "730_NB"]))
    c8 = (f[kwd.ins3_opti6_name] == "V" and
          (ref[kwd.ins3_opti2_name] in ["HeI", "V_S", "V_L"]))
    c9 = ref[kwd.ins3_opti2_name] == "I_L" and f[kwd.ins3_opti6_name] == "N_I"

    cond_modemeff2_sci = c0 and c1 and (c2 and (c3 or c4 or c5) or (c2 and (c6 or c7 or c8 or c9)))
    return cond_modemeff2_sci


zpl_modemeff1_sci = (match_rules()
                     .with_match_function(zpl_modemeff1_sci_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff1_sci_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff1_sci_cond, time_range=UNLIMITED, level=3))

zpl_modemeff2_sci = (match_rules()
                     .with_match_function(zpl_modemeff2_sci_cond, time_range=TEN_DAYS, level=0)
                     .with_match_function(zpl_modemeff2_sci_cond, time_range=TWELVE_DAYS, level=1)
                     .with_match_function(zpl_modemeff2_sci_cond, time_range=UNLIMITED, level=3))
