import os
from adari_core.data_libs.master_ifu_flat import MasterIfuFlatReport
from adari_core.plots.text import TextPlot
from .sphere_utils import SphereSetupInfo, SphereReportMixin


class SphereIfuFlatReport(SphereReportMixin, MasterIfuFlatReport):
    def __init__(self):
        super().__init__("sphere_ifu_flat")
        self.center_size = 200
        self.ifu_flat = False
        self.files_needed_det = [
            "IFS_LARGE_SCALE_FLAT",
            "IFS_MASTER_DFF_LONG1",
            "IFS_MASTER_DFF_LONG2",
            "IFS_MASTER_DFF_LONG3",
            "IFS_MASTER_DFF_LONG4",
            "IFS_MASTER_DFF_LONGBB",
            "IFS_PREAMP_FLAT",
        ]
        self.files_needed_ifu = ["IFS_IFU_FLAT_FIELD", "IFS_INSTRUMENT_FLAT_FIELD"]
        self.histmin = 0.8
        self.histmax = 1.2

    def parse_sof(self):

        flat = []
        for filename, catg in self.inputs:
            if catg in self.files_needed_ifu:
                flat.append(filename)
        if len(flat) == 0:
            for filename, catg in self.inputs:
                if catg in self.files_needed_det:
                    flat.append(filename)

        # Build and return the file name list
        file_lists = []
        for item in flat:
            file_lists.append(
                {
                    "master_im": item,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        """Create both single and multiple extension panels."""
        panels = {}

        for i in range(len(self.hdus)):

            hdr = self.hdus[i]["master_im"]["PRIMARY"].header

            p = self.single_panel(
                self.hdus[i]["master_im"]["IMAGE"],
                master_im_limits=None,
                cutout_limits=None,
            )

            # Text Plot
            px, py = 0, 0
            # which hdul and ext to use
            vspace = 0.3
            t1 = TextPlot(columns=1, v_space=vspace)
            fname = os.path.basename(str(self.hdus[i]["master_im"].filename()))

            col1 = (
                str(hdr.get("INSTRUME")),
                "EXTNAME: " + str(hdr.get("EXTNAME", "N/A")),
                "PRO CATG: " + str(hdr.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: " + str(hdr.get("HIERARCH ESO PRO REC1 RAW1 NAME")),
            )
            t1.add_data(col1)
            p.assign_plot(t1, px, py, xext=2)

            px = px + 2
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = SphereSetupInfo.ifs_flat(self.hdus[i]["master_im"])
            t2.add_data(col2)
            p.assign_plot(t2, px, py, xext=1)

            master_procatg = str(hdr.get("HIERARCH ESO PRO CATG"))

            addme = {  # "ext": ext,
                "report_name": f"sphere_master_flat_multi_panel_{i}",
                "report_description": f"SPHERE flat multi panel {master_procatg}",
                "report_tags": [],
            }

            panels[p] = addme
        return panels


rep = SphereIfuFlatReport()
