import os
from adari_core.data_libs.master_dark_bias import MasterRawCutsReport
from adari_core.plots.text import TextPlot
from .sphere_utils import SphereSetupInfo, SphereReportMixin

class SphereMasterBiasReport(SphereReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("sphere_master_bias")
        self.img = False

    def parse_sof(self):

        master_bias = []

        for filename, catg in self.inputs:
            if catg == "ZPL_MASTER_BIAS_CAM1" or catg == "ZPL_MASTER_BIAS_CAM2":
                master_bias.append(filename)
            elif (
                catg == "ZPL_MASTER_BIAS_IMAGING_CAM1"
                or catg == "ZPL_MASTER_BIAS_IMAGING_CAM2"
            ):
                master_bias.append(filename)
                self.img = True

        # Build and return the file name list
        file_lists = []
        for item in master_bias:
            file_lists.append(
                {
                    "master_im": item,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        if self.img:
            exts = ["IFRAME.IMAGE", "LEAKAGE.IMAGE"]
        else:
            exts = [
                "PHASE-0.ODD.IMAGE",
                "PHASE-0.EVEN.IMAGE",
                "PHASE-PI.ODD.IMAGE",
                "PHASE-PI.EVEN.IMAGE",
            ]
        vspace = 0.3

        for ext in exts:

            new_panels = super().generate_panels(
                master_im_ext=ext,
            )
            for i, (panel, panel_descr) in enumerate(new_panels.items()):
                panel_descr["report_description"] = (
                    f"SPHERE bias panel - "
                    f"{os.path.basename(panel_descr['master_im'])}, "
                    f"{panel_descr['master_im_ext']}"
                )

                master_im = self.hdus[i]["master_im"]

                # Text Plot
                fname = os.path.basename(str(master_im.filename()))
                t1 = TextPlot(columns=1, v_space=vspace)

                col1 = (
                    str(master_im["PRIMARY"].header.get("INSTRUME")),
                    "EXTNAME: " + ext,
                    "PRO CATG: "
                    + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                    "FILE NAME: " + fname,
                    "RAW1 NAME: "
                    + str(
                        master_im["PRIMARY"].header.get(
                            "HIERARCH ESO PRO REC1 RAW1 NAME"
                        )
                    ),
                )
                t1.add_data(col1)
                panel.assign_plot(t1, 0, 0, xext=2)

                t2 = TextPlot(columns=1, v_space=vspace, xext=1)
                self.metadata = SphereSetupInfo.zpl_bias(master_im)
                col2 = self.metadata
                t2.add_data(col2)
                panel.assign_plot(t2, 2, 0, xext=1)

            panels = {**panels, **new_panels}

        return panels


rep = SphereMasterBiasReport()
