/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IFS_DETECTOR_PERSISTENCE_H_

#define SPH_IFS_DETECTOR_PERSISTENCE_H_
#define SPH_IFS_DETECTOR_PERSISTENCE_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ifs_detector_persistence that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ifs_detector_persistence_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     detector_persistence_outfilename      ; /* The parameter of ifs.detector_persistence.outfilename */

    int                             fitorder                              ; /* The parameter of ifs.detector_persistence.fitorder */

    int                             coll_alg                              ; /* The parameter of ifs.detector_persistence.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ifs.detector_persistence.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ifs.detector_persistence.clean_mean.reject_low */

    double                          threshold_ill                         ; /* The parameter of ifs.detector_persistence.threshold_upper */

    double                          threshold_dark                        ; /* The parameter of ifs.detector_persistence.threshold_lower */

    cpl_frameset*                   rawframes                             ; /* The IFS_DETECTOR_PERSISTENCE_OFF_RAW frames */

    cpl_frameset*                   satframes                             ; /* The IFS_DETECTOR_PERSISTENCE_ON_SAT_RAW frames */

    cpl_frameset*                   unsatframes                           ; /* The IFS_DETECTOR_PERSISTENCE_ON_UNSAT_RAW frames */

    cpl_frame*                      master_dark_frame                     ; /* The IFS_MASTER_DARK frames */

    cpl_frame*                      static_badpixel_frame                 ; /* The IFS_STATIC_BADPIXELMAP frames */

    sph_framelist*                  detector_persistence_framelist        ; /* The DETECTOR_PERSISTENCE_FRAMELIST data field */

    sph_cube*                       detector_persistence_cube             ; /* The DETECTOR_PERSISTENCE_CUBE data field */

} sph_ifs_detector_persistence;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ifs_detector_persistence_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ifs_detector_persistence.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ifs_detector_persistence* sph_ifs_detector_persistence_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ifs_detector_persistence_check_frames( sph_ifs_detector_persistence* self );

sph_error_code sph_ifs_detector_persistence_check_params( sph_ifs_detector_persistence* parlist );

cpl_error_code sph_ifs_detector_persistence_run( sph_ifs_detector_persistence* self );

sph_error_code sph_ifs_detector_persistence_delete( sph_ifs_detector_persistence* self );
cpl_parameterlist*  sph_ifs_detector_persistence_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ifs_detector_persistence.c */


/* End of extra function declarations that are defined in sph_ifs_detector_persistence_run.c */



#endif /*SPH_IFS_DETECTOR_PERSISTENCE_H_*/
