/***********************************************************************************************/
 /******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
 /***********************************************************************************************/

 /* $Id: $
  * This file is part of the SPHERE Pipeline
  * Copyright (C) 2007-2010 European Southern Observatory
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
 
 /*
  * $Author: $
  * $Date: $
  * $Revision: $
  * $Name: $
  */
 
 /*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/
 
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
 
 #include "sph_ifs_master_detector_flat.h"
 #include "sph_common_keywords.h"
 #include "sph_ifs_keywords.h"
 #include "sph_ifs_tags.h"
 #include "sph_master_frame.h"
 #include "sph_error.h"
 #include "sph_cube.h"
 #include "sph_utils.h"
 
 #include <math.h>
 #include <assert.h>
 #include <cpl.h>
 
 /*-----------------------------------------------------------------------------
   Error Codes
  -----------------------------------------------------------------------------*/
 
 sph_error_code SPH_IFS_MASTER_DETECTOR_FLAT_GENERAL              = SPH_IFS_MASTER_DETECTOR_FLAT_ERR_START + 0;
 sph_error_code SPH_IFS_MASTER_DETECTOR_FLAT_NO_VALID_DIT_LIST    = SPH_IFS_MASTER_DETECTOR_FLAT_ERR_START + 1;
 
 sph_error_code SPH_IFS_MASTER_DETECTOR_FLAT_PARAMETER_MISSING    = SPH_IFS_MASTER_DETECTOR_FLAT_ERR_START + 3;
 sph_error_code SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING       = SPH_IFS_MASTER_DETECTOR_FLAT_ERR_START + 4;
 
 /*-----------------------------------------------------------------------------
  Private function prototypes
  -----------------------------------------------------------------------------*/
 
 static int sph_ifs_master_detector_flat_create_plugin ( cpl_plugin * );
 static int sph_ifs_master_detector_flat_exec_plugin ( cpl_plugin * );
 static int sph_ifs_master_detector_flat_destroy_plugin ( cpl_plugin * );
 
 /*-----------------------------------------------------------------------------
  Static variables
  -----------------------------------------------------------------------------*/
 
 static const char* sph_ifs_master_detector_flat_help = 
     "RECIPE INPUT FRAMES: \n"
     "-------------------- \n"
     "Tag                           Min,Max   Description\n"
     "IFS_DETECTOR_FLAT_FIELD_RAW     2,500   The input raw flat frames. To be taken with different illumination levels.\n"
     "IFS_MASTER_DARK                 0,  1   The master dark frame. Should have the same DIT and readout mode as\n"
     "                                        the raw frames.\n"
     "IFS_LARGE_SCALE_FLAT            0,  1   A large scale structure flat. If provided the result is divided by this before saved.\n"
     "IFS_PREAMP_FLAT                 0,  1   A preamp correction flat. If provided the result is divided by this before saved.\n"
     "IFS_STATIC_BADPIXELMAP          0,  1   Optional frame of static bad pixels. If provided, this is used in addtion to\n"
     "                                        the badpixels from the master dark.\n"
     "\n"
     "RAW FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Type   Optional  Description\n"
     "\n"
     "DESCRIPTION:\n"
     "------------\n"
     "The detector flat field recipe for IFS is very similar to the instrument\n"
     "\n"
     "flat field recipe for IRDIS.  The recipe as described here uses input\n"
     "\n"
     "exposures taken with the narrow band or broad band calibration lamps.\n"
     "\n"
     "Several types of flat fields can be produced -- in accordance with the\n"
     "\n"
     "calibration plan and the need to have seperate flat field components to\n"
     "\n"
     "provide maximal time stability and flat fielding accuracy. The recipe can\n"
     "\n"
     "be used to create a preamplifier correction flat (which can be used to\n"
     "\n"
     "remove the stripe structure caused by the pre amplifiers), a large scale\n"
     "\n"
     "flat field which is a smoothed flat field and hence only shows large scale\n"
     "\n"
     "structures, and a normal flat field.\n"
     "\n"
     "\n"
     "\n"
     "Experience from the SPHERE Data Centre shows that the\n"
     "\n"
     "IFS\_MASTER\_DFF\_LONG files (both at the various wavelengths and the white\n"
     "\n"
     "one) are sufficient to correct the pixel-to-pixel variation in the detector\n"
     "\n"
     "response. The preamplifier correction flat and the large scale flat field\n"
     "\n"
     "(which contains smoothed bad pixels) are not needed for further processing.\n"
     "\n"
     "\n"
     "\n"
     "The recipe creates master calibration frames, using the input exposures\n"
     "\n"
     "which should be taken as described in the IFS calibration plan. The usual\n"
     "\n"
     "procedure to create a flat field is as follows. All raw frames are read in\n"
     "\n"
     "and dark subtracted. The frames are then corrected for the pre-amplifier\n"
     "\n"
     "variations derived from the input raw data (note that it is currently not\n"
     "\n"
     "possible to skip the pre amplifier correction altogether). This correction\n"
     "\n"
     "is a division operation rather than a subtraction. After this correction,\n"
     "\n"
     "the mean pixel value across the image is determined for all exposures. For\n"
     "\n"
     "every pixel $p = (x, y)$, a set of $m_i,v_i(x, y)$ data pairs are stored\n"
     "\n"
     "with $m_i$ being the mean value of exposure $i$ described above, and $v_i\n"
     "\n"
     "(x, y)$ being the pixel value for pixel $p(x, y)$ in exposure $i$. The flat\n"
     "\n"
     "field value is defined as the slope $c_i$ of a linear fit F to the data\n"
     "\n"
     "$m_i,v_i$. The resulting slope represents the response of an individual\n"
     "\n"
     "pixel $p(x, y)$ to illumination relative to the detector mean response. The\n"
     "\n"
     "value will thus naturally be close to 1 and a division by that value will\n"
     "\n"
     "correct for a pixel's deviation from the average detector response. The fit\n"
     "\n"
     "itself is performed either using a maximum likelyhood method or a robust\n"
     "\n"
     "fitting method which minimizes the sum of the absolute value of the\n"
     "\n"
     "deviations rather than the sum of the squares of the deviations (see e.g.\n"
     "\n"
     "Numerical Recipes for the algorithm). The robust fitting method will yield\n"
     "\n"
     "better results when significant outliers (e.g. due to cosmic rays) can be\n"
     "\n"
     "expected, but does not allow anything but linear fits and can hence not be\n"
     "\n"
     "used to assess detector non-linearity.\n"
     "\n"
     "\n"
     "\n"
     "The flat field values are saved as an image as the main product of the\n"
     "\n"
     "recipe.  Aditionally, the recipe may also produce as output a map of all\n"
     "\n"
     "pixels that are identified as non-linear. The criteria for non-linearity\n"
     "\n"
     "are set by the user parameters and can be either pixels that have a flat\n"
     "\n"
     "field value outside specified bounds and/or pixels for which the linear fit\n"
     "\n"
     "produces a reduced chi-squared above a given threshold value. For reliable\n"
     "\n"
     "non-linearity flagging using the reduced chi-squared fit many high quality\n"
     "\n"
     "input exposures are needed.  In case that a non zero smoothing value was\n"
     "\n"
     "given, a large scale flat is also created by smoothing the flat field with\n"
     "\n"
     "either a gaussian kernel using FFT or a square kernel using the specific\n"
     "\n"
     "CPL filter algorithm. Unless you know what you are doing leave the default\n"
     "\n"
     "method here which is the FFT smoothing.\n"
     "\n"
     "RECIPE PRODUCTS: \n"
     "-------------------- \n"
     "Tag                      Format         Description\n"
     "IFS_MASTER_DETECTOR_FLAT_FIELD     FITS[Im(4)]    The flat field. This is saved as a FITS file with 4 extensions, the flat values,\n"
     "                                        the badpixels (hotpixels and non-linear pixels), the rms error on the flat\n"
     "                                        and a weightmap. Used if the lamp in use cannot be derived.\n"
     "IFS_MASTER_DFF_LONG1               FITS[Im(4)]    Same as above, produced from all input raw frames which had LAMP1 (1.020mum) switched on\n"
     "IFS_MASTER_DFF_LONG2               FITS[Im(4)]    Same as above, produced from all input raw frames which had LAMP2 (1.230mum) switched on\n"
     "IFS_MASTER_DFF_LONG3               FITS[Im(4)]    Same as above, produced from all input raw frames which had LAMP3 (1.300mum) switched on\n"
     "IFS_MASTER_DFF_LONG4               FITS[Im(4)]    Same as above, produced from all input raw frames which had LAMP4 (1.540mum) switched on\n"
     "IFS_MASTER_DFF_LONGBB              FITS[Im(4)]    Same as above, produced from all input raw frames which had either LAMP5 or LAMP6 (broad band) switched on.\n"
     "IFS_PREAMP_FLAT                    FITS[Im(4)]    Optional product with a preamp correction flat, formatted as above.\n"
     "IFS_LARGE_SCALE_FLAT               FITS[Im(4)]    Optional product with a large scale structure flat, formatted as above.\n"
     "IFS_NON_LINEAR_PIXELMAP            FITS[Im(1)]    Optional output of all the non-linear pixels determined. All pixels as determined\n"
     "                                        in this recipe using the ird.instrument_flat.badpix_*tolerance parameters.\n"
     "\n"
     "PRODUCT FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Frame          Type    Description\n"
     "\n"
 ;
 
 /*-----------------------------------------------------------------------------
  Function code
  -----------------------------------------------------------------------------*/
 /*----------------------------------------------------------------------------*/
 /**
  * @defgroup sph_ifs_master_detector_flat Create Master Dark Recipe
  *
  * This module provides the recipe plugin and relating functions for the
  * creation of the master dark .
  *
  * @par Synopsis:
  * @code
  *   #include "sph_ifs_master_detector_flat.h"
  * @endcode
  */
 /*----------------------------------------------------------------------------*/
 /**@{*/
 
 /*****************************************************************************
  *
  *
  *      First come the static and global functions necessary for the
  *      normal working of the recipe as plugin....
  *
  *
  * ***************************************************************************/
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Build the list of available plugins, for this module.
  @param    list    the plugin list
  @return   0 if everything is ok, 1 otherwise
  @note     Only this function is exported
 
  Create the recipe instance and make it available to the application
  using the interface.
  */
 /*----------------------------------------------------------------------------*/
 int cpl_plugin_get_info(cpl_pluginlist * list)
 {
     cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
     cpl_plugin * plugin = &recipe->interface;
 
     if (cpl_plugin_init(plugin,
                         CPL_PLUGIN_API,
                         SPH_IFS_MASTER_DETECTOR_FLAT_VERSION,
                         CPL_PLUGIN_TYPE_RECIPE,
                         "sph_ifs_master_detector_flat",
                         "Creation of the master detector flat frame",
                         sph_ifs_master_detector_flat_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                         "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                         sph_ifs_master_detector_flat_create_plugin,
                         sph_ifs_master_detector_flat_exec_plugin,
                         sph_ifs_master_detector_flat_destroy_plugin) )
     {
         cpl_msg_error( cpl_func, "Plugin initialization failed");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
 
     if (cpl_pluginlist_append(list, plugin) )
     {
         cpl_msg_error( cpl_func, "Error adding plugin to list");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Setup the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Defining the command-line/configuration parameters for the recipe.
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_master_detector_flat_create_plugin(cpl_plugin * plugin)
 {
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                        cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error(cpl_func, "Null plugin");
         cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     if ( plugin != NULL ) {
         cpl_recipe * recipe = (cpl_recipe *)plugin;
         recipe->parameters = sph_ifs_master_detector_flat_create_paramlist();
         if ( recipe->parameters == NULL ) {
             return SPH_IFS_MASTER_DETECTOR_FLAT_GENERAL;
         }
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Testing for setup of the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Wrapper to make the static plugin creation function accessible from outside
  for testing purposes.
  */
 /*----------------------------------------------------------------------------*/
 int sph_ifs_master_detector_flat_create_test(cpl_plugin * plugin)
 {
     return (int)sph_ifs_master_detector_flat_create_plugin(plugin);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Execute the plugin instance given by the interface
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_master_detector_flat_exec_plugin(cpl_plugin * plugin)
 {
 
     cpl_recipe*             recipe                  = NULL;
     cpl_error_code          recipe_code;
     sph_ifs_master_detector_flat*    sph_recipe      = NULL;
     cpl_errorstate          initial_errorstate      = cpl_errorstate_get();
 
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
         cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
         return (int)cpl_error_get_code();
     }
 
     recipe = (cpl_recipe *)plugin;
 
     if (recipe->parameters == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (recipe->frames == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     sph_recipe = sph_ifs_master_detector_flat_new( recipe->frames, recipe->parameters );
     if ( sph_recipe == NULL ) {
         recipe_code = cpl_error_set_where(cpl_func);
     } else {
 
         recipe_code = sph_ifs_master_detector_flat_run( sph_recipe );
 
         sph_ifs_master_detector_flat_delete( sph_recipe );
     }
 
     if ( !cpl_errorstate_is_equal(initial_errorstate) )
     {
         cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
     }
     sph_end_erex(); //close the sphere system
     return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                  ? CPL_ERROR_EOL : recipe_code);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Destroy what has been created by the 'create' function
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_master_detector_flat_destroy_plugin(cpl_plugin * plugin)
 {
     cpl_recipe * recipe;
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     recipe = (cpl_recipe *)plugin;
 
     cpl_parameterlist_delete(recipe->parameters);
 
     return 0;
 }
 
 /*****************************************************************************
  *
  *
  *      Here come the "Member" functions of the sph_ifs_master_detector_flat struct
  *
  *
  * ***************************************************************************/
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Fill a pre-allocated parameterlist for the recipe
  @param    result A pre-allocated parameterlist
  @return   CPL_ERROR_NONE iff successful
 
  This function fills the standard parameterlist for the recipe
 
  */
 /*----------------------------------------------------------------------------*/
 static cpl_error_code sph_ifs_master_detector_flat_fill_parameterlist(cpl_parameterlist * result)
 {
     cpl_parameter* p;
 
         /* Code to set up parameters GENERATED DO NOT EDIT */

         p = cpl_parameter_new_value("ifs.master_detector_flat.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the product. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"ifs.master_detector_flat",
                                    "master_detector_flat.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.save_addprod",
                                    CPL_TYPE_BOOL,
                                    "Flag signalling hwether additional products should be saved, "
                                    "in this case a large scale flat, a preamp flat, and a "
                                    "hot pixels product. "
                                    ,"ifs.master_detector_flat",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.lss_outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the large scale flat product. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"ifs.master_detector_flat",
                                    "large_scale_flat.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.preamp_outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the preamplifier flat product. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"ifs.master_detector_flat",
                                    "preamp_flat.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.make_badpix",
                                    CPL_TYPE_BOOL,
                                    "Controls if a seperate static badpixel map is requested for output. "
                                    ,"ifs.master_detector_flat",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.badpixfilename",
                                    CPL_TYPE_STRING,
                                    "Controls the filename of the badpixel map, if requested for output. Ignored if no make_badpix is FALSE.@pd "
                                    ,"ifs.master_detector_flat",
                                    "dff_badpixels.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.robust_fit",
                                    CPL_TYPE_BOOL,
                                    "Controls if fitting method is to be a robust linear fit. This will reduce the effect of cosmic "
                                    "rays and other temporary bad pixels. See e.g. Numerical Recipes for a description of the algorithm "
                                    ,"ifs.master_detector_flat",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("ifs.master_detector_flat.coll_alg",
                                    CPL_TYPE_INT,
                                    "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. "
                                    ,"ifs.master_detector_flat",
                                    2 ,
                                    3,0,1,2);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.master_detector_flat.clean_mean.reject_high",
                                    CPL_TYPE_INT,
                                    "The clean mean reject pixels on high end. "
                                    ,"ifs.master_detector_flat",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.master_detector_flat.clean_mean.reject_low",
                                    CPL_TYPE_INT,
                                    "The clean mean reject pixels on low end. "
                                    ,"ifs.master_detector_flat",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.badpix_lowtolerance",
                                    CPL_TYPE_DOUBLE,
                                    "Threshold value for linearity badpixels. "
                                    "All pixels that have a flat field (slope) below this value will be flagged as bad. "
                                    ,"ifs.master_detector_flat",
                                    0.1 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.badpix_uptolerance",
                                    CPL_TYPE_DOUBLE,
                                    "Threshold value for linearity badpixels. "
                                    "All pixels that have a flat field (slope) above this value will be flagged as bad. "
                                    ,"ifs.master_detector_flat",
                                    10.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.badpix_chisqtolerance",
                                    CPL_TYPE_DOUBLE,
                                    "Threshold value for linearity badpixels. All pixels that have chi-squared value for "
                                    "the linear fit that is above this value will be flagged as bad "
                                    ,"ifs.master_detector_flat",
                                    50.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.lambda",
                                    CPL_TYPE_DOUBLE,
                                    "If this is set to a value > 0, the resulting master flat will be assigned the given calibration wavelength. "
                                    "In case that there are corresponding keywords present in the input raw frames, these are ignored in this case. "
                                    ,"ifs.master_detector_flat",
                                    -1.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.master_detector_flat.smoothing_length",
                                    CPL_TYPE_DOUBLE,
                                    "The smooting length for the large scale flats. "
                                    ,"ifs.master_detector_flat",
                                    10.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("ifs.master_detector_flat.smoothing_method",
                                    CPL_TYPE_INT,
                                    "The smooting method to use: 0 is square kernel using cpl_filter, 1 gauss kernel using FFT. "
                                    ,"ifs.master_detector_flat",
                                    1 ,
                                    2,0,1);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return cpl_error_set_where(cpl_func);
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief  Create and return the standard parameterlist for the recipe
  @return The standard parameterlist or NULL on error
  @note   The returned object must be deallocated using cpl_parameterlist_delete
 
  */
 /*----------------------------------------------------------------------------*/
 cpl_parameterlist* sph_ifs_master_detector_flat_create_paramlist(void)
 {
     cpl_parameterlist* self = cpl_parameterlist_new();
 
     if (sph_ifs_master_detector_flat_fill_parameterlist(self)) {
         cpl_parameterlist_delete(self);
         self = NULL;
         (void)cpl_error_set_where(cpl_func);
     }
 
     return self;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe frames, and assign them to the sph_ifs_master_detector_flat
            structure.
  @param    self     the sph_ifs_master_detector_flat recipe structure
  @return   error code of the check.
 
  This checks the frames that were given in the sph_ifs_master_detector_flat_new function
  as parameters for the correctness and completeness. If the frames needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code  sph_ifs_master_detector_flat_check_frames( sph_ifs_master_detector_flat* self )
 {
     sph_error_code           rerr            = CPL_ERROR_NONE;
     /* Code to check frames GENERATED DO NOT EDIT */

     cpl_frame* aframe;
     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_RAW );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_DFF_RAW );
     if ( ! self->rawframes )
     {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_ERROR,
                          "Could not extract rawframes frames."
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_RAW);
         rerr = SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING;
         return rerr;
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->rawframes );
          if ( numframes < 2) {
              sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                  __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Not enough frames in frameset SPH_IFS_TAG_DFF_RAW. "
                  "Was expecting at least 2 but only got %d. ",
              numframes);
              return CPL_ERROR_ILLEGAL_INPUT;
          }
          for ( int ii = 0; ii < numframes; ++ii ) {
              cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
              const char* ifname = cpl_frame_get_filename(iframe);
              cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
              if (pl == NULL ) {
                  sph_error_raise(cpl_error_get_code(),
                     __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Could not read keywords from file %s. "
                  "Either the file is not readable or corrupted. ",
                   ifname);
              }
              else {
                  rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                  cpl_propertylist_delete(pl); pl=NULL;
              }
          }
          numframes -= (int)cpl_frameset_get_size( self->rawframes );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     if ( ! self->master_dark_frame )
     {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DARK_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_LSS_FLAT );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_lss_flat = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_LSS_FLAT );
     if ( ! self->master_lss_flat )
     {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_lss_flat frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_LSS_FLAT);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_lss_flat, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->preamp_flat = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
     if ( ! self->preamp_flat )
     {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract preamp_flat frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_PREAMP_FLAT);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->preamp_flat, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
     if ( ! self->static_badpixel_frame )
     {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract static_badpixel_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
     }

     /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );
 
     return rerr;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe parameters, and assign them to the sph_ifs_master_detector_flat
            structure.
  @param    self     the sph_ifs_master_detector_flat recipe structure
  @return   error code of the check.
 
  This checks the parameters that were given in the sph_ifs_master_detector_flat_new function
  as parameters for the correctness and completeness. If the parameters needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_master_detector_flat_check_params( sph_ifs_master_detector_flat* self ) {
     sph_error_code                 rerr               = CPL_ERROR_NONE;
     const cpl_parameter*           param              = NULL;
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
     self->framecomb_parameterlist = cpl_parameterlist_new();
     /* Code to check parameters GENERATED DO NOT EDIT */

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.outfilename");
     }

     self->outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.save_addprod");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.save_addprod");
     }

     self->save_addprod = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.lss_outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.lss_outfilename");
     }

     self->lss_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.preamp_outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.preamp_outfilename");
     }

     self->pream_outfilename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.make_badpix");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.make_badpix");
     }

     self->make_badpix = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.badpixfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.badpixfilename");
     }

     self->badpix_filename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.robust_fit");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.robust_fit");
     }

     self->robust_fit = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.coll_alg");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.coll_alg");
     }

     self->coll_alg = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.clean_mean.reject_high");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.clean_mean.reject_high");
     }

     self->clean_mean_reject_high = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_high",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.clean_mean.reject_low");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.clean_mean.reject_low");
     }

     self->clean_mean_reject_low = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_low",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.badpix_lowtolerance");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.badpix_lowtolerance");
     }

     self->badpix_lowtolerance = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.badpix_uptolerance");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.badpix_uptolerance");
     }

     self->badpix_uptolerance = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.badpix_chisqtolerance");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.badpix_chisqtolerance");
     }

     self->badpix_chisqtolerance = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.lambda");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.lambda");
     }

     self->lambda = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.smoothing_length");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.smoothing_length");
     }

     self->smoothl = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.master_detector_flat.smoothing_method");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.master_detector_flat.smoothing_method");
     }

     self->smooth_method = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return rerr;
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Create a new sph_ifs_master_detector_flat structure.
 
  @param    frameset     the input recipe frames
  @param    parlist      the input recipe parameters
 
  @return   pointer to newly created structure or NULL in case of error
 
  This creates a new sph_ifs_master_detector_flat_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_ifs_master_detector_flat* sph_ifs_master_detector_flat_new( cpl_frameset * frameset,
                                               cpl_parameterlist * parlist )
 {
     sph_ifs_master_detector_flat*    result      = NULL;
     int                     rerr        = CPL_ERROR_NONE;
 
     sph_init_erex();
     if ( frameset == NULL || parlist == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return NULL;
     }
 
     result = cpl_calloc( 1, sizeof(sph_ifs_master_detector_flat) );
 
     if ( result == NULL ) {
         sph_error_raise( SPH_IFS_MASTER_DETECTOR_FLAT_GENERAL, __FILE__, __func__,
                          __LINE__, SPH_ERROR_ERROR,
                          "Could not allocate the structure.");
         return result;
     }
 
     result->inframes = frameset;
     result->inparams = parlist;
 
     rerr = sph_ifs_master_detector_flat_check_frames( result );
     if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_master_detector_flat_check_params( result );
 
     if ( rerr != CPL_ERROR_NONE ) {
         if ( result ) {
             sph_ifs_master_detector_flat_delete( result );
         }
         result = NULL;
     }
 
     return result;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Delete the sph_ifs_master_detector_flat structure.
 
  @param    self         the structure tp delete
 
  @return   error code of the operation
 
  This creates a new sph_ifs_master_detector_flat_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_master_detector_flat_delete( sph_ifs_master_detector_flat* self )
 {
     sph_error_code          rerr            = CPL_ERROR_NONE;
 
     if ( self == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return rerr;
     }
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
 
     /* Code to delete recipe pointers GENERATED DO NOT EDIT */

     if ( self->rawframes != NULL ) {
         cpl_frameset_delete( self->rawframes );
         self->rawframes = NULL;
     }
     if ( self->master_dark_frame != NULL ) {
         cpl_frame_delete( self->master_dark_frame );
         self->master_dark_frame = NULL;
     }
     if ( self->master_lss_flat != NULL ) {
         cpl_frame_delete( self->master_lss_flat );
         self->master_lss_flat = NULL;
     }
     if ( self->preamp_flat != NULL ) {
         cpl_frame_delete( self->preamp_flat );
         self->preamp_flat = NULL;
     }
     if ( self->static_badpixel_frame != NULL ) {
         cpl_frame_delete( self->static_badpixel_frame );
         self->static_badpixel_frame = NULL;
     }
  
     /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     if ( self->current_raw_frameset ) {
         cpl_frameset_delete(self->current_raw_frameset);
         self->current_raw_frameset = NULL;
     }
     sph_polygon_free_all();
     cpl_free(    self);
     return rerr;
 
 }
 
 
 /**@}*/
 
