/***********************************************************************************************/
 /******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
 /***********************************************************************************************/

 /* $Id: $
  * This file is part of the SPHERE Pipeline
  * Copyright (C) 2007-2010 European Southern Observatory
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
 
 /*
  * $Author: $
  * $Date: $
  * $Revision: $
  * $Name: $
  */
 
 /*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/
 
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
 
 #include "sph_ifs_science_dr.h"
 #include "sph_common_keywords.h"
 #include "sph_ifs_keywords.h"
 #include "sph_ifs_tags.h"
 #include "sph_master_frame.h"
 #include "sph_error.h"
 #include "sph_cube.h"
 #include "sph_utils.h"
 
 #include <math.h>
 #include <assert.h>
 #include <cpl.h>
 
 /*-----------------------------------------------------------------------------
   Error Codes
  -----------------------------------------------------------------------------*/
 
 sph_error_code SPH_IFS_SCIENCE_DR_GENERAL              = SPH_IFS_SCIENCE_DR_ERR_START + 0;
 sph_error_code SPH_IFS_SCIENCE_DR_NO_VALID_DIT_LIST    = SPH_IFS_SCIENCE_DR_ERR_START + 1;
 
 sph_error_code SPH_IFS_SCIENCE_DR_PARAMETER_MISSING    = SPH_IFS_SCIENCE_DR_ERR_START + 3;
 sph_error_code SPH_IFS_SCIENCE_DR_FRAMES_MISSING       = SPH_IFS_SCIENCE_DR_ERR_START + 4;
 
 /*-----------------------------------------------------------------------------
  Private function prototypes
  -----------------------------------------------------------------------------*/
 
 static int sph_ifs_science_dr_create_plugin ( cpl_plugin * );
 static int sph_ifs_science_dr_exec_plugin ( cpl_plugin * );
 static int sph_ifs_science_dr_destroy_plugin ( cpl_plugin * );
 
 /*-----------------------------------------------------------------------------
  Static variables
  -----------------------------------------------------------------------------*/
 
 static const char* sph_ifs_science_dr_help = 
     "RECIPE INPUT FRAMES: \n"
     "-------------------- \n"
     "Tag                           Min,Max   Description\n"
     "IFS_SCIENCE_DR_RAW              1,500   The raw science frames\n"
     "IFS_MASTER_DFF_LONG1            0,  1   A long exposure flat frame taken with monochromatic light. Usually this should be\n"
     "                                        a large scale flat.\n"
     "IFS_MASTER_DFF_LONG2            0,  1   A long exposure flat frame taken with monochromatic light. Usually this should be\n"
     "                                        a large scale flat.\n"
     "IFS_MASTER_DFF_LONG3            0,  1   A long exposure flat frame taken with monochromatic light. Usually this should be\n"
     "                                        a large scale flat.\n"
     "IFS_MASTER_DFF_LONG4            0,  1   A long exposure flat frame taken with monochromatic light. Usually this should be\n"
     "                                        a large scale flat.\n"
     "IFS_MASTER_DFF_LONGBB           0,  1   A long exposure master flat frame taken with broad band light. This flat should\n"
     "                                        usually already be corrected for the large scale flat structure. NOT CURRENTLY USED!\n"
     "IFS_PREAMP_FLAT                 0,  1   A preamp correction flat. If provided the science frames are corrected for this\n"
     "                                        before applying other flats.\n"
     "IFS_MASTER_DFF_SHORT            0,  1   A short exposure master flat frame taken with broad band light. This flat\n"
     "                                        should under normal circumstances be corrected already by a large scale flat.\n"
     "                                        See the description of the master detector flat recipe for details.\n"
     "IFS_IFU_FLAT_FIELD              0,  1   Master IFU flat field (lenslet flat).\n"
     "IFS_CAL_BACKGROUND              0,  1   An optional master background frame for dark subtraction.\n"
     "IFS_MASTER_DARK                 0,  1   An optional master dark frame for dark subtraction.\n"
     "IFS_STATIC_BADPIXELMAP          0,  1   Optional static badpixel map.\n"
     "IFS_WAVECALIB                   1,  1   Wavelength calibration pixel description table.\n"
     "IFS_DISTORTION_MAP              0,  1   Frame giving the lenslet distortion map,\n"
     "                                        as obtained with the sph_ifs_distortion_map recipe.\n"
     "\n"
     "RAW FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Type   Optional  Description\n"
     "ESO INS2 DITH POSX            double Yes       The dithering position in X for the frame in pixels. \n"
     "ESO INS2 DITH POSY            double Yes       The dithering position in Y for the frame in pixels. \n"
     "\n"
     "DESCRIPTION:\n"
     "------------\n"
     "This is the science calibration recipe for IFS. The input raw observation\n"
     "frames are reduced by dark subtracting each one, if a master background or\n"
     "alternatively a master dark frame is given as input.\n"
     "Also, in case a pre-amplifier correction frame (basically for de-striping) the raw frames\n"
     "are corrected for the stripes.\n"
     "The large scale effects are then corrected by creating a so called super flat that combines the (large scale)\n"
     "flat fields taken with different colour lamps into a single flat field that takes the pixel to\n"
     "wavelength correspondence into account using the information from the input wavelength calibration\n"
     "file.\n"
     "\n"
     "After dividing out the super flat, a broad band flat field that should have been created from\n"
     "recent data is divded out to remove the (small scale) flat variations that are very time dependent.\n"
     "Note that this broad band master flat field should already be corrected for the large scale flat structure.\n"
     "This means it must have been created using the master flat field\n"
     "recipe with a large scale flat as input.\n"
     "\n"
     "The recipe allows automatic combination of images using the spec_deconv and simple_adi routines.\n"
     "These reduction steps can be selective switched on or off.\n"
     "To combine frames manually, the recipe the use_adi and spec_deconv flags should be set to false.\n"
     "\n"
     "Note that the ADI and spectral deconvolution routines currently use fixed parameters as noted.\n"
     "\n"
     "The correction of (detector pixel-to-pixel) correction can be switched on by the appropriate flag.\n"
     "It is strongly recommended to use only the small-scale correction.  The large-scale variant\n"
     "is a bit over-aggressive and deprecated.\n"
     "\n"
     "The correction of detector-level badpixels can also be switched on with a flag. This will interpolate\n"
     "over badpixels to substitute their values instead of relying on dithering.\n"
     "RECIPE PRODUCTS: \n"
     "-------------------- \n"
     "Tag                      Format         Description\n"
     "IFS_SCIENCE_DR                     FITS[Imcube(4)]The reduced science data as a wavelength cube.\n"
     "\n"
     "PRODUCT FRAME KEYWORDS: \n"
     "-------------------- \n"
     "Keyword                       Frame          Type    Description\n"
     "\n"
 ;
 
 /*-----------------------------------------------------------------------------
  Function code
  -----------------------------------------------------------------------------*/
 /*----------------------------------------------------------------------------*/
 /**
  * @defgroup sph_ifs_science_dr Create Master Dark Recipe
  *
  * This module provides the recipe plugin and relating functions for the
  * creation of the master dark .
  *
  * @par Synopsis:
  * @code
  *   #include "sph_ifs_science_dr.h"
  * @endcode
  */
 /*----------------------------------------------------------------------------*/
 /**@{*/
 
 /*****************************************************************************
  *
  *
  *      First come the static and global functions necessary for the
  *      normal working of the recipe as plugin....
  *
  *
  * ***************************************************************************/
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Build the list of available plugins, for this module.
  @param    list    the plugin list
  @return   0 if everything is ok, 1 otherwise
  @note     Only this function is exported
 
  Create the recipe instance and make it available to the application
  using the interface.
  */
 /*----------------------------------------------------------------------------*/
 int cpl_plugin_get_info(cpl_pluginlist * list)
 {
     cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
     cpl_plugin * plugin = &recipe->interface;
 
     if (cpl_plugin_init(plugin,
                         CPL_PLUGIN_API,
                         SPH_IFS_SCIENCE_DR_VERSION,
                         CPL_PLUGIN_TYPE_RECIPE,
                         "sph_ifs_science_dr",
                         "Reduce science observations",
                         sph_ifs_science_dr_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                         "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                         sph_ifs_science_dr_create_plugin,
                         sph_ifs_science_dr_exec_plugin,
                         sph_ifs_science_dr_destroy_plugin) )
     {
         cpl_msg_error( cpl_func, "Plugin initialization failed");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
 
     if (cpl_pluginlist_append(list, plugin) )
     {
         cpl_msg_error( cpl_func, "Error adding plugin to list");
         (void)cpl_error_set_where( cpl_func );
         return 1;
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Setup the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Defining the command-line/configuration parameters for the recipe.
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_science_dr_create_plugin(cpl_plugin * plugin)
 {
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                        cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error(cpl_func, "Null plugin");
         cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     if ( plugin != NULL ) {
         cpl_recipe * recipe = (cpl_recipe *)plugin;
         recipe->parameters = sph_ifs_science_dr_create_paramlist();
         if ( recipe->parameters == NULL ) {
             return SPH_IFS_SCIENCE_DR_GENERAL;
         }
     }
     return 0;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Testing for setup of the recipe options
  @param    plugin  the plugin
  @return   0 if everything is ok
 
  Wrapper to make the static plugin creation function accessible from outside
  for testing purposes.
  */
 /*----------------------------------------------------------------------------*/
 int sph_ifs_science_dr_create_test(cpl_plugin * plugin)
 {
     return (int)sph_ifs_science_dr_create_plugin(plugin);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Execute the plugin instance given by the interface
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_science_dr_exec_plugin(cpl_plugin * plugin)
 {
 
     cpl_recipe*             recipe                  = NULL;
     cpl_error_code          recipe_code;
     sph_ifs_science_dr*    sph_recipe      = NULL;
     cpl_errorstate          initial_errorstate      = cpl_errorstate_get();
 
     if (cpl_error_get_code() != CPL_ERROR_NONE)
     {
         cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
         cpl_func, __LINE__, cpl_error_get_where());
         return (int)cpl_error_get_code();
     }
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
         return (int)cpl_error_get_code();
     }
 
     recipe = (cpl_recipe *)plugin;
 
     if (recipe->parameters == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     if (recipe->frames == NULL)
     {
         cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
         return (int)cpl_error_get_code();
     }
 
     sph_recipe = sph_ifs_science_dr_new( recipe->frames, recipe->parameters );
     if ( sph_recipe == NULL ) {
         recipe_code = cpl_error_set_where(cpl_func);
     } else {
 
         recipe_code = sph_ifs_science_dr_run( sph_recipe );
 
         sph_ifs_science_dr_delete( sph_recipe );
     }
 
     if ( !cpl_errorstate_is_equal(initial_errorstate) )
     {
         cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
     }
     sph_end_erex(); //close the sphere system
     return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                  ? CPL_ERROR_EOL : recipe_code);
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Destroy what has been created by the 'create' function
  @param    plugin  the plugin
  @return   0 if everything is ok
  */
 /*----------------------------------------------------------------------------*/
 static int sph_ifs_science_dr_destroy_plugin(cpl_plugin * plugin)
 {
     cpl_recipe * recipe;
 
     if (plugin == NULL)
     {
         cpl_msg_error( cpl_func, "Null plugin");
         cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
     }
 
     if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
     {
         cpl_msg_error( cpl_func, "Plugin is not a recipe");
         cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
     }
 
     recipe = (cpl_recipe *)plugin;
 
     cpl_parameterlist_delete(recipe->parameters);
 
     return 0;
 }
 
 /*****************************************************************************
  *
  *
  *      Here come the "Member" functions of the sph_ifs_science_dr struct
  *
  *
  * ***************************************************************************/
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Fill a pre-allocated parameterlist for the recipe
  @param    result A pre-allocated parameterlist
  @return   CPL_ERROR_NONE iff successful
 
  This function fills the standard parameterlist for the recipe
 
  */
 /*----------------------------------------------------------------------------*/
 static cpl_error_code sph_ifs_science_dr_fill_parameterlist(cpl_parameterlist * result)
 {
     cpl_parameter* p;
 
         /* Code to set up parameters GENERATED DO NOT EDIT */

         p = cpl_parameter_new_value("ifs.science_dr.outfilename",
                                    CPL_TYPE_STRING,
                                    "The output filename for the product. Please also see the esorex documentation "
                                    "for naming of output products. "
                                    ,"ifs.science_dr",
                                    "ifs_science_dr.fits" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("ifs.science_dr.coll_alg",
                                    CPL_TYPE_INT,
                                    "The collapse algorithm to use when creating a product with ADI. 0 = Mean, 1 = Median, 3 = Weighted mean. "
                                    ,"ifs.science_dr",
                                    3 ,
                                    3,0,1,3);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.science_dr.clean_mean.reject_high",
                                    CPL_TYPE_INT,
                                    "The clean mean reject pixels on high end. Not currently used. "
                                    ,"ifs.science_dr",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.science_dr.clean_mean.reject_low",
                                    CPL_TYPE_INT,
                                    "The clean mean reject pixels on low end. Not currently used. "
                                    ,"ifs.science_dr",
                                    0 ,
                                    0,20);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.use_illumination",
                                    CPL_TYPE_BOOL,
                                    "Controls if the illumination pattern of lenslets is to be taken into "
                                    "account in the cube creation or not. A low level wave-like structure "
                                    "can appear in the result if it is not applied. However, calculation of "
                                    "of the illumination fraction affects the performance of the recipe and "
                                    "so this option should only be enabled if the artefacts adversely affect "
                                    "the results. Note that there is a corresponding option on the ifs_instrument_flat "
                                    "recipe which should match the chosen option here. "
                                    ,"ifs.science_dr",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_enum("ifs.science_dr.use_adi",
                                    CPL_TYPE_INT,
                                    "Use of ADI. If set to 0 angular differential imaging is not applied. If set to 1 then ADI is always applied if it is set to 2 then ADI is applied only of the total rotation in the input frames is larger than the angle given in the ifs.science_dr.min_adi_angle parameter. "
                                    "Note that the parameters to the ADI algorithm are fixed - it uses an FFT transform with no filter. "
                                    ,"ifs.science_dr",
                                    2 ,
                                    3,0,1,2);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.min_adi_angle",
                                    CPL_TYPE_DOUBLE,
                                    "Minimum angle for automatic ADI switch. When use_adi is set to automatic then the ADI is used iff the total rotation angle covered over the whole input is larger than the given value. "
                                    ,"ifs.science_dr",
                                    4.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.spec_deconv",
                                    CPL_TYPE_BOOL,
                                    "If set to true, spectra deconvolution is used to combine the cubes. "
                                    ,"ifs.science_dr",
                                    1 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.spec_deconv_filename",
                                    CPL_TYPE_STRING,
                                    "The basename for the spectra deconvolution output files (without the .fits extension). Files will be named using a running number. "
                                    ,"ifs.science_dr",
                                    "ifs_spec_deconv" );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_range("ifs.science_dr.order",
                                    CPL_TYPE_INT,
                                    "The order of the polynomial fit to be subtracted. [Currently fixed at 5 when ifs.science_dr.spec_deconv = TRUE] "
                                    ,"ifs.science_dr",
                                    2 ,
                                    1,10);

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.user_cent",
                                    CPL_TYPE_BOOL,
                                    "If set to true, the user supplied center values are used, overriding the internally derived centers. "
                                    "[Currently fixed at FALSE when ifs.science_dr.spec_deconv = TRUE] "
                                    ,"ifs.science_dr",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.cx",
                                    CPL_TYPE_DOUBLE,
                                    "If user_cent set to TRUE, this is the centre x coordinate to use. Coordinates are in FITS coords, so "
                                    "that the centre of a 291 times 291 pixel image is at 146.0,146.0. "
                                    "Unused if ifs.science_dr.spec_deconv = TRUE as user_cent is then fixed to FALSE. "
                                    ,"ifs.science_dr",
                                    146.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.cy",
                                    CPL_TYPE_DOUBLE,
                                    "If user_cent set to TRUE, this is the centre y coordinate to use. Coordinates are in FITS coords, so "
                                    "that the centre of a 291 times 291 pixel image is at 146.0,146.0. "
                                    "Unused if ifs.science_dr.spec_deconv = TRUE as user_cent is then fixed to FALSE. "
                                    ,"ifs.science_dr",
                                    146.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.reflambda",
                                    CPL_TYPE_DOUBLE,
                                    "The reference wavelength to use. Be careful with this parameter since the quality of the "
                                    "FFT scaling depends on this parameter. Scaling quality is generally better when choosing "
                                    "a value for the reference wavelength at the higher end of the specta range. "
                                    "[Currently fixed at 1.0 when ifs.science_dr.spec_deconv = TRUE] "
                                    ,"ifs.science_dr",
                                    1.3 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.fwhm",
                                    CPL_TYPE_DOUBLE,
                                    "A smoothing FWHM that will be used to improve the cosmetics. Smoothing "
                                    "is disabled if the parameter is 0 or negative. "
                                    "[Currently fixed at 2.0 when ifs.science_dr.spec_deconv = TRUE] "
                                    ,"ifs.science_dr",
                                    -1.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.badpixco.apply",
                                    CPL_TYPE_BOOL,
                                    "Flag to set the application of the automatic badpixel correction "
                                    ,"ifs.science_dr",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.apply",
                                    CPL_TYPE_BOOL,
                                    "Flag to set the application of the cross talk correction "
                                    ,"ifs.science_dr",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.largescale.apply",
                                    CPL_TYPE_BOOL,
                                    "Flag to set the application of the large scale crosstalk correction. If set to false, "
                                    "only the small-scalecrosstalk gets corrected which usually yields better results. "
                                    ,"ifs.science_dr",
                                    0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.sepmax",
                                    CPL_TYPE_INT,
                                    "The sliding correction window half-size (the window size is 2 * sepmax + 1) "
                                    ,"ifs.science_dr",
                                    20 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.bfac",
                                    CPL_TYPE_DOUBLE,
                                    "The parameter bfactor in the small talk cross talk correction. To correct values, the central subwindow pixel value times 1.0/(1.0 + pow(rdist/bfac,powfac)) is subtracted, with rdist the pixel distance to the central subwindow pixel. "
                                    ,"ifs.science_dr",
                                    0.40443667 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.powfac",
                                    CPL_TYPE_DOUBLE,
                                    "The parameter powfac in the small talk cross talk correction. To correct values, the central subwindow pixel value times 1.0/(1.0 + pow(rdist/bfac,powfac)) is subtracted, with rdist the pixel distance to the central subwindow pixel. "
                                    ,"ifs.science_dr",
                                    3.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.lgscalewin",
                                    CPL_TYPE_INT,
                                    "The large scale cross talk correction subwindow size. "
                                    ,"ifs.science_dr",
                                    64 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.threshold",
                                    CPL_TYPE_DOUBLE,
                                    "The large scale crosstalk correction threshold to use. Any values that are in between -threshold and +threshold will be set to the median image value. "
                                    ,"ifs.science_dr",
                                    50000.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.smoothing",
                                    CPL_TYPE_DOUBLE,
                                    "The large scale crosstalk correction threshold smoothing fwhm to use, This is used to to smooth the image before subtracting from the original. "
                                    ,"ifs.science_dr",
                                    100.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.xtalkco.stephist",
                                    CPL_TYPE_DOUBLE,
                                    "The bin size to use for the creation of the pixel histogram for the most likely value find. The most likely value is found in each subwindow and the smmothed version of these subtracted from the originial. "
                                    ,"ifs.science_dr",
                                    20.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.badpixco.threshold",
                                    CPL_TYPE_DOUBLE,
                                    "The absolute threshold for badpixel correction to use. This is applied in a logical AND operation with the badpixel correction factor threshold. Any pixels above this value, that are also above badpixco.fac * median, are set to the median of the surrounding 8 pixels. "
                                    ,"ifs.science_dr",
                                    100.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.badpixco.fac",
                                    CPL_TYPE_DOUBLE,
                                    "The absolute threshold factor for badpixel correction to use. This is applied in a logical AND operation with the absolute badpixel correction threshold. Any pixels above badpixco.fac * median AND also above the absolute threshold, are set to the median of the surrounding 8 pixels. "
                                    ,"ifs.science_dr",
                                    5.0 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         p = cpl_parameter_new_value("ifs.science_dr.badpixco.border",
                                    CPL_TYPE_INT,
                                    "The border size in pixel to ignore for the purpose of badpixel correction. "
                                    ,"ifs.science_dr",
                                    100 );

         cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
         cpl_parameterlist_append(result, p);
         /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return cpl_error_set_where(cpl_func);
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief  Create and return the standard parameterlist for the recipe
  @return The standard parameterlist or NULL on error
  @note   The returned object must be deallocated using cpl_parameterlist_delete
 
  */
 /*----------------------------------------------------------------------------*/
 cpl_parameterlist* sph_ifs_science_dr_create_paramlist(void)
 {
     cpl_parameterlist* self = cpl_parameterlist_new();
 
     if (sph_ifs_science_dr_fill_parameterlist(self)) {
         cpl_parameterlist_delete(self);
         self = NULL;
         (void)cpl_error_set_where(cpl_func);
     }
 
     return self;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe frames, and assign them to the sph_ifs_science_dr
            structure.
  @param    self     the sph_ifs_science_dr recipe structure
  @return   error code of the check.
 
  This checks the frames that were given in the sph_ifs_science_dr_new function
  as parameters for the correctness and completeness. If the frames needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code  sph_ifs_science_dr_check_frames( sph_ifs_science_dr* self )
 {
     sph_error_code           rerr            = CPL_ERROR_NONE;
     /* Code to check frames GENERATED DO NOT EDIT */

     cpl_frame* aframe;
     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_SCIENCE_DR_RAW );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->raw_science_frameset = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_SCIENCE_DR_RAW );
     if ( ! self->raw_science_frameset )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_ERROR,
                          "Could not extract raw_science_frameset frames."
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_SCIENCE_DR_RAW);
         rerr = SPH_IFS_SCIENCE_DR_FRAMES_MISSING;
         return rerr;
     }

     else {

          int numframes = (int)cpl_frameset_get_size( self->raw_science_frameset );
          for ( int ii = 0; ii < numframes; ++ii ) {
              cpl_frame* iframe = cpl_frameset_get_position( self->raw_science_frameset, ii );
              const char* ifname = cpl_frame_get_filename(iframe);
              cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
              if (pl == NULL ) {
                  sph_error_raise(cpl_error_get_code(),
                     __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Could not read keywords from file %s. "
                  "Either the file is not readable or corrupted. ",
                   ifname);
              }
              else {
                  rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                  cpl_propertylist_delete(pl); pl=NULL;
              }
          }
          numframes -= (int)cpl_frameset_get_size( self->raw_science_frameset );
          assert( numframes == 0);
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG1_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_long1_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG1_CALIB );
     if ( ! self->master_dff_long1_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_long1_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_LONG1_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_long1_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_long2_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
     if ( ! self->master_dff_long2_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_long2_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_LONG2_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_long2_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_long3_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
     if ( ! self->master_dff_long3_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_long3_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_LONG3_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_long3_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_long4_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
     if ( ! self->master_dff_long4_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_long4_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_LONG4_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_long4_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_longbb_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
     if ( ! self->master_dff_longbb_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_longbb_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_LONGBB_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_longbb_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->preamp_flat = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
     if ( ! self->preamp_flat )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract preamp_flat frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_PREAMP_FLAT);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->preamp_flat, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dff_short_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
     if ( ! self->master_dff_short_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dff_short_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DFF_SHORT_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dff_short_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_IFU_FLAT_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_ifu_flat_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_IFU_FLAT_CALIB );
     if ( ! self->master_ifu_flat_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_ifu_flat_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_IFU_FLAT_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_ifu_flat_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_background_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
     if ( ! self->master_background_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_background_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_CAL_BACKGROUND_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_background_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
     if ( ! self->master_dark_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract master_dark_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DARK_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
     if ( ! self->static_badpixel_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract static_badpixel_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->wave_calib_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
     if ( ! self->wave_calib_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_ERROR,
                          "Could not extract wave_calib_frame frames."
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_WAVE_CALIB_CALIB);
         rerr = SPH_IFS_SCIENCE_DR_FRAMES_MISSING;
         return rerr;
     }

     else {

          rerr = cpl_frame_set_group( self->wave_calib_frame, CPL_FRAME_GROUP_CALIB );
     }

     aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DISTORTION_MAP_CALIB );
     while ( aframe ) {
         cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
         aframe = cpl_frameset_find( self->inframes, NULL );
     }
     self->lenslet_distortion_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DISTORTION_MAP_CALIB );
     if ( ! self->lenslet_distortion_frame )
     {
         sph_error_raise( SPH_IFS_SCIENCE_DR_FRAMES_MISSING,
                          __FILE__, __func__, __LINE__ ,
                          SPH_ERROR_INFO,
                          "Could not extract lenslet_distortion_frame frames."
                          "Since this is an optional frame, this is ok "
                          "and this message is just informational. If you intended, "
                          "to use them check that they have the %s tag.",
                          SPH_IFS_TAG_DISTORTION_MAP_CALIB);
         cpl_error_reset();
     }

     else {

          rerr = cpl_frame_set_group( self->lenslet_distortion_frame, CPL_FRAME_GROUP_CALIB );
     }

     /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );
 
     return rerr;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Check the recipe parameters, and assign them to the sph_ifs_science_dr
            structure.
  @param    self     the sph_ifs_science_dr recipe structure
  @return   error code of the check.
 
  This checks the parameters that were given in the sph_ifs_science_dr_new function
  as parameters for the correctness and completeness. If the parameters needed are
  found they are also assigned to the corresponding structure members.
 
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_science_dr_check_params( sph_ifs_science_dr* self ) {
     sph_error_code                 rerr               = CPL_ERROR_NONE;
     const cpl_parameter*           param              = NULL;
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
     self->framecomb_parameterlist = cpl_parameterlist_new();
     /* Code to check parameters GENERATED DO NOT EDIT */

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.outfilename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.outfilename");
     }

     self->science_dr_filename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.coll_alg");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.coll_alg");
     }

     self->coll_alg = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.clean_mean.reject_high");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.clean_mean.reject_high");
     }

     self->clean_mean_reject_high = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_high",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.clean_mean.reject_low");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.clean_mean.reject_low");
     }

     self->clean_mean_reject_low = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     cpl_parameterlist_append( self->framecomb_parameterlist,
                               cpl_parameter_new_range( "clean_mean.reject_low",
                                                        CPL_TYPE_INT,
                                                        NULL,
                                                        NULL,
                                                        cpl_parameter_get_int( param ) ,
                                                        0,20
                                                       )
                             );

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.use_illumination");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.use_illumination");
     }

     self->use_illum = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.use_adi");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.use_adi");
     }

     self->use_adi = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.min_adi_angle");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.min_adi_angle");
     }

     self->min_adi_angle = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.spec_deconv");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.spec_deconv");
     }

     self->spec_deconv = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.spec_deconv_filename");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.spec_deconv_filename");
     }

     self->spec_deconv_filename = cpl_parameter_get_string(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.order");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.order");
     }

     self->order = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.user_cent");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.user_cent");
     }

     self->user_cent = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.cx");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.cx");
     }

     self->cx = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.cy");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.cy");
     }

     self->cy = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.reflambda");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.reflambda");
     }

     self->reflambda = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.fwhm");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.fwhm");
     }

     self->smooth_fwhm = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.badpixco.apply");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.badpixco.apply");
     }

     self->badpixcoapply = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.apply");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.apply");
     }

     self->xtalkapply = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.largescale.apply");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.largescale.apply");
     }

     self->xtalklsapply = cpl_parameter_get_bool(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.sepmax");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.sepmax");
     }

     self->sepmax = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.bfac");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.bfac");
     }

     self->bfac = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.powfac");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.powfac");
     }

     self->powfac = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.lgscalewin");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.lgscalewin");
     }

     self->lgscalewin = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.threshold");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.threshold");
     }

     self->threshold = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.smoothing");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.smoothing");
     }

     self->smoothing = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.xtalkco.stephist");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.xtalkco.stephist");
     }

     self->stephist = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.badpixco.threshold");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.badpixco.threshold");
     }

     self->badpix_threshold = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.badpixco.fac");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.badpixco.fac");
     }

     self->badpix_fac = cpl_parameter_get_double(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     param = cpl_parameterlist_find_const( self->inparams,
                                           "ifs.science_dr.badpixco.border");
     if (param == NULL) {
         return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                      "Recipe parameter missing: "
                                      "ifs.science_dr.badpixco.border");
     }

     self->badpix_border = cpl_parameter_get_int(param);
     if (cpl_error_get_code()) {
         return cpl_error_set_where(cpl_func);
     }

     /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
 
     return rerr;
 }
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Create a new sph_ifs_science_dr structure.
 
  @param    frameset     the input recipe frames
  @param    parlist      the input recipe parameters
 
  @return   pointer to newly created structure or NULL in case of error
 
  This creates a new sph_ifs_science_dr_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_ifs_science_dr* sph_ifs_science_dr_new( cpl_frameset * frameset,
                                               cpl_parameterlist * parlist )
 {
     sph_ifs_science_dr*    result      = NULL;
     int                     rerr        = CPL_ERROR_NONE;
 
     sph_init_erex();
     if ( frameset == NULL || parlist == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return NULL;
     }
 
     result = cpl_calloc( 1, sizeof(sph_ifs_science_dr) );
 
     if ( result == NULL ) {
         sph_error_raise( SPH_IFS_SCIENCE_DR_GENERAL, __FILE__, __func__,
                          __LINE__, SPH_ERROR_ERROR,
                          "Could not allocate the structure.");
         return result;
     }
 
     result->inframes = frameset;
     result->inparams = parlist;
 
     rerr = sph_ifs_science_dr_check_frames( result );
     if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_science_dr_check_params( result );
 
     if ( rerr != CPL_ERROR_NONE ) {
         if ( result ) {
             sph_ifs_science_dr_delete( result );
         }
         result = NULL;
     }
 
     return result;
 }
 
 /*----------------------------------------------------------------------------*/
 /**
  @brief    Delete the sph_ifs_science_dr structure.
 
  @param    self         the structure tp delete
 
  @return   error code of the operation
 
  This creates a new sph_ifs_science_dr_structure and fills the inparams and
  inframes fields with the pointers pf frameset and parlist.
  The return value is the error code of the check.
  */
 /*----------------------------------------------------------------------------*/
 sph_error_code sph_ifs_science_dr_delete( sph_ifs_science_dr* self )
 {
     sph_error_code          rerr            = CPL_ERROR_NONE;
 
     if ( self == NULL ) {
         sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                          __func__, __LINE__,
                          SPH_ERROR_ERROR,
                          "Null input pointer.");
         return rerr;
     }
 
     if ( self->framecomb_parameterlist != NULL ) {
         cpl_parameterlist_delete( self->framecomb_parameterlist );
         self->framecomb_parameterlist = NULL;
     }
 
     /* Code to delete recipe pointers GENERATED DO NOT EDIT */

     if ( self->raw_science_frameset != NULL ) {
         cpl_frameset_delete( self->raw_science_frameset );
         self->raw_science_frameset = NULL;
     }
     if ( self->master_dff_long1_frame != NULL ) {
         cpl_frame_delete( self->master_dff_long1_frame );
         self->master_dff_long1_frame = NULL;
     }
     if ( self->master_dff_long2_frame != NULL ) {
         cpl_frame_delete( self->master_dff_long2_frame );
         self->master_dff_long2_frame = NULL;
     }
     if ( self->master_dff_long3_frame != NULL ) {
         cpl_frame_delete( self->master_dff_long3_frame );
         self->master_dff_long3_frame = NULL;
     }
     if ( self->master_dff_long4_frame != NULL ) {
         cpl_frame_delete( self->master_dff_long4_frame );
         self->master_dff_long4_frame = NULL;
     }
     if ( self->master_dff_longbb_frame != NULL ) {
         cpl_frame_delete( self->master_dff_longbb_frame );
         self->master_dff_longbb_frame = NULL;
     }
     if ( self->preamp_flat != NULL ) {
         cpl_frame_delete( self->preamp_flat );
         self->preamp_flat = NULL;
     }
     if ( self->master_dff_short_frame != NULL ) {
         cpl_frame_delete( self->master_dff_short_frame );
         self->master_dff_short_frame = NULL;
     }
     if ( self->master_ifu_flat_frame != NULL ) {
         cpl_frame_delete( self->master_ifu_flat_frame );
         self->master_ifu_flat_frame = NULL;
     }
     if ( self->master_background_frame != NULL ) {
         cpl_frame_delete( self->master_background_frame );
         self->master_background_frame = NULL;
     }
     if ( self->master_dark_frame != NULL ) {
         cpl_frame_delete( self->master_dark_frame );
         self->master_dark_frame = NULL;
     }
     if ( self->static_badpixel_frame != NULL ) {
         cpl_frame_delete( self->static_badpixel_frame );
         self->static_badpixel_frame = NULL;
     }
     if ( self->wave_calib_frame != NULL ) {
         cpl_frame_delete( self->wave_calib_frame );
         self->wave_calib_frame = NULL;
     }
     if ( self->lenslet_distortion_frame != NULL ) {
         cpl_frame_delete( self->lenslet_distortion_frame );
         self->lenslet_distortion_frame = NULL;
     }
  
     /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
     if ( self->current_raw_frameset ) {
         cpl_frameset_delete(self->current_raw_frameset);
         self->current_raw_frameset = NULL;
     }
     sph_polygon_free_all();
     cpl_free(    self);
     return rerr;
 
 }
 
 
 /**@}*/
 
