/***********************************************************************************************/
 /******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
 /***********************************************************************************************/

 /* $Id: $
  * This file is part of the SPHERE Pipeline
  * Copyright (C) 2007-2010 European Southern Observatory
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
 
 /*
  * $Author: $
  * $Date: $
  * $Revision: $
  * $Name: $
  */
 
 #include "sph_error.h"
 #include "sph_cube.h"
 #include "sph_pixel_description_table.h"
 #include "sph_ldt.h"
 #include "sph_master_frame.h"
 #include "sph_double_image.h"
 #include "sph_triple_image.h"
 #include "sph_quad_image.h"
 #include "sph_zpl_exposure.h"
 #include "sph_zpl_exposure_imaging.h"
 #include "sph_pixel_polyfit_table.h"
 #include "sph_ird_instrument_model.h"
 #include "sph_fctable.h"
 #include "sph_zpl_science_pol_product.h"
 #include <cpl.h>
 #include <config.h>
 
 #ifndef SPH_IFS_SCIENCE_DR_H_
 
 #define SPH_IFS_SCIENCE_DR_H_
 #define SPH_IFS_SCIENCE_DR_VERSION SPHERE_REC_VERSIONS
 
 /*-------------------------------------------------------------------------------
  * The Structure Definition
  * 
  * This structure contains the members of the sph_ifs_science_dr that are 
  * needed by the various methods.
  * 
  * ------------------------------------------------------------------------------
  */
 
 typedef struct _sph_ifs_science_dr_ {
     cpl_frameset*                   inframes                              ; /* The recipe input frames */

     cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

     cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

     cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

     const char*                     science_dr_filename                   ; /* The parameter of ifs.science_dr.outfilename */

     int                             coll_alg                              ; /* The parameter of ifs.science_dr.coll_alg */

     int                             clean_mean_reject_high                ; /* The parameter of ifs.science_dr.clean_mean.reject_high */

     int                             clean_mean_reject_low                 ; /* The parameter of ifs.science_dr.clean_mean.reject_low */

     short                           use_illum                             ; /* The parameter of ifs.science_dr.use_illumination */

     int                             use_adi                               ; /* The parameter of ifs.science_dr.use_adi */

     double                          min_adi_angle                         ; /* The parameter of ifs.science_dr.min_adi_angle */

     short                           spec_deconv                           ; /* The parameter of ifs.science_dr.spec_deconv */

     const char*                     spec_deconv_filename                  ; /* The parameter of ifs.science_dr.spec_deconv_filename */

     int                             order                                 ; /* The parameter of ifs.science_dr.order */

     short                           user_cent                             ; /* The parameter of ifs.science_dr.user_cent */

     double                          cx                                    ; /* The parameter of ifs.science_dr.cx */

     double                          cy                                    ; /* The parameter of ifs.science_dr.cy */

     double                          reflambda                             ; /* The parameter of ifs.science_dr.reflambda */

     double                          smooth_fwhm                           ; /* The parameter of ifs.science_dr.fwhm */

     short                           badpixcoapply                         ; /* The parameter of ifs.science_dr.badpixco.apply */

     short                           xtalkapply                            ; /* The parameter of ifs.science_dr.xtalkco.apply */

     short                           xtalklsapply                          ; /* The parameter of ifs.science_dr.xtalkco.largescale.apply */

     int                             sepmax                                ; /* The parameter of ifs.science_dr.xtalkco.sepmax */

     double                          bfac                                  ; /* The parameter of ifs.science_dr.xtalkco.bfac */

     double                          powfac                                ; /* The parameter of ifs.science_dr.xtalkco.powfac */

     int                             lgscalewin                            ; /* The parameter of ifs.science_dr.xtalkco.lgscalewin */

     double                          threshold                             ; /* The parameter of ifs.science_dr.xtalkco.threshold */

     double                          smoothing                             ; /* The parameter of ifs.science_dr.xtalkco.smoothing */

     double                          stephist                              ; /* The parameter of ifs.science_dr.xtalkco.stephist */

     double                          badpix_threshold                      ; /* The parameter of ifs.science_dr.badpixco.threshold */

     double                          badpix_fac                            ; /* The parameter of ifs.science_dr.badpixco.fac */

     int                             badpix_border                         ; /* The parameter of ifs.science_dr.badpixco.border */

     cpl_frameset*                   raw_science_frameset                  ; /* The IFS_SCIENCE_DR_RAW frames */

     cpl_frame*                      master_dff_long1_frame                ; /* The IFS_MASTER_DFF_LONG1 frames */

     cpl_frame*                      master_dff_long2_frame                ; /* The IFS_MASTER_DFF_LONG2 frames */

     cpl_frame*                      master_dff_long3_frame                ; /* The IFS_MASTER_DFF_LONG3 frames */

     cpl_frame*                      master_dff_long4_frame                ; /* The IFS_MASTER_DFF_LONG4 frames */

     cpl_frame*                      master_dff_longbb_frame               ; /* The IFS_MASTER_DFF_LONGBB frames */

     cpl_frame*                      preamp_flat                           ; /* The IFS_PREAMP_FLAT frames */

     cpl_frame*                      master_dff_short_frame                ; /* The IFS_MASTER_DFF_SHORT frames */

     cpl_frame*                      master_ifu_flat_frame                 ; /* The IFS_IFU_FLAT_FIELD frames */

     cpl_frame*                      master_background_frame               ; /* The IFS_CAL_BACKGROUND frames */

     cpl_frame*                      master_dark_frame                     ; /* The IFS_MASTER_DARK frames */

     cpl_frame*                      static_badpixel_frame                 ; /* The IFS_STATIC_BADPIXELMAP frames */

     cpl_frame*                      wave_calib_frame                      ; /* The IFS_WAVECALIB frames */

     cpl_frame*                      lenslet_distortion_frame              ; /* The IFS_DISTORTION_MAP frames */

 } sph_ifs_science_dr;
 
 /*-------------------------------------------------------------------------------
  * Error codes
  * 
  * Below the various error codes for this module are declared.
  * ------------------------------------------------------------------------------
  */
 
 int sph_ifs_science_dr_create_test(cpl_plugin *);
 
 
 /*-------------------------------------------------------------------------------
  * The methods
  * 
  * These are the methods for sph_ifs_science_dr.
  * 
  * ------------------------------------------------------------------------------
  */
 
 sph_ifs_science_dr* sph_ifs_science_dr_new( cpl_frameset * frameset, 
                                               cpl_parameterlist * parlist);
 
 sph_error_code  sph_ifs_science_dr_check_frames( sph_ifs_science_dr* self );
 
 sph_error_code sph_ifs_science_dr_check_params( sph_ifs_science_dr* parlist );
 
 cpl_error_code sph_ifs_science_dr_run( sph_ifs_science_dr* self );
 
 sph_error_code sph_ifs_science_dr_delete( sph_ifs_science_dr* self );
 cpl_parameterlist*  sph_ifs_science_dr_create_paramlist(void) CPL_ATTR_ALLOC;
 
 /* Extra function declarations that are defined in sph_ifs_science_dr.c */

 
 /* End of extra function declarations that are defined in sph_ifs_science_dr_run.c */

 
 
 #endif /*SPH_IFS_SCIENCE_DR_H_*/
 