/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IFS_SPECTRA_POSITIONS_H_

#define SPH_IFS_SPECTRA_POSITIONS_H_
#define SPH_IFS_SPECTRA_POSITIONS_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ifs_spectra_positions that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ifs_spectra_positions_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     spectra_positions_filename            ; /* The parameter of ifs.spectra_positions.outfilename */

    int                             coll_alg                              ; /* The parameter of ifs.spectra_positions.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ifs.spectra_positions.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ifs.spectra_positions.clean_mean.reject_low */

    double                          threshold                             ; /* The parameter of ifs.spectra_positions.threshold */

    int                             minpix                                ; /* The parameter of ifs.spectra_positions.minpix */

    double                          angle                                 ; /* The parameter of ifs.spectra_positions.angle */

    short                           dist                                  ; /* The parameter of ifs.spectra_positions.distortion */

    short                           hmode                                 ; /* The parameter of ifs.spectra_positions.hmode */

    short                           header                                ; /* The parameter of ifs.spectra_positions.header */

    short                           correct_nonlin                        ; /* The parameter of ifs.spectra_positions.correct_nonlin */

    cpl_frameset*                   rawframes                             ; /* The IFS_SPECPOS_RAW frames */

    cpl_frame*                      master_flat_frame                     ; /* The IFS_INSTRUMENT_FLAT_FIELD frames */

    cpl_frame*                      master_background_frame               ; /* The IFS_CAL_BACKGROUND frames */

    cpl_frame*                      master_dark_frame                     ; /* The IFS_MASTER_DARK frames */

    cpl_frame*                      model_frame                           ; /* The IFS_LENSLET_MODEL frames */

} sph_ifs_spectra_positions;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ifs_spectra_positions_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ifs_spectra_positions.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ifs_spectra_positions* sph_ifs_spectra_positions_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ifs_spectra_positions_check_frames( sph_ifs_spectra_positions* self );

sph_error_code sph_ifs_spectra_positions_check_params( sph_ifs_spectra_positions* parlist );

cpl_error_code sph_ifs_spectra_positions_run( sph_ifs_spectra_positions* self );

sph_error_code sph_ifs_spectra_positions_delete( sph_ifs_spectra_positions* self );
cpl_parameterlist*  sph_ifs_spectra_positions_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ifs_spectra_positions.c */


/* End of extra function declarations that are defined in sph_ifs_spectra_positions_run.c */



#endif /*SPH_IFS_SPECTRA_POSITIONS_H_*/
