/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IRD_DISTORTION_MAP_H_

#define SPH_IRD_DISTORTION_MAP_H_
#define SPH_IRD_DISTORTION_MAP_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ird_distortion_map that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ird_distortion_map_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    short                           convert                               ; /* The parameter of ird.distortion_map.convert */

    const char*                     outfilename                           ; /* The parameter of ird.distortion_map.outfilename */

    const char*                     pp_outfilename                        ; /* The parameter of ird.distortion_map.point_table_filename */

    int                             coll_alg                              ; /* The parameter of ird.distortion_map.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ird.distortion_map.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ird.distortion_map.clean_mean.reject_low */

    double                          threshold_sigma                       ; /* The parameter of ird.distortion_map.threshold */

    int                             polyfit_order                         ; /* The parameter of ird.distortion_map.fitting_order */

    double                          threshold_length                      ; /* The parameter of ird.distortion_map.max_distortion */

    short                           full_qc                               ; /* The parameter of ird.distortion_map.full-qc */

    short                           user_cent                             ; /* The parameter of ird.distortion_map.user_cent */

    double                          cent_left_x                           ; /* The parameter of ird.distortion_map.cent_left_x */

    double                          cent_left_y                           ; /* The parameter of ird.distortion_map.cent_left_y */

    double                          cent_right_x                          ; /* The parameter of ird.distortion_map.cent_right_x */

    double                          cent_right_y                          ; /* The parameter of ird.distortion_map.cent_right_y */

    short                           align_right                           ; /* The parameter of ird.distortion_map.align_right */

    cpl_frameset*                   rawframes                             ; /* The IRD_DISTORTION_MAP_RAW frames */

    cpl_frame*                      dark_frame                            ; /* The IRD_MASTER_DARK frames */

    cpl_frame*                      insbg_frame                           ; /* The IRD_INS_BG frames */

    cpl_frame*                      insbg_fit_frame                       ; /* The IRD_INS_BG_FIT frames */

    cpl_frame*                      skybg_frame                           ; /* The IRD_SKY_BG frames */

    cpl_frame*                      skybg_fit_frame                       ; /* The IRD_SKY_BG_FIT frames */

    cpl_frame*                      flat_frame                            ; /* The IRD_FLAT_FIELD frames */

    cpl_frame*                      point_pattern_frame                   ; /* The IRD_POINT_PATTERN frames */

} sph_ird_distortion_map;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ird_distortion_map_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ird_distortion_map.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ird_distortion_map* sph_ird_distortion_map_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ird_distortion_map_check_frames( sph_ird_distortion_map* self );

sph_error_code sph_ird_distortion_map_check_params( sph_ird_distortion_map* parlist );

cpl_error_code sph_ird_distortion_map_run( sph_ird_distortion_map* self );

sph_error_code sph_ird_distortion_map_delete( sph_ird_distortion_map* self );
cpl_parameterlist*  sph_ird_distortion_map_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ird_distortion_map.c */


/* End of extra function declarations that are defined in sph_ird_distortion_map_run.c */



#endif /*SPH_IRD_DISTORTION_MAP_H_*/
