/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IRD_KEYWORDS_H_
#define SPH_IRD_KEYWORDS_H_
/*---------------------------------------------------------------------------*/
/*
 * The keywords and corresponding allowed values for IRD are
 * defined in this file.
 * Keywords and values common to all SPHERE instruments are
 * defined in the common API under src/Sphere/sph_common_keywords.h
 */
/*---------------------------------------------------------------------------*/

#define SPH_IRD_KEYWORD_DMS_POS_X                             "ESO INS1 PAC X"
#define SPH_IRD_KEYWORD_DMS_POS_Y                             "ESO INS1 PAC Y"

#define SPH_IRD_KEYWORD_IRD_MODE                              "ESO DRS IRD MODE"
#define SPH_IRD_KEYWORD_MODE_ID                               "ESO DRS IRD MODE ID"
#define SPH_IRD_KEYWORD_COMMON_FILTER_ID                      "ESO DRS IRD COMMON FILTER ID"
#define SPH_IRD_KEYWORD_DUAL_FILTER_ID_LEFT					   "ESO DRS IRD DUAL FILTER ID LEFT"
#define SPH_IRD_KEYWORD_DUAL_FILTER_ID_RIGHT				   "ESO DRS IRD DUAL FILTER ID RIGHT"
#define SPH_IRD_KEYWORD_COMMON_FILTER_LAMBDA                  "ESO DRS IRD COMMON FILTER LAMBDA"
#define SPH_IRD_KEYWORD_DUAL_FILTER_LAMBDA_LEFT				   "ESO DRS IRD DUAL FILTER LAMBDA LEFT"
#define SPH_IRD_KEYWORD_DUAL_FILTER_LAMBDA_RIGHT			   "ESO DRS IRD DUAL FILTER LAMBDA RIGHT"
#define SPH_IRD_KEYWORD_ND_FILTER_ID						   "ESO DRS IRD ND FILTER ID"
#define SPH_IRD_KEYWORD_HWP2_SETTING						   "ESO DRS IRD HWP2 SETTING"
#define SPH_IRD_KEYWORD_COMMON_FILTER_NAME                     "ESO INS1 OPTI2 NAME"
#define SPH_IRD_KEYWORD_DUAL_FILTER_NAME_LEFT				   "ESO DRS IRD DUAL FILTER NAME LEFT"
#define SPH_IRD_KEYWORD_DUAL_FILTER_NAME_RIGHT				   "ESO DRS IRD DUAL FILTER NAME RIGHT"
#define SPH_IRD_KEYWORD_ND_FILTER_NAME						   "ESO DRS IRD ND FILTER NAME"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE1_LINE1_WIDTH		   "ESO DRS WIDTH OF SOURCE 1 SPECTRAL LINE 1"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE1_LINE1_LAMBDA		   "ESO DRS WAVEL. OF SOURCE 1 SPECTRAL LINE 1"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE1_LINE2_WIDTH		   "ESO DRS WIDTH OF SOURCE 1 SPECTRAL LINE 2"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE1_LINE2_LAMBDA		   "ESO DRS WAVEL. OF SOURCE 1 SPECTRAL LINE 2"

#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE2_LINE1_WIDTH		   "ESO DRS WIDTH OF SOURCE 2 SPECTRAL LINE 1"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE2_LINE1_LAMBDA		   "ESO DRS WAVEL. OF SOURCE 2 SPECTRAL LINE 1"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE2_LINE2_WIDTH		   "ESO DRS WIDTH OF SOURCE 2 SPECTRAL LINE 2"
#define SPH_IRD_KEYWORD_SPEC_RES_SOURCE2_LINE2_LAMBDA		   "ESO DRS WAVEL. OF SOURCE 2 SPECTRAL LINE 2"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_X_COMMENT                "X position of spectral resolution check line [px](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_X                        "ESO QC SPEC RES POSX LINE"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_Y_COMMENT                "Y position of spectral resolution check line [px](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_Y                        "ESO QC SPEC RES POSY LINE"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_WIDTHX_COMMENT           "X width of spectral resolution check line [px](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_WIDTHX                   "ESO QC SPEC RES WIDTHX LINE"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_LAMBDA_COMMENT           "X position of spectral resolution check line [micron](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_LAMBDA                   "ESO QC SPEC RES LAMBDA LINE"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_LAMBDA_WIDTH_COMMENT     "X width of spectra resolution check line [micron](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LINE_LAMBDA_WIDTH             "ESO QC SPEC RES LAMBDA WIDTH LINE"
//descr Number of good columns
#define SPH_IRD_KEYWORD_WAVECALIB_NGOODLINES_COMMENT           "Number of good spectral regions / Columns [1]"
#define SPH_IRD_KEYWORD_WAVECALIB_NGOODLINES                   "ESO QC WAVECAL NGOODCOLUMNS"
#define SPH_IRD_KEYWORD_WAVECALIB_NBADLINES_COMMENT            "Number of bad spectral regions / columns [1]"
#define SPH_IRD_KEYWORD_WAVECALIB_NBADLINES                    "ESO QC WAVECAL NBADCOLUMNS"
#define SPH_IRD_KEYWORD_WAVECALIB_NNOFITLINES_COMMENT          "Number of spectral regions/columns wothout fit [1]"
#define SPH_IRD_KEYWORD_WAVECALIB_NNOFITLINES                  "ESO QC WAVECAL NNOFITCOLUMNS"
#define SPH_IRD_KEYWORD_WAVECALIB_Y0_MEAN_COMMENT              "Mean minimum wavelength [micron]"
#define SPH_IRD_KEYWORD_WAVECALIB_Y0_MEAN                      "ESO QC WAVECAL Y0 MEAN"
#define SPH_IRD_KEYWORD_WAVECALIB_Y0_RMS_COMMENT               "RMS of minimum wavelength [micron]"
#define SPH_IRD_KEYWORD_WAVECALIB_Y0_RMS                       "ESO QC WAVECAL Y0 RMS"
#define SPH_IRD_KEYWORD_WAVECALIB_C1_MEAN_COMMENT              "Mean slope of wavelength solution [micron/pix]"
#define SPH_IRD_KEYWORD_WAVECALIB_C1_MEAN                      "ESO QC WAVECAL C1 MEAN"
#define SPH_IRD_KEYWORD_WAVECALIB_C1_RMS_COMMENT               "RMS of mean slope of wavelength solution [micron/pix]"
#define SPH_IRD_KEYWORD_WAVECALIB_C1_RMS                       "ESO QC WAVECAL C1 RMS"

#define SPH_IRD_KEYWORD_WAVECALIB_Y0_COMMENT                   "Minimum wavelength for spectral region/column [micron]"
#define SPH_IRD_KEYWORD_WAVECALIB_Y0                           "ESO QC WAVECAL Y0 COL"
#define SPH_IRD_KEYWORD_WAVECALIB_C1_COMMENT                   "Slope of wavelength solution for spectral region/column [micron/pix]"
#define SPH_IRD_KEYWORD_WAVECALIB_C1                           "ESO QC WAVECAL C1 COL"
#define SPH_IRD_KEYWORD_WAVECALIB_CHI_COMMENT                  "CHI2 of wavelength solution for spectral region/column [micron2]"
#define SPH_IRD_KEYWORD_WAVECALIB_CHI                          "ESO QC WAVECAL CHI2 COL"

#define SPH_IRD_KEYWORD_WAVECALIB_QC_LAM_COMMENT               "Wavelength of line [micron]"
#define SPH_IRD_KEYWORD_WAVECALIB_QC_LAM                       "ESO QC WAVECAL LAM LINE"
#define SPH_IRD_KEYWORD_WAVECALIB_QC_LAMRMS_COMMENT            "RMS of line wavelength [micron]"
#define SPH_IRD_KEYWORD_WAVECALIB_QC_LAMRMS                    "ESO QC WAVECAL LAM RMS LINE"

#define SPH_IRD_KEYWORD_WAVECALIB_ESTIM_LINE_POS_LEFT_COMMENT  "Position of line in left image [px](unused)"
#define SPH_IRD_KEYWORD_WAVECALIB_ESTIM_LINE_POS_LEFT          "ESO QC WAVECAL L LINE PIXPOS"
#define SPH_IRD_KEYWORD_WAVECALIB_ESTIM_LINE_POS_RIGHT_COMMENT "Position of line in right image [px](unused)"
#define SPH_IRD_KEYWORD_WAVECALIB_ESTIM_LINE_POS_RIGHT         "ESO QC WAVECAL R LINE PIXPOS"

#define SPH_IRD_KEYWORD_CORO_ATTN_LEFT_COMMENT                 "Flux attenuation by coronagraph in left image [ratio]"
#define SPH_IRD_KEYWORD_CORO_ATTN_LEFT		                   "ESO DRS IRD CORO ATTN LEFT"
#define SPH_IRD_KEYWORD_CORO_ATTN_RIGHT_COMMENT                "Flux attenuation by coronagraph in right image [ratio]"
#define SPH_IRD_KEYWORD_CORO_ATTN_RIGHT		                   "ESO DRS IRD CORO ATTN RIGHT"
#define SPH_IRD_KEYWORD_FLUX_LEFT_COMMENT                      "Total flux in left image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_LEFT		                       "ESO DRS IRD INS COUNT LEFT"
#define SPH_IRD_KEYWORD_FLUX_RIGHT_COMMENT                     "Total flux in right image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_RIGHT		                       "ESO DRS IRD INS COUNT RIGHT"
#define SPH_IRD_KEYWORD_FLCORR_LEFT_COMMENT                    "Flux correction for left image [erg cm^-2 A^-1 / ADU]"
#define SPH_IRD_KEYWORD_FLCORR_LEFT                            "ESO DRS IRD INS FLCORR LEFT"
#define SPH_IRD_KEYWORD_FLCORR_RIGHT_COMMENT                   "Flux correction for right image [erg cm^-2 A^-1 / ADU]"
#define SPH_IRD_KEYWORD_FLCORR_RIGHT                           "ESO DRS IRD INS FLCORR RIGHT"
#define SPH_IRD_KEYWORD_FLUX_LEFT_CORO_COMMENT                 "Total star flux in left coro image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_LEFT_CORO		                   "ESO QC IRD COUNT LEFT CORO ON"
#define SPH_IRD_KEYWORD_FLUX_RIGHT_CORO_COMMENT                "Total star flux in right coro image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_RIGHT_CORO		                   "ESO QC IRD COUNT RIGHT CORO ON"
#define SPH_IRD_KEYWORD_FLUX_LEFT_NO_CORO_COMMENT   		   "Total star flux in left non-coro image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_LEFT_NO_CORO		               "ESO QC IRD COUNT LEFT CORO OFF"
#define SPH_IRD_KEYWORD_FLUX_RIGHT_NO_CORO_COMMENT   		   "Total star flux in right non-coro image [ADU]"
#define SPH_IRD_KEYWORD_FLUX_RIGHT_NO_CORO		               "ESO QC IRD COUNT RIGHT CORO OFF"
#define SPH_IRD_KEYWORD_SPEC_RES_SPATIAL_RES_COMMENT           "Average spatial line FWHM [px](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_SPATIAL_RES                   "ESO QC AVERAGE SPATIAL LINE FWHM"
#define SPH_IRD_KEYWORD_SPEC_RES_LAMBDA_RES_COMMENT            "Average line FWHM [micron](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_LAMBDA_RES                    "ESO QC AVERAGE WAVELENGTH LINE FWHM"
#define SPH_IRD_KEYWORD_SPEC_RES_RESPOWER_COMMENT              "Average spectral resolving power [scalar](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_RESPOWER                      "ESO QC RESOLVING POWER"
#define SPH_IRD_KEYWORD_SPEC_RES_RESPOWER_RMS_COMMENT          "RMS error of average spectral resolving power [1](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_RESPOWER_RMS                  "ESO QC RESOLVING POWER RMS"
#define SPH_IRD_KEYWORD_SPEC_RES_NLINES_COMMENT                "Number of lines used to determine spectral resolution [1](unused)"
#define SPH_IRD_KEYWORD_SPEC_RES_NLINES                        "ESO QC NUM SPEC LINES"
#define SPH_IRD_KEYWORD_STAR_CENTER_NUM_WAFFLE_IMS_COMMENT     "Number of waffle images used [1](unused)"
#define SPH_IRD_KEYWORD_STAR_CENTER_NUM_WAFFLE_IMS		       "ESO DRS SPH IIRD STAR CENTER NUM WAFFLE IMS"
#define SPH_IRD_KEYWORD_DPI_TOTAL_POL_COMMENT                  "Total polarized flux [ADU]"
#define SPH_IRD_KEYWORD_DPI_TOTAL_POL		                   "ESO DRS IRD DPI TOTAL POLARIZATION"
#define SPH_IRD_KEYWORD_DPI_TOTAL_INT_COMMENT                  "Total (intensity) flux [ADU]"
#define SPH_IRD_KEYWORD_DPI_TOTAL_INT	                       "ESO DRS IRD DPI TOTAL INTENSITY"
#define SPH_IRD_KEYWORD_ATMOSPHERIC_AIRMASS_COMMENT			   "Airmass [scalar](unused)"
#define SPH_IRD_KEYWORD_ATMOSPHERIC_AIRMASS		 			   "ESO DRS IRD ATMOSPHERIC AIRMASS"
#define SPH_IRD_KEYWORD_DISTMAP_NPOINTS_OBS_COMMENT            "Number of points found in observed pattern [1]"
#define SPH_IRD_KEYWORD_DISTMAP_NPOINTS_IN_COMMENT             "Number of points expected in input pattern [1]"
#define SPH_IRD_KEYWORD_DISTMAP_OPTICAL_AXIS_X_COMMENT         "X position of optical axis [px]"
#define SPH_IRD_KEYWORD_DISTMAP_OPTICAL_AXIS_Y_COMMENT         "Y position of optical axis [px]"

#define SPH_IRD_KEYWORD_DISTMAP_LEFT_NPOINTS_IN                "ESO QC DISTMAP LEFT NPOINTS IN"
#define SPH_IRD_KEYWORD_DISTMAP_LEFT_NPOINTS_OBS               "ESO QC DISTMAP LEFT NPOINTS OBS"
#define SPH_IRD_KEYWORD_DISTMAP_LEFT_OPTICAL_AXIS_Y            "ESO QC DISTMAP LEFT OPT AXIS Y"
#define SPH_IRD_KEYWORD_DISTMAP_LEFT_OPTICAL_AXIS_X            "ESO QC DISTMAP LEFT OPT AXIS X"
#define SPH_IRD_KEYWORD_DISTMAP_LEFT_NREMOVED                  "ESO QC DISTMAP LEFT NREMOVED"

#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_NPOINTS_IN                "ESO QC DISTMAP RIGHT NPOINTS IN"
#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_NPOINTS_OBS               "ESO QC DISTMAP RIGHT NPOINTS OBS"
#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_OPTICAL_AXIS_Y            "ESO QC DISTMAP RIGHT OPT AXIS Y"
#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_OPTICAL_AXIS_X            "ESO QC DISTMAP RIGHT OPT AXIS X"
#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_NREMOVED               	"ESO QC DISTMAP RIGHT NREMOVED"

#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_COEFFX               "ESO DRS DIST R X COEFF"
#define SPH_IRD_KEYWORD_DISTMAP_RIGHT_COEFFY               "ESO DRS DIST R Y COEFF"

#define SPH_IRD_KEYWORD_DISTMAP_LEFT_COEFFX               "ESO DRS DIST L X COEFF"
#define SPH_IRD_KEYWORD_DISTMAP_LEFT_COEFFY               "ESO DRS DIST L Y COEFF"

#define SPH_IRD_KEYWORD_ROT_ANGLE_COMMENT                     "Rotation Angle"
#define SPH_IRD_KEYWORD_ROT_ANGLE                             "ESO DRS IRD ROTANGLE"

#define SPH_IRD_KEYWORD_VALUE_DPR_TYPE_DARK                   "DARK"
#define SPH_IRD_KEYWORD_VALUE_DPR_TECH_DARK                   "IMAGE"
#define SPH_IRD_KEYWORD_VALUE_DPR_CATG_DARK                   "CALIB"

#define SPH_IRD_KEYWORD_VALUE_DPR_TYPE_DFF                    "FLAT,LAMP"
#define SPH_IRD_KEYWORD_VALUE_DPR_TECH_DFF                    "IMAGE"
#define SPH_IRD_KEYWORD_VALUE_DPR_CATG_DFF                    "CALIB"

#define SPH_IRD_KEYWORD_VALUE_DPR_TYPE_IRDFLAT                "FLAT,LAMP"
#define SPH_IRD_KEYWORD_VALUE_DPR_TECH_IRDFLAT                "IFU"
#define SPH_IRD_KEYWORD_VALUE_DPR_CATG_IRDFLAT                "CALIB"

#define SPH_IRD_KEYWORD_VALUE_DPR_TYPE_WAVECALIB              "LAMP,WAVE"
#define SPH_IRD_KEYWORD_VALUE_DPR_TECH_WAVECALIB              "IFU"
#define SPH_IRD_KEYWORD_VALUE_DPR_CATG_WAVECALIB              "CALIB"

#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_PIXEL_DESCRIPTION_TAB  "PIXEL_DESCRIPTION_TABLE"

#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_MASTER_DARK            "IRD_MASTER_DARK"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_MASTER_DFF             "IRD_MASTER_DFF"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_MASTER_FLAT            "IRD_MASTER_FLAT"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_STATIC_BADPIXELMAP     "IRD_STATIC_BADPIXELMAP"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_LINEAR_BADPIXELMAP     "IRD_LINEAR_BADPIXELMAP"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_PDT_MASK               "PIXEL_DESCRIPTION_TABLE"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_FFLAMP_SPECTRUM        "FFLAMP_SPECTRUM"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_PIXEL_LINEARITY        "IRD_PIXEL_LINEARITY"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_SCIENCE_DBI        	   "IRD_SCIENCE_DBI"
#define SPH_IRD_KEYWORD_VALUE_PRO_CATG_SCIENCE_IMAGING        "IRD_SCIENCE_IMAGING"

#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_CI					  "CLASSICAL_IMAGING"
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_CI_ID			      1
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_DBI					  "DUAL_IMAGING"
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_DBI_ID			      2
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_DPI					  "DUAL_POLAR"
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_DPI_ID			      3
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_LSS					  "LSS"
#define SPH_IRD_KEYWORD_VALUE_DPR_MODE_LSS_ID			      4
#define SPH_IRD_KEYWORD_VALUE_COMMON_FILTER_NAME1            "COMMON_FILTER_1"
#define SPH_IRD_KEYWORD_VALUE_COMMON_FILTER_NAME2            "COMMON_FILTER_2"
#define SPH_IRD_KEYWORD_VALUE_DUAL_FILTER_NAME1				  "DUAL_FILTER_1"
#define SPH_IRD_KEYWORD_VALUE_DUAL_FILTER_NAME2				  "DUAL_FILTER_2"
#define SPH_IRD_KEYWORD_VALUE_ND_FILTER_NAME1				  "ND_FILTER_1"
#define SPH_IRD_KEYWORD_VALUE_ND_FILTER_NAME2				  "ND_FILTER_2"
#define SPH_IRD_KEYWORD_FLAT_FPN_LEFT_COMMENT                 "FPN of left frame [perc. of mean]"
#define SPH_IRD_KEYWORD_FLAT_FPN_LEFT                         "ESO QC FPN LEFT"
#define SPH_IRD_KEYWORD_FLAT_RMS_LEFT_COMMENT                 "RMS of left frame [1]"
#define SPH_IRD_KEYWORD_FLAT_RMS_LEFT                         "ESO QC RMS LEFT"
#define SPH_IRD_KEYWORD_FLAT_NONLIN_FACTOR_LEFT_COMMENT       "Non-linearity factor of left frame [1]"
#define SPH_IRD_KEYWORD_FLAT_NONLIN_FACTOR_LEFT               "ESO QC FLAT NONLINEARITY L"
#define SPH_IRD_KEYWORD_FLAT_MEAN_COUNT_LEFT_COMMENT          "Mean value of left frame [ADU]"
#define SPH_IRD_KEYWORD_FLAT_MEAN_COUNT_LEFT                  "ESO QC FLAT MEAN LEFT"
#define SPH_IRD_KEYWORD_FLAT_FPN_RIGHT_COMMENT                "FPN of right frame [perc. of mean]"
#define SPH_IRD_KEYWORD_FLAT_FPN_RIGHT                        "ESO QC FPN RIGHT"
#define SPH_IRD_KEYWORD_FLAT_RMS_RIGHT_COMMENT                "RMS of right frame [1]"
#define SPH_IRD_KEYWORD_FLAT_RMS_RIGHT                        "ESO QC RMS RIGHT"
#define SPH_IRD_KEYWORD_FLAT_NONLIN_FACTOR_RIGHT_COMMENT      "Non-linearity factor of right frame [1]"
#define SPH_IRD_KEYWORD_FLAT_NONLIN_FACTOR_RIGHT              "ESO QC FLAT NONLINEARITY R"
#define SPH_IRD_KEYWORD_FLAT_MEAN_COUNT_RIGHT_COMMENT         "Mean value of right frame [ADU]"
#define SPH_IRD_KEYWORD_FLAT_MEAN_COUNT_RIGHT                 "ESO QC FLAT MEAN RIGHT"

#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_LEFT_COMMENT           "Average lamp flux in left frame [ADU/s]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_LEFT                   "ESO QC LAMP FLUX AVG LEFT"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_RIGHT_COMMENT          "Average lamp flux in right frame [ADU/s]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_RIGHT                  "ESO QC LAMP FLUX AVG RIGHT"
#define SPH_IRD_KEYWORD_FLAT_LAMP_COUNTS_LEFT_COMEMNT         "Average total lamp counts in left frame [ADU]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_COUNTS_LEFT                 "ESO QC LAMP ADU AVG LEFT"
#define SPH_IRD_KEYWORD_FLAT_LAMP_COUNTS_RIGHT_COMMENT        "Average total lamp counts in right frame [ADU]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_COUNTS_RIGHT                "ESO QC LAMP ADU AVG RIGHT"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_STDEV_LEFT_COMMENT     "SDEV of avg. lamp flux in left frame [ADU/s]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_STDEV_LEFT             "ESO QC LAMP FLUX STDEV LEFT"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_STDEV_RIGHT_COMMENT    "SDEV of avg. lamp flux in right frame [ADU/s]"
#define SPH_IRD_KEYWORD_FLAT_LAMP_FLUX_STDEV_RIGHT            "ESO QC LAMP FLUX STDEV RIGHT"

#define SPH_IRD_STAR_CENTER_TIME  "SPH IRD STAR CENTER OBSTIME"
#define SPH_IRD_STAR_CENTER_LEFT_X  "SPH IRD STAR CENTER LEFT X"
#define SPH_IRD_STAR_CENTER_LEFT_Y  "SPH IRD STAR CENTER LEFT Y"
#define SPH_IRD_STAR_CENTER_RIGHT_X  "SPH IRD STAR CENTER RIGHT X"
#define SPH_IRD_STAR_CENTER_RIGHT_Y  "SPH IRD STAR CENTER RIGHT Y"

/* sph_ifs_master_dark */

#endif /* SPH_IRD_KEYWORDS_H_ */
