/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IRD_LOCI_H_

#define SPH_IRD_LOCI_H_
#define SPH_IRD_LOCI_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ird_loci that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ird_loci_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     loci_outfilename                      ; /* The parameter of ird.loci.outfilename */

    const char*                     loci_outfilename_left                 ; /* The parameter of ird.loci.left_filename */

    const char*                     loci_outfilename_right                ; /* The parameter of ird.loci.right_filename */

    short                           keep_fctable                          ; /* The parameter of ird.loci.keep_fctable */

    int                             coll_alg                              ; /* The parameter of ird.loci.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ird.loci.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ird.loci.clean_mean.reject_low */

    short                           flag_sdi                              ; /* The parameter of ird.loci.use_sdi */

    double                          Na                                    ; /* The parameter of ird.loci.na */

    double                          Ndelta                                ; /* The parameter of ird.loci.ndelta */

    double                          W                                     ; /* The parameter of ird.loci.w */

    double                          g                                     ; /* The parameter of ird.loci.g */

    double                          minR                                  ; /* The parameter of ird.loci.minr */

    double                          maxR                                  ; /* The parameter of ird.loci.maxr */

    double                          dr                                    ; /* The parameter of ird.loci.dr */

    int                             div_scheme                            ; /* The parameter of ird.loci.div_scheme */

    double                          filter_radius                         ; /* The parameter of ird.loci.filter_radius */

    cpl_frameset*                   rawframes                             ; /* The IRD_LOCI_RAW frames */

    cpl_frame*                      dark_frame                            ; /* The IRD_MASTER_DARK frames */

    cpl_frame*                      flat_frame                            ; /* The IRD_FLAT_FIELD frames */

    cpl_frame*                      distmap_frame                         ; /* The IRD_DISTORTION_MAP frames */

    cpl_frame*                      fcframe                               ; /* The IRD_STAR_CENTER frames */

    cpl_frame*                      filter_frame                          ; /* The IRD_FILTER_TABLE frames */

    cpl_frame*                      static_badpixel_frame                 ; /* The IRD_STATIC_BADPIXELMAP frames */

    cpl_frameset*                   fcasciis                              ; /* The IRD_FCTABLE frames */

} sph_ird_loci;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ird_loci_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ird_loci.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ird_loci* sph_ird_loci_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ird_loci_check_frames( sph_ird_loci* self );

sph_error_code sph_ird_loci_check_params( sph_ird_loci* parlist );

cpl_error_code sph_ird_loci_run( sph_ird_loci* self );

sph_error_code sph_ird_loci_delete( sph_ird_loci* self );
cpl_parameterlist*  sph_ird_loci_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ird_loci.c */


/* End of extra function declarations that are defined in sph_ird_loci_run.c */



#endif /*SPH_IRD_LOCI_H_*/
