/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_science_imaging.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_SCIENCE_IMAGING_GENERAL              = SPH_IRD_SCIENCE_IMAGING_ERR_START + 0;
sph_error_code SPH_IRD_SCIENCE_IMAGING_NO_VALID_DIT_LIST    = SPH_IRD_SCIENCE_IMAGING_ERR_START + 1;

sph_error_code SPH_IRD_SCIENCE_IMAGING_PARAMETER_MISSING    = SPH_IRD_SCIENCE_IMAGING_ERR_START + 3;
sph_error_code SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING       = SPH_IRD_SCIENCE_IMAGING_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_science_imaging_create_plugin ( cpl_plugin * );
static int sph_ird_science_imaging_exec_plugin ( cpl_plugin * );
static int sph_ird_science_imaging_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_science_imaging_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_SCIENCE_IMAGING_RAW         1,500   The raw science frames.\n"
    "IRD_MASTER_DARK                 0,  1   The master dark frame. Should have the same DIT and readout mode\n"
    "                                        as the raw frames. Note that this frame is optional as are the other\n"
    "                                        possible dark/backround frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_INS_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_INS_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s)\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_SKY_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_SKY_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_FLAT_FIELD                  0,  1   The instrument flat. Should have the same filter set as the\n"
    "                                        raw frames.\n"
    "IRD_DISTORTION_MAP              0,  1   The distortion map frame.\n"
    "IRD_STAR_CENTER                 0,  1   The field center frame. This frame must be as produced by the\n"
    "                                        star center recipe. If none are provided the recipe attempts\n"
    "                                        a fallback solution or makes use of the optional ASCII field center tables if provided.\n"
    "IRD_FCTABLE                     0, -1   Alternative input of set of of files of ASCII tables. The tables should each give one row\n"
    "                                        for each input science image (so, if e.g. 5 cubes of each 10 planes are this\n"
    "                                        frameset should contain 5 tables with 10 rows) with the columns centre-x centre-y centre-x centre-y angle\n"
    "                                        where centers for left and right field of view are given in pixel coordinates inside\n"
    "                                        the left/right subframe.\n"
    "IRD_STATIC_BADPIXELMAP          0,  1   An optional static badpixelmap. If a dark is given the badpixels\n"
    "                                        that are masked out before the fit are all pixels marked as bad\n"
    "                                        in this as well as in the dark frame. If no dark is given pixels\n"
    "                                        marked in this frame are marked as bad in the raw frames.\n"
    "IRD_FILTER_TABLE                0,  1   A filter table, when present used to determine the wavelength for the Strehl estimation.\n"
    "                                        This is a static calibration frame describing the IRDIS filters.\n"
    "                                        The format of the FITS table is\n"
    "                                                  \n"
    "                                        10A        10A       D           D            D          D\n"
    "                                        filter_key filter_id lambda_left lambda_right width_left width_right\n"
    "                                                  \n"
    "IRD_PHOT_STAR_TABLE             0,  1   A table containing names and fluxes of standard stars. Needs to be present\n"
    "                                        if zero-point determination is required.\n"
    "                                                  \n"
    "                                        Format of the first extension:\n"
    "                                        32A     10A    32A     D   D   D   D   D\n"
    "                                        Target  SpT    Catalog RA  DEC J   H   K\n"
    "                                                  \n"
    "                                        The following extensions are also tables, they have the same name of the\n"
    "                                        Neutral Density Filter employed and a column for each supported filter.\n"
    "                                                  \n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO INS1 PAC X                double No        The dithering position in X for the frame in pixels. \n"
    "ESO INS1 PAC Y                double No        The dithering position in Y for the frame in pixels. \n"
    "ESO INS CPRT POSANG           double Yes       The rotation angle of frame in degrees. Only needed if ADI selected. \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates the reduced science frames for\n"
    "all science observations with IRDIS in classical imaging mode.  The recipe\n"
    "supports dithered frame combination, but does not currently support any\n"
    "frame de-rotation. Use the ***sph_ird_science_dbi*** recipe for cases when de-rotation\n"
    "is needed.\n"
    "The frames are reduced in the following steps:\n"
    "1.  The input raw frames are dark subtracted, see below\n"
    "\n"
    "2.  a flat field is divided out if it is provided\n"
    "\n"
    "3.  a badpixel map is created for each frame that contains the union of\n"
    "    all dark and flat\n"
    "\n"
    "    field badpixels ***(does not work)***\n"
    "\n"
    "4.  the left and right IRDIS subframes are extracted using the IRDIS\n"
    "    instrument model\n"
    "\n"
    "    as specified in the header of the flat field (if provided) or the\n"
    "    default model otherwise.\n"
    "\n"
    "Now, for each of the subframes the processing is as follows:\n"
    "\n"
    "1.  high frequency filtering ***(switched off by default)***. If\n"
    "    the filter radius $f_r$ is set to a value larger than 0, a top\n"
    "\n"
    "    hat frequency filter is applied, masking out all frequencies above\n"
    "    the value of $f > f_r \times f_{max}$,\n"
    "\n"
    "    where $f_{max}$ is the maximum frequency in the FFT. For noise\n"
    "    filterings a value between 0.9 and 0.99 are\n"
    "\n"
    "    good values to use for $f_r$.\n"
    "\n"
    "2.  FFT shifting of image to recenter the image\n"
    "\n"
    "3.  Application of the distortion map to image\n"
    "\n"
    "4.  Shifting and distortion map application to badpixel map using\n"
    "    geometrical approach\n"
    "\n"
    "All these processed frames are then saved as temporary files. Then these\n"
    "frames are combined using the\n"
    "\n"
    "selected combination algorithm.\n"
    "\n"
    "-   if a weighted mean is selected, a weightmap is calculated first\n"
    "    taking the median frame as a reference frame and\n"
    "\n"
    "    weighing down the other frames depending on the difference in\n"
    "    values. Note that this is still a very experimental option and\n"
    "\n"
    "    it is still to be defined what weighting sheme would be optimal. All\n"
    "    badpixels get assigned the weight of 0. Frames are then\n"
    "\n"
    "    combined taking the individual weights into account.\n"
    "\n"
    "-   if a mean is selected, frames are combined using a mean, after first\n"
    "    rejecting all bad pixels.\n"
    "\n"
    "-   if a median is selected, frames are combined by taking the median\n"
    "    pixel value at each pixel position. This procedure\n"
    "\n"
    "    ignores the badpixels.\n"
    "\n"
    "The obtained combined results for the left and right IRDIS field of view\n"
    "are saved in a single FITS file with 8 extensions, following\n"
    "\n"
    "the layout for a double master frame: the first four extensions being\n"
    "the image, badpixelmap, N map, and rms for the left field and\n"
    "\n"
    "the second set of four extensions being the equivalent for the right\n"
    "field.\n"
    "\n"
    "Some additional notes:\n"
    "\n"
    "-   For a point-source an estimate of the Strehl ratio may be useful.\n"
    "    The presence of a filter table frame will enable the estimation,\n"
    "    which on failure will do nothing and on success will insert Strehl\n"
    "    related QC parameters into each product header.\n"
    "\n"
    "-   If additionally a standard star table is supplied and the target\n"
    "    observed can be found in that table, an estimate of the zeropoint is\n"
    "    also computed.\n"
    "\n"
    "Dark handling:\n"
    "\n"
    "This recipe will not run without a supplied dark or background frame.\n"
    "\n"
    "Possible frames to be subtracted are SKY_BG_FIT, SKY_BG,\n"
    "INS_BG_FIT, INS_BG, and MASTER_DARK.\n"
    "\n"
    "DIT and readout mode should match the science data, but this is not\n"
    "verified by the recipe!\n"
    "\n"
    "For everything except MASTER_DARK, it is a wise idea to also match the\n"
    "filter configuration!\n"
    "\n"
    "Strehl Ratio Calculation:\n"
    "\n"
    "The recipe calculates the Strehl Ratio following these steps:\n"
    "1.  Optionally correct the residual local sky background evaluated in an\n"
    "    annular region centered on the expected peak of the Point Spread\n"
    "    Function (PSF). The region extendes between bg_r1 and bg_r2. The\n"
    "    center is the centroid of the apertures found in the image.\n"
    "\n"
    "2.  The PSF is identified and its integrated flux is normalized to 1.\n"
    "    The flux is integrated in a circular region having radius star_r;\n"
    "\n"
    "3.  The PSF barycentre is computed and used to generate the theoretical\n"
    "    normalised PSF. It depends on the pixel scale (PIXSCAL extracted\n"
    "    from the raw header) and on the nomial filter wavelength extracted\n"
    "    from SPH_IRD_TAG_FILTER_TABLE_CALIB;\n"
    "\n"
    "4.  The Strehl Ratio is the ratio between the maximum intensities of the\n"
    "    PSF and the theoretical PSF.\n"
    "\n"
    "\n"
    "\n"
    "\n"
    "Zeropoint Calculation:\n"
    "\n"
    "The recipe calculates the Zeropoint following these steps:\n"
    "1.  The zeropoint calculation uses the integrated flux ($f$) of the star\n"
    "    determined as part of the Strehl Ratio computation;\n"
    "\n"
    "2.  The standard star magnitude ($m$) is extracted from\n"
    "    SPH_IRD_TAG_PHOT_TABLE_CALIB according to the filter employed;\n"
    "\n"
    "3.  The exposure time ($t$) is extracted from the raw header;\n"
    "\n"
    "4.  The zeropoint is calculated as:\n"
    "\n"
    "    $$z = m + 2.5 * log10(f/t)$$\n"
    "\n"
    "5.  The zeropoint $z$ is corrected by a correction factor $c$ extracted\n"
    "    from the appropriate extension of\n"
    "    SPH_IRD_TAG_FILTER_TABLE_CALIB:\n"
    "\n"
    "    $$z_c = z - c$$\n"
    "\n"
    "6.  Both $z$ and $z_c$ are written in the output products as QC\n"
    "    parameters, e.g. for the left field we have ESO QC ZPOINT LEFT and\n"
    "    ESO QC ZPOINTCORR LEFT respectively;\n"
    "\n"
    "If you provide more than one of the optional frames, a choice will be\n"
    "made according to the following priorization:\n"
    "\n"
    "1.  If a SKY_BG_FIT is available, this one is chosen.\n"
    "\n"
    "2.  Else if a SKY_BG is available, this one is chosen.\n"
    "\n"
    "3.  Else if an INS_BG_FIT is available, this one is chosen.\n"
    "\n"
    "4.  Else if an INS_BG is available, this one is chosen.\n"
    "\n"
    "5.  Else if a MASTER_DARK is available, this one is chosen.\n"
    "\n"
    "6.  Else an error will be thrown and execution terminated.\n"
    "\n"
    "\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_SCIENCE_IMAGING                FITS[Im(4)]    The main science frame. The FITS file contains 4 extensions: the image, the\n"
    "                                        badpixels, the rms error and a weightmap. All show the whole detector.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_science_imaging Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_science_imaging.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_SCIENCE_IMAGING_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_science_imaging",
                        "Science calibration, imaging mode.",
                        sph_ird_science_imaging_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_science_imaging_create_plugin,
                        sph_ird_science_imaging_exec_plugin,
                        sph_ird_science_imaging_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_imaging_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_science_imaging_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_SCIENCE_IMAGING_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_science_imaging_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_science_imaging_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_imaging_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_science_imaging*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_science_imaging_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_science_imaging_run( sph_recipe );

        sph_ird_science_imaging_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_imaging_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_science_imaging struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_science_imaging_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.science_imaging.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.science_imaging",
                                   "science_imaging.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.outfilename_left",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.science_imaging",
                                   "science_imaging_left.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.outfilename_right",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.science_imaging",
                                   "science_imaging_right.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.science_imaging.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median. "
                                   ,"ird.science_imaging",
                                   1 ,
                                   2,0,1);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.keep_fctable",
                                   CPL_TYPE_BOOL,
                                   "if set to TRUE the recipes internall created field center tables are not deleted. "
                                   ,"ird.science_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.save_addprod",
                                   CPL_TYPE_BOOL,
                                   "if set to TRUE the recipe will save additional products (left and write fields, in this case!) "
                                   ,"ird.science_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.use_adi",
                                   CPL_TYPE_BOOL,
                                   "Flag to control usage of ADI. "
                                   ,"ird.science_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.full_frameset_speck",
                                   CPL_TYPE_BOOL,
                                   "This sets whether speckle frames should be calculated per cube (if set to FALSE) or for "
                                   "the full set of frames (TRUE, default) "
                                   ,"ird.science_imaging",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.science_imaging.transform_method",
                                   CPL_TYPE_INT,
                                   "Transform method to use. 0 is FFT, 1 is CPL_WARP (interpolation). "
                                   ,"ird.science_imaging",
                                   0 ,
                                   2,0,1);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.science_imaging.filter_method",
                                   CPL_TYPE_INT,
                                   "FFT filter method to use. 0 is none, 1 is top hat filter, 2 is Fermi filter, 3 is Butterworth filter. "
                                   ,"ird.science_imaging",
                                   0 ,
                                   4,0,1,2,3);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.science_imaging.filter_rad",
                                   CPL_TYPE_DOUBLE,
                                   "Radius for FFT top hat and Fermi filters. "
                                   "A non zero value leads to suppression "
                                   "of high frequencies in the fourier domain before frame combination. The value "
                                   "expresses the minimum unsuppressed frequency as fraction of total frequency "
                                   "domain radius (a value of 1 would suppress essentially all frequencies). "
                                   ,"ird.science_imaging",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.science_imaging.fermi_temp",
                                   CPL_TYPE_DOUBLE,
                                   "The temperature parameter for the Fermi filter. "
                                   ,"ird.science_imaging",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.science_imaging.butter_pass",
                                   CPL_TYPE_DOUBLE,
                                   "The pass band frequency for the Butterworth filter, as fraction of total frequency domain radius. "
                                   ,"ird.science_imaging",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.science_imaging.butter_stop",
                                   CPL_TYPE_DOUBLE,
                                   "The stop band frequency for the Butterworth filter, as fraction of total frequency domain radius. "
                                   "This must be larger than the pass frequency. "
                                   ,"ird.science_imaging",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.star_r",
                                   CPL_TYPE_DOUBLE,
                                   "The star radius [arcsecond] used for the Strehl ratio estimate. A negative value "
                                   "disables the estimation. When AO is enabled and 0 (default) is provided 2 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to 277 PIXEL is used. This option is ignored in absence of a "
                                   "IRD_FILTER_TABLE frame. "
                                   ,"ird.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.bg_r1",
                                   CPL_TYPE_DOUBLE,
                                   "The internal radius [arcsecond] of the background used for the Strehl ratio estimate. "
                                   "When AO is enabled and 0 (default) is provided 2 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to 277 PIXEL is used. "
                                   "This option is ignored in absence of a IRD_FILTER_TABLE frame. "
                                   ,"ird.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.science_imaging.bg_r2",
                                   CPL_TYPE_DOUBLE,
                                   "The external radius [arcsecond] of the background used for the Strehl ratio estimate. "
                                   "When AO is enabled and 0 (default) is provided 3 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to all the PIXELS in the image is used. "
                                   "This option is ignored in absence of a IRD_FILTER_TABLE frame. "
                                   ,"ird.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_science_imaging_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_science_imaging_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_science_imaging
           structure.
 @param    self     the sph_ird_science_imaging recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_science_imaging_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_science_imaging_check_frames( sph_ird_science_imaging* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SCIENCE_IMAGING_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_SCIENCE_IMAGING_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SCIENCE_IMAGING_RAW);
        rerr = SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO INS1 PAC X") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO INS1 PAC X") == CPL_TYPE_DOUBLE )  {
                         if ( cpl_propertylist_get_double(pl,"ESO INS1 PAC X") >= -5000.0 && 
                             cpl_propertylist_get_double(pl,"ESO INS1 PAC X") <= 5000.0) okval=1;
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO INS1 PAC X from file %s. "
                         "that has __type double "
                         "and values between -5000.0 and 5000.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO INS1 PAC Y") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO INS1 PAC Y") == CPL_TYPE_DOUBLE )  {
                         if ( cpl_propertylist_get_double(pl,"ESO INS1 PAC Y") >= -5000.0 && 
                             cpl_propertylist_get_double(pl,"ESO INS1 PAC Y") <= 5000.0) okval=1;
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO INS1 PAC Y from file %s. "
                         "that has __type double "
                         "and values between -5000.0 and 5000.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->dark_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    if ( ! self->dark_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    if ( ! self->insbg_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    if ( ! self->insbg_fit_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    if ( ! self->skybg_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    if ( ! self->skybg_fit_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->flat_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    if ( ! self->flat_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FLAT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->distmap_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_CALIB );
    if ( ! self->distmap_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract distmap_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DISTORTION_MAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->distmap_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STAR_CENTER_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->fcframe = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STAR_CENTER_CALIB );
    if ( ! self->fcframe )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract fcframe frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STAR_CENTER_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->fcframe, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FCTABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->fcasciis = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_FCTABLE_CALIB );
    if ( ! self->fcasciis )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract fcasciis frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FCTABLE_CALIB);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->fcasciis );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->fcasciis );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FILTER_TABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->filter_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FILTER_TABLE_CALIB );
    if ( ! self->filter_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract filter_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FILTER_TABLE_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->filter_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_PHOT_TABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->star_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_PHOT_TABLE_CALIB );
    if ( ! self->star_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract star_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_PHOT_TABLE_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->star_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_science_imaging
           structure.
 @param    self     the sph_ird_science_imaging recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_science_imaging_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_science_imaging_check_params( sph_ird_science_imaging* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.outfilename");
    }

    self->science_imaging_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.outfilename_left");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.outfilename_left");
    }

    self->science_imaging_outfilename_left = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.outfilename_right");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.outfilename_right");
    }

    self->science_imaging_outfilename_right = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.keep_fctable");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.keep_fctable");
    }

    self->keep_fctable = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.save_addprod");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.save_addprod");
    }

    self->save_addprod = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.use_adi");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.use_adi");
    }

    self->flag_adi = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.full_frameset_speck");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.full_frameset_speck");
    }

    self->fullset = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.transform_method");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.transform_method");
    }

    self->transform_method = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.filter_method");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.filter_method");
    }

    self->filter_method = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.filter_rad");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.filter_rad");
    }

    self->filter_radius = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.fermi_temp");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.fermi_temp");
    }

    self->fermi_temp = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.butter_pass");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.butter_pass");
    }

    self->butter_pass = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.butter_stop");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.butter_stop");
    }

    self->butter_stop = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.star_r");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.star_r");
    }

    self->star_r = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.bg_r1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.bg_r1");
    }

    self->bg_r1 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_imaging.bg_r2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_imaging.bg_r2");
    }

    self->bg_r2 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_science_imaging structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_science_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_science_imaging* sph_ird_science_imaging_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_science_imaging*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_science_imaging) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_SCIENCE_IMAGING_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_science_imaging_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_science_imaging_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_science_imaging_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_science_imaging structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_science_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_science_imaging_delete( sph_ird_science_imaging* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->dark_frame != NULL ) {
        cpl_frame_delete( self->dark_frame );
        self->dark_frame = NULL;
    }
    if ( self->insbg_frame != NULL ) {
        cpl_frame_delete( self->insbg_frame );
        self->insbg_frame = NULL;
    }
    if ( self->insbg_fit_frame != NULL ) {
        cpl_frame_delete( self->insbg_fit_frame );
        self->insbg_fit_frame = NULL;
    }
    if ( self->skybg_frame != NULL ) {
        cpl_frame_delete( self->skybg_frame );
        self->skybg_frame = NULL;
    }
    if ( self->skybg_fit_frame != NULL ) {
        cpl_frame_delete( self->skybg_fit_frame );
        self->skybg_fit_frame = NULL;
    }
    if ( self->flat_frame != NULL ) {
        cpl_frame_delete( self->flat_frame );
        self->flat_frame = NULL;
    }
    if ( self->distmap_frame != NULL ) {
        cpl_frame_delete( self->distmap_frame );
        self->distmap_frame = NULL;
    }
    if ( self->fcframe != NULL ) {
        cpl_frame_delete( self->fcframe );
        self->fcframe = NULL;
    }
    if ( self->fcasciis != NULL ) {
        cpl_frameset_delete( self->fcasciis );
        self->fcasciis = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
    if ( self->filter_frame != NULL ) {
        cpl_frame_delete( self->filter_frame );
        self->filter_frame = NULL;
    }
    if ( self->star_frame != NULL ) {
        cpl_frame_delete( self->star_frame );
        self->star_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
