/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_science_spectroscopy.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_SCIENCE_SPECTROSCOPY_GENERAL              = SPH_IRD_SCIENCE_SPECTROSCOPY_ERR_START + 0;
sph_error_code SPH_IRD_SCIENCE_SPECTROSCOPY_NO_VALID_DIT_LIST    = SPH_IRD_SCIENCE_SPECTROSCOPY_ERR_START + 1;

sph_error_code SPH_IRD_SCIENCE_SPECTROSCOPY_PARAMETER_MISSING    = SPH_IRD_SCIENCE_SPECTROSCOPY_ERR_START + 3;
sph_error_code SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING       = SPH_IRD_SCIENCE_SPECTROSCOPY_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_science_spectroscopy_create_plugin ( cpl_plugin * );
static int sph_ird_science_spectroscopy_exec_plugin ( cpl_plugin * );
static int sph_ird_science_spectroscopy_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_science_spectroscopy_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_SCIENCE_SPECTROSCOPY_RAW    1,500   The raw spectroscopy frames.\n"
    "IRD_MASTER_DARK                 0,  1   The master dark. This frame should have the same DIT\n"
    "                                        and read out mode as the raw frames.\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_INS_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_INS_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s)\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_SKY_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_SKY_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames. In total however, one dark or background\n"
    "                                        frame is mandatory!\n"
    "IRD_FLAT_FIELD                  1,  1   The instrument flat, taken with the same filter and mode settings\n"
    "                                        as the raw frames\n"
    "IRD_ATMOSPHERIC                 0,  1   The atmospheric telluric line calibration to apply.\n"
    "                                        The airmass used in the atmospheric calibration should match that of the science observation.\n"
    "IRD_STATIC_BADPIXELMAP          0,  1   An optional static badpixelmap. If a dark is given the badpixels\n"
    "                                        that are masked out before the fit are all pixels marked as bad\n"
    "                                        in this as well as in the dark frame. If no dark is given pixels\n"
    "                                        marked in this frame are marked as bad in the raw frames.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates the actual science frames for spectroscopy mode.\n"
    "In spectroscopy mode, frames are not dithered and so this recipe performs a simple processing of dark subtraction and flat fielding before\n"
    "using a user specified method to combine the frames. If a atmospheric calibration is provided this is subtracted from the result.\n"
    "KNOWN ISSUES:\n"
    "-------------\n"
    "The recipe is not using the wavelength calibration file. In order to remove\n"
    "the effects of the wavelength dependence of the flat, the recipe should really\n"
    "use a series of flats taken at different wavelengths and construct a 'super' flat\n"
    "from this using the wavelength calibration file, in the same way as this is\n"
    "done for IFS. However, it is not clear if this is in fact required or if the\n"
    "wavelength dependence of the flat has too small an effect on the spectroscopic\n"
    "data reduction to make it necessary to perfom this wavelength dependent\n"
    "calibration.\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_SCIENCE_SPECTROSCOPY_LEFT      FITS[Im(4)]    The reduced spectroscopy frame of the left FOV. This frame contains a\n"
    "                                        full detector image with the 2D spectrum. The format is FITS with\n"
    "                                        4 extensions, the actual image data, the badpixels, the ncombmap\n"
    "                                        (how many frames contributed to each pixel), and a RMS map.\n"
    "IRD_SCIENCE_SPECTROSCOPY_RIGHT     FITS[Im(4)]    Same as the above, but for the right FOV\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_science_spectroscopy Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_science_spectroscopy.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_SCIENCE_SPECTROSCOPY_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_science_spectroscopy",
                        "Science calibration, spectroscopy mode.",
                        sph_ird_science_spectroscopy_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_science_spectroscopy_create_plugin,
                        sph_ird_science_spectroscopy_exec_plugin,
                        sph_ird_science_spectroscopy_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_spectroscopy_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_science_spectroscopy_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_SCIENCE_SPECTROSCOPY_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_science_spectroscopy_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_science_spectroscopy_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_spectroscopy_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_science_spectroscopy*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_science_spectroscopy_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_science_spectroscopy_run( sph_recipe );

        sph_ird_science_spectroscopy_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_science_spectroscopy_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_science_spectroscopy struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_science_spectroscopy_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.science_spectroscopy.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.science_spectroscopy",
                                   "science_spectroscopy.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.science_spectroscopy.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median. "
                                   ,"ird.science_spectroscopy",
                                   0 ,
                                   2,0,1);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_science_spectroscopy_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_science_spectroscopy_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_science_spectroscopy
           structure.
 @param    self     the sph_ird_science_spectroscopy recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_science_spectroscopy_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_science_spectroscopy_check_frames( sph_ird_science_spectroscopy* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_RAW);
        rerr = SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    if ( ! self->insbg_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    if ( ! self->insbg_fit_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    if ( ! self->skybg_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    if ( ! self->skybg_fit_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_flat_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    if ( ! self->master_flat_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract master_flat_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FLAT_CALIB);
        rerr = SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->master_flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_ATMOSPHERIC_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->atmospheric_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_ATMOSPHERIC_CALIB );
    if ( ! self->atmospheric_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract atmospheric_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_ATMOSPHERIC_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->atmospheric_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_science_spectroscopy
           structure.
 @param    self     the sph_ird_science_spectroscopy recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_science_spectroscopy_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_science_spectroscopy_check_params( sph_ird_science_spectroscopy* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_spectroscopy.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_spectroscopy.outfilename");
    }

    self->outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.science_spectroscopy.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.science_spectroscopy.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_science_spectroscopy structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_science_spectroscopy_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_science_spectroscopy* sph_ird_science_spectroscopy_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_science_spectroscopy*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_science_spectroscopy) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_SCIENCE_SPECTROSCOPY_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_science_spectroscopy_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_science_spectroscopy_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_science_spectroscopy_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_science_spectroscopy structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_science_spectroscopy_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_science_spectroscopy_delete( sph_ird_science_spectroscopy* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->insbg_frame != NULL ) {
        cpl_frame_delete( self->insbg_frame );
        self->insbg_frame = NULL;
    }
    if ( self->insbg_fit_frame != NULL ) {
        cpl_frame_delete( self->insbg_fit_frame );
        self->insbg_fit_frame = NULL;
    }
    if ( self->skybg_frame != NULL ) {
        cpl_frame_delete( self->skybg_frame );
        self->skybg_frame = NULL;
    }
    if ( self->skybg_fit_frame != NULL ) {
        cpl_frame_delete( self->skybg_fit_frame );
        self->skybg_fit_frame = NULL;
    }
    if ( self->master_flat_frame != NULL ) {
        cpl_frame_delete( self->master_flat_frame );
        self->master_flat_frame = NULL;
    }
    if ( self->atmospheric_frame != NULL ) {
        cpl_frame_delete( self->atmospheric_frame );
        self->atmospheric_frame = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
